/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.base.driver.common;

import java.io.File;
import java.io.FileNotFoundException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.transform.stream.StreamSource;
import oracle.install.commons.base.driver.common.InstallerErrorCode;
import oracle.install.commons.base.driver.common.InstallerException;
import oracle.install.commons.base.driver.common.ResponseFileSource;
import oracle.install.commons.base.driver.common.SetupDriver;
import oracle.install.commons.base.driver.common.SetupDriverException;
import oracle.install.commons.base.interview.common.util.PrereqExecutor;
import oracle.install.commons.base.resource.StringResourceBundle;
import oracle.install.commons.base.util.PlatformInfo;
import oracle.install.commons.base.util.cli.CommandLineArgErrorCode;
import oracle.install.commons.base.util.cli.CommandLineArgumentHandler;
import oracle.install.commons.bean.BeanStoreException;
import oracle.install.commons.bean.BeanStoreUtils;
import oracle.install.commons.bean.xml.XmlBeanStoreFormat;
import oracle.install.commons.bean.xml.XmlBeanStoreFormatRegistry;
import oracle.install.commons.flow.FlowApplication;
import oracle.install.commons.flow.FlowBuilder;
import oracle.install.commons.flow.FlowConfigException;
import oracle.install.commons.flow.FlowContext;
import oracle.install.commons.flow.FlowDataRecorder;
import oracle.install.commons.flow.FlowExecutionMode;
import oracle.install.commons.flow.FlowExecutor;
import oracle.install.commons.flow.FlowExecutorType;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.ApplicationEvent;
import oracle.install.commons.util.ApplicationListener;
import oracle.install.commons.util.ApplicationWarning;
import oracle.install.commons.util.ExitStatus;
import oracle.install.commons.util.Resource;
import oracle.install.commons.util.UIType;
import oracle.install.commons.util.exception.Advice;
import oracle.install.commons.util.exception.ApplicationException;
import oracle.install.commons.util.exception.DefaultErrorMessage;
import oracle.install.commons.util.exception.ErrorInfo;
import oracle.install.commons.util.exception.ExceptionManager;
import oracle.install.commons.util.message.Content;
import oracle.install.commons.util.progress.ProgressModel;

public class Installer
extends FlowApplication {
    public static final String RESTART_SESSION_VAR = "oracle.install.restartSession";
    public static final String UPDATES_SILENT_VAR = "oracle.install.silentModeForInstallUpdates";
    public static final String OLD_SCRATCH_LOC_VAR = "oracle.install.oldScratchLocation";
    private static final Logger logger = Logger.getLogger(Installer.class.getName());
    private boolean executePrereqs;
    private boolean silent;
    private PrereqExecutor prereqExecutor;
    private File responseFile;
    private boolean showProgress;
    protected String psuDownLoadLoc;
    protected String oneOffDownLoadLoc;
    protected String opatchLocation;
    private boolean downloadUpdates;
    private boolean noVariblesPassedAtCmdLine;
    protected String ORACLE_HOME;
    protected String ORACLE_BASE;
    protected String INVENTORY_LOCATION;
    private boolean showUsageMode;
    private boolean waitMode = true;
    private final String installContext = "Install";

    public PrereqExecutor getPrereqExecutor() {
        return this.prereqExecutor;
    }

    public void setPrereqExecutor(PrereqExecutor prereqExecutor) {
        this.prereqExecutor = prereqExecutor;
    }

    @Override
    protected void showUsage() {
        Object setupDriver = SetupDriver.getInstance();
        ((SetupDriver)setupDriver).showUsage();
        this.showUsageMode = true;
    }

    @Override
    protected FlowExecutor getFlowExecutor() {
        return this.executePrereqs && this.prereqExecutor != null ? this.prereqExecutor : super.getFlowExecutor();
    }

    @Override
    protected void processArguments(List<String> args) throws IllegalArgumentException {
        boolean noBootStrap = false;
        boolean silentPassedByUser = false;
        boolean passSilentForUpdates = false;
        CommandLineArgumentHandler cmdlineArgHandler = CommandLineArgumentHandler.getInstance();
        boolean skipArgsValidation = true;
        cmdlineArgHandler.processCommandLineArguments(args, skipArgsValidation);
        if (cmdlineArgHandler.isArgumentPassed("help")) {
            this.showUsage();
            this.shutdown();
        }
        if (cmdlineArgHandler.isArgumentPassed("deinstall") && (Boolean.getBoolean("oracle.installer.setupWizard") || Boolean.getBoolean("oracle.installer.gridConfig"))) {
            this.showDeinstallUsage();
            this.shutdown();
        }
        if (cmdlineArgHandler.isArgumentPassed("nowait")) {
            this.waitMode = false;
        }
        if (cmdlineArgHandler.isArgumentPassed("silent")) {
            this.silent = true;
            this.setUIType(UIType.NONE);
        }
        try {
            boolean skipCLIValidator = Boolean.getBoolean("application.commandline.skipCLIValidator");
            cmdlineArgHandler.processCommandLineArguments(args, skipCLIValidator);
            Iterator<String> i = args.iterator();
            while (i.hasNext()) {
                String command = i.next();
                if ("-textual".equals(command)) {
                    this.setUIType(UIType.TEXTUAL);
                    i.remove();
                    continue;
                }
                if ("-executePrereqs".equalsIgnoreCase(command)) {
                    this.executePrereqs = true;
                    i.remove();
                    continue;
                }
                if ("-restart".equalsIgnoreCase(command)) {
                    System.setProperty(RESTART_SESSION_VAR, "true");
                    i.remove();
                    continue;
                }
                if ("-ouifromLocation".equalsIgnoreCase(command)) {
                    i.remove();
                    command = i.next();
                    i.remove();
                    continue;
                }
                if ("-ouiResponseFile".equalsIgnoreCase(command)) {
                    i.remove();
                    command = i.next();
                    i.remove();
                    continue;
                }
                if ("-downloadUpdates".equalsIgnoreCase(command)) {
                    this.downloadUpdates = true;
                    i.remove();
                    continue;
                }
                if ("-oPatchUpdate".equalsIgnoreCase(command)) {
                    i.remove();
                    continue;
                }
                if ("-suppressRootMessage".equalsIgnoreCase(command)) {
                    i.remove();
                    continue;
                }
                if ("-showProgress".equalsIgnoreCase(command)) {
                    this.showProgress = true;
                    i.remove();
                    continue;
                }
                if ("-deinstall".equalsIgnoreCase(command)) {
                    i.remove();
                    continue;
                }
                if ("-ignorePrereq".equalsIgnoreCase(command)) {
                    i.remove();
                    continue;
                }
                if ("-skipPrereq".equalsIgnoreCase(command)) {
                    i.remove();
                    continue;
                }
                if ("-skipPrereqs".equalsIgnoreCase(command)) {
                    i.remove();
                    continue;
                }
                if ("-ignorePrereqFailure".equalsIgnoreCase(command)) {
                    i.remove();
                    continue;
                }
                if ("-IgnoreInternalDriverError".equalsIgnoreCase(command)) {
                    i.remove();
                    continue;
                }
                if ("-promptForPassword".equalsIgnoreCase(command)) {
                    i.remove();
                    continue;
                }
                if ("-lenientInstallMode".equalsIgnoreCase(command)) {
                    i.remove();
                    continue;
                }
                if ("-applyRU".equalsIgnoreCase(command) || "-applyPSU".equalsIgnoreCase(command) || "-applyRUR".equalsIgnoreCase(command)) {
                    i.remove();
                    this.psuDownLoadLoc = i.next();
                    i.remove();
                    continue;
                }
                if ("-applyOneOffs".equalsIgnoreCase(command)) {
                    i.remove();
                    this.oneOffDownLoadLoc = i.next();
                    i.remove();
                    continue;
                }
                if ("-applyInstallerUpdates".equalsIgnoreCase(command)) {
                    passSilentForUpdates = true;
                    i.remove();
                    command = i.next();
                    i.remove();
                    continue;
                }
                if ("-executeConfigTools".equalsIgnoreCase(command)) {
                    i.remove();
                    continue;
                }
                if ("-createGoldImage".equalsIgnoreCase(command)) {
                    i.remove();
                    continue;
                }
                if ("-sourceHome".equalsIgnoreCase(command)) {
                    i.remove();
                    i.next();
                    i.remove();
                    continue;
                }
                if ("-destinationLocation".equalsIgnoreCase(command)) {
                    i.remove();
                    i.next();
                    i.remove();
                    continue;
                }
                if ("-exclFiles".equalsIgnoreCase(command)) {
                    i.remove();
                    i.next();
                    i.remove();
                    continue;
                }
                if ("-force".equalsIgnoreCase(command)) {
                    i.remove();
                    continue;
                }
                if ("-all".equalsIgnoreCase(command)) {
                    i.remove();
                    continue;
                }
                if ("-name".equalsIgnoreCase(command)) {
                    i.remove();
                    i.next();
                    i.remove();
                    continue;
                }
                if ("-recreateFilesList".equalsIgnoreCase(command)) {
                    i.remove();
                    continue;
                }
                if ("-recreateFilesListInternal".equalsIgnoreCase(command)) {
                    i.remove();
                    continue;
                }
                if ("-format".equalsIgnoreCase(command)) {
                    i.remove();
                    i.next();
                    i.remove();
                    continue;
                }
                if ("-tarLocation".equalsIgnoreCase(command)) {
                    i.remove();
                    i.next();
                    i.remove();
                    continue;
                }
                if ("-gzipLocation".equalsIgnoreCase(command)) {
                    i.remove();
                    i.next();
                    i.remove();
                    continue;
                }
                if ("-noTarCompression".equalsIgnoreCase(command)) {
                    i.remove();
                    continue;
                }
                if ("-skipStackCheck".equalsIgnoreCase(command)) {
                    i.remove();
                    continue;
                }
                if ("-suppressRootMessage".equalsIgnoreCase(command)) {
                    i.remove();
                    continue;
                }
                if ("-silent".equalsIgnoreCase(command)) {
                    silentPassedByUser = true;
                    continue;
                }
                if ("-opatchLocation".equalsIgnoreCase(command)) {
                    i.remove();
                    this.opatchLocation = i.next();
                    i.remove();
                    continue;
                }
                if ("-ORACLE_HOME".equalsIgnoreCase(command)) {
                    i.remove();
                    this.ORACLE_HOME = i.next();
                    i.remove();
                    continue;
                }
                if ("-ORACLE_BASE".equalsIgnoreCase(command)) {
                    i.remove();
                    this.ORACLE_BASE = i.next();
                    i.remove();
                    continue;
                }
                if ("-INVENTORY_LOCATION".equalsIgnoreCase(command)) {
                    i.remove();
                    this.INVENTORY_LOCATION = i.next();
                    i.remove();
                    continue;
                }
                if ("-skipOpatchVersionCheck".equalsIgnoreCase(command)) {
                    i.remove();
                    continue;
                }
                if ("-switchGridHome".equalsIgnoreCase(command)) {
                    i.remove();
                    continue;
                }
                if ("-downgrade".equalsIgnoreCase(command)) {
                    i.remove();
                    continue;
                }
                if ("-oldHome".equalsIgnoreCase(command)) {
                    i.remove();
                    i.next();
                    i.remove();
                    continue;
                }
                if ("-nodes".equalsIgnoreCase(command)) {
                    i.remove();
                    i.next();
                    i.remove();
                    continue;
                }
                if ("-manual".equalsIgnoreCase(command)) {
                    i.remove();
                    continue;
                }
                if ("-auto".equalsIgnoreCase(command)) {
                    i.remove();
                    continue;
                }
                if ("-configmethod".equalsIgnoreCase(command)) {
                    i.remove();
                    i.next();
                    i.remove();
                    continue;
                }
                if ("-sudopath".equalsIgnoreCase(command)) {
                    i.remove();
                    i.next();
                    i.remove();
                    continue;
                }
                if ("-sudousername".equalsIgnoreCase(command)) {
                    i.remove();
                    i.next();
                    i.remove();
                    continue;
                }
                if ("-asmdiskgroupname".equalsIgnoreCase(command)) {
                    i.remove();
                    i.next();
                    i.remove();
                    continue;
                }
                if ("-skipOHCompatibilityCheck".equalsIgnoreCase(command)) {
                    i.remove();
                    continue;
                }
                if ("-sysasmPassword".equalsIgnoreCase(command)) {
                    i.remove();
                    continue;
                }
                if ("-monitorPassword".equalsIgnoreCase(command)) {
                    i.remove();
                    continue;
                }
                if ("-sysPassword".equalsIgnoreCase(command)) {
                    i.remove();
                    continue;
                }
                if ("-systemPassword".equalsIgnoreCase(command)) {
                    i.remove();
                    continue;
                }
                if ("-dbsnmpPassword".equalsIgnoreCase(command)) {
                    i.remove();
                    continue;
                }
                if ("-pdbadminPassword".equalsIgnoreCase(command)) {
                    i.remove();
                    continue;
                }
                if ("-asmsnmpPassword".equalsIgnoreCase(command)) {
                    i.remove();
                    continue;
                }
                if ("-emadminPassword".equalsIgnoreCase(command)) {
                    i.remove();
                    continue;
                }
                if ("-stdinPasswords".equalsIgnoreCase(command)) {
                    i.remove();
                    continue;
                }
                if (!"-immutablePasswordPrompts".equalsIgnoreCase(command)) continue;
                i.remove();
            }
            ArrayList<String> argList = new ArrayList<String>();
            if (passSilentForUpdates && !silentPassedByUser) {
                System.setProperty(UPDATES_SILENT_VAR, "true");
                argList.add("-silent");
            }
            argList.addAll(args);
            Object setupDriver = SetupDriver.getInstance();
            ((SetupDriver)setupDriver).processCommandLine(argList.toArray(new String[0]));
            Properties commandLineArgs = ((SetupDriver)setupDriver).getCommandLineArgs();
            this.noVariblesPassedAtCmdLine = commandLineArgs == null || commandLineArgs.isEmpty();
            int index = -1;
            for (int i2 = 0; i2 < argList.size(); ++i2) {
                if (!((String)argList.get(i2)).equalsIgnoreCase("-responseFile")) continue;
                index = i2;
                break;
            }
            if (index != -1 && index + 1 < argList.size() && !args.get(index + 1).startsWith("-")) {
                this.responseFile = new File((String)argList.get(index + 1));
            }
            if (this.silent && this.showProgress) {
                ((SetupDriver)setupDriver).getProgressUI().setProgressModel(new ProgressModel());
            }
            super.processArguments(argList);
        }
        catch (IllegalArgumentException e) {
            String context = System.getProperty("application.commandline.currentContextId", "Install");
            boolean isInstallContext = context.equalsIgnoreCase("Install");
            if (PlatformInfo.getInstance().isWindows() && !this.silent && isInstallContext) {
                Advice advice = ExceptionManager.advise(new DefaultErrorMessage(e));
                if (advice == Advice.ABORT || advice == Advice.WITHDRAW) {
                    Application application = Application.getInstance();
                    application.shutdown(Application.CommonExitStatus.FAILURE);
                }
            }
            throw e;
        }
    }

    @Override
    protected FlowContext loadFlow() throws FlowConfigException {
        FlowContext flowContext = super.loadFlow();
        Object setupDriver = SetupDriver.getInstance();
        Object setupBean = ((SetupDriver)setupDriver).getSetupBean();
        if (BeanStoreUtils.isBean(setupBean)) {
            flowContext.addBean(setupBean);
            try {
                Content content = BeanStoreUtils.createBeanGridContent(setupBean);
                content.setTitle("Initial values of Setup Properties");
                logger.log(Level.INFO, content.getContent());
            }
            catch (BeanStoreException e) {
                logger.log(Level.WARNING, "Failed while logging initial values of Setup Properties", e);
            }
        }
        return flowContext;
    }

    @Override
    protected void run() {
        System.setProperty("java.security.policy", Installer.class.getResource("installer.policy").toExternalForm());
        Object setupDriver = SetupDriver.getInstance();
        try {
            Resource resource = super.getResource("oracle.install.commons.base.resource.StringResourceBundle");
            String finishText = resource.getString("wizard.btnFinish.text", null, new Object[0]);
            if (finishText != null) {
                Resource res = super.getDefaultResource();
                res.setProperty("wizard.btnFinish.text", finishText);
            }
            Installer.showStatus(resource.getString("Installer.status.loadDriver", "Loading Setup Driver", new Object[0]));
            ((SetupDriver)setupDriver).load();
            Installer.showStatus(resource.getString("Installer.status.registerBean", "Registering Setup Bean", new Object[0]));
            FlowBuilder.getInstance().registerFlowData(((SetupDriver)setupDriver).getSetupBean());
            Runtime.getRuntime().addShutdownHook(new Thread((SetupDriver)setupDriver){
                final /* synthetic */ SetupDriver val$setupDriver;
                {
                    this.val$setupDriver = setupDriver;
                }

                @Override
                public void run() {
                    try {
                        logger.log(Level.INFO, "Unloading Setup Driver");
                        this.val$setupDriver.unload();
                    }
                    catch (Exception e) {
                        System.err.println(e.getMessage());
                    }
                }
            });
        }
        catch (SetupDriverException e) {
            throw new InstallerException((Throwable)e, InstallerErrorCode.INSTALLER_INIT_FAILED, new Object[0]);
        }
        FlowExecutorType executorType = this.silent ? FlowExecutorType.SILENT : FlowExecutorType.INTERACTIVE;
        FlowExecutionMode executionMode = FlowExecutionMode.NEW;
        super.setFlowDataDefaults(((SetupDriver)setupDriver).getCommandLineArgs());
        super.setExecutorType(executorType);
        super.setExecutionMode(executionMode);
        if (this.responseFile != null) {
            this.validateResponseFile(this.responseFile);
            try {
                logger.log(Level.INFO, "Setting Response file data to the Installer");
                super.setFlowDataSource(new ResponseFileSource(this.responseFile));
            }
            catch (FileNotFoundException e) {
                throw new InstallerException(e);
            }
            catch (MalformedURLException e) {
                throw new InstallerException(e);
            }
            catch (SecurityException e) {
                throw new InstallerException((Throwable)e, InstallerErrorCode.RESPONSE_FILE_NOT_ACCESSIBLE, this.responseFile);
            }
        }
        FlowDataRecorder flowDataRecorder = FlowDataRecorder.getInstance();
        flowDataRecorder.setFlowDataSource(this.getFlowDataSource());
        flowDataRecorder.setEnabled(true);
        super.run();
    }

    public void startup(String appConfig, String flowConfig, String ... args) throws ApplicationException {
        super.startup(appConfig, flowConfig, (String)null, (Properties)null, args);
    }

    private void showDeinstallUsage() {
        String oracleHome = System.getProperty("ORACLE_HOME");
        String deinstallHome = (oracleHome == null ? "." : oracleHome) + File.separator + "deinstall" + File.separator + "deinstall";
        ErrorInfo errorInfo = ErrorInfo.getInstance(CommandLineArgErrorCode.INVALID_DEINSTALL_ARGUMENT_ERROR, deinstallHome);
        System.out.println(errorInfo.getMessage());
    }

    public void validateResponseFile(File responseFile) throws InstallerException {
        if (responseFile == null) {
            throw new InstallerException(InstallerErrorCode.INVALID_RESPONSE_FILE, new Object[0]);
        }
        if (!responseFile.exists()) {
            throw new InstallerException(InstallerErrorCode.RESPONSE_FILE_NOT_FOUND, responseFile.getPath());
        }
        CommandLineArgumentHandler cmdLineArgumentHandler = CommandLineArgumentHandler.getInstance();
        if (cmdLineArgumentHandler == null || !cmdLineArgumentHandler.isArgumentPassed("executeConfigTools")) {
            logger.log(Level.INFO, "Validating Response File {0}", responseFile);
            XmlBeanStoreFormatRegistry registry = XmlBeanStoreFormatRegistry.getInstance();
            XmlBeanStoreFormat format = null;
            try {
                format = registry.getFileFormat(responseFile);
            }
            catch (Exception e) {
                throw new InstallerException(e);
            }
            if (format == null) {
                registry = XmlBeanStoreFormatRegistry.getInstance();
                Object[] supportedFileExts = registry.getSupportFileExtensions();
                throw new InstallerException(InstallerErrorCode.UNKNOWN_RESPONSE_FILE_FORMAT, supportedFileExts);
            }
            try {
                format.validate(new StreamSource(responseFile));
            }
            catch (Exception e) {
                throw new InstallerException((Throwable)e, InstallerErrorCode.INVALID_RESPONSE_FILE, responseFile.getPath(), e.getMessage());
            }
        }
    }

    @Override
    public synchronized void shutdown() {
        PlatformInfo platformInfo = PlatformInfo.getInstance();
        String context = System.getProperty("application.commandline.currentContextId", "Install");
        boolean isInstallContext = context.equalsIgnoreCase("Install");
        if (platformInfo.isWindows() && isInstallContext && (this.showUsageMode || Installer.isCommandLineSwitchEnabled("-silent")) && (Boolean.getBoolean("oracle.installer.wait") || this.waitMode)) {
            super.addApplicationListener(new ApplicationListener(){

                @Override
                public void update(ApplicationEvent e) {
                    Application application = Application.getInstance();
                    Resource resource = application.getResource(StringResourceBundle.class.getName());
                    String message = resource.getString("installer.exit.prompt", "\nPlease press Enter to exit...", new Object[0]);
                    System.out.println(message);
                    try {
                        System.in.read();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
        }
        super.shutdown();
    }

    public static abstract class CommandLineOption {
        public static final String EXECUTE_PREREQS = "-executePrereqs";
        public static final String DOWNLOAD_UPDATES = "-downloadUpdates";
        public static final String SILENT = "-silent";
        public static final String SILENT_ARG = "silent";
        public static final String RESPONSE_FILE = "-responseFile";
        public static final String RESTART_COMMAND = "-restart";
        public static final String OUI_FROM_LOC = "-ouifromLocation";
        public static final String OUI_RSP = "-ouiResponseFile";
        public static final String OPATCH_FLAG = "-oPatchUpdate";
        public static final String SHOW_PROGRESS = "-showProgress";
        public static final String VIRTUAL_ACCOUNT = "oracle_install_IsVirtualAccount";
        public static final String LENIENT_INSTALL_MODE = "-lenientInstallMode";
        public static final String IGNORE_PREREQ = "-ignorePrereq";
        public static final String SKIP_PREREQ = "-skipPrereq";
        public static final String SKIP_PREREQS = "-skipPrereqs";
        public static final String IGNORE_PREREQ_FAILURE = "-ignorePrereqFailure";
        public static final String IGNORE_PREREQ_FAILURE_ARG = "ignorePrereqFailure";
        public static final String IGNORE_INTERNAL_DRIVER_ERROR = "-IgnoreInternalDriverError";
        public static final String TEXTUAL = "-textual";
        public static final String DEINSTALL = "-deinstall";
        public static final String PROMPT_FOR_PASSWORD = "-promptForPassword";
        public static final String APPLY_PATCH = "-applyRU";
        public static final String APPLY_PSU = "-applyPSU";
        public static final String APPLY_RUR = "-applyRUR";
        public static final String APPLY_ONEOFFS = "-applyOneOffs";
        public static final String APPLY_INSTALL_UPDATES = "-applyInstallerUpdates";
        public static final String OPATCH_LOCATION = "-opatchLocation";
        public static final String CONFIG_TOOLS = "-executeConfigTools";
        public static final String CREATE_GOLD_IMAGE = "-createGoldImage";
        public static final String SOURCE_HOME = "-sourceHome";
        public static final String DESTINATION_LOCATION = "-destinationLocation";
        public static final String EXCL_FILES = "-exclFiles";
        public static final String SKIP_OPATCH_VER_CHECK = "-skipOpatchVersionCheck";
        public static final String FORCE = "-force";
        public static final String ALL = "-all";
        public static final String NAME = "-name";
        public static final String RECREATE_FILES_LIST = "-recreateFilesList";
        public static final String RECREATE_FILES_LIST_INTERNAL = "-recreateFilesListInternal";
        public static final String FORMAT = "-format";
        public static final String TAR_LOCATION = "-tarLocation";
        public static final String GZIP_LOCATION = "-gzipLocation";
        public static final String NO_TAR_COMPRESSION = "-noTarCompression";
        public static final String SKIP_STACK_CHECK = "-skipStackCheck";
        public static final String SUPPRESS_ROOT_MESSAGE = "-suppressRootMessage";
        public static final String SWITCH_GRID_HOME = "-switchGridHome";
        public static final String DOWNGRADE = "-downgrade";
        public static final String NODES = "-nodes";
        public static final String OLD_HOME = "-oldHome";
        public static final String AUTO = "-auto";
        public static final String MANUAL = "-manual";
        public static final String CONFIG_METHOD = "-configmethod";
        public static final String SUDO_PATH = "-sudopath";
        public static final String SUDO_USER_NAME = "-sudousername";
        public static final String ASM_DISK_GROUP_NAME = "-asmdiskgroupname";
        public static final String SKIP_OH_COMPATIBILITY_CHECK = "-skipOHCompatibilityCheck";
        public static final String SYS_ASM_PASSWORD = "-sysasmPassword";
        public static final String MONITOR_PASSWORD = "-monitorPassword";
        public static final String SYS_PASSWORD = "-sysPassword";
        public static final String SYSTEM_PASSWORD = "-systemPassword";
        public static final String DBSNMP_PASSWORD = "-dbsnmpPassword";
        public static final String PDBADMIN_PASSWORD = "-pdbadminPassword";
        public static final String ASMSNMP_PASSWORD = "-asmsnmpPassword";
        public static final String EMADMIN_PASSWORD = "-emadminPassword";
        public static final String STDIN_PASSWORDS = "-stdinPasswords";
        public static final String IMMUTABLE_PASSWORD_PROMPTS = "-immutablePasswordPrompts";
    }

    public static enum InstallerWarning implements ApplicationWarning
    {
        PREREQS_FAILED_WITH_WARNING,
        PREREQUISITES_IGNORED;


        @Override
        public String getMessage() {
            Application application = Application.getInstance();
            return application.getString(this, new Object[0]);
        }
    }

    public static enum CommonExitStatus implements ExitStatus
    {
        PREREQUISITES_NOT_MET(-3, Level.SEVERE);

        private int intValue;
        private Level level;

        private CommonExitStatus(int intValue, Level level) {
            this.intValue = intValue;
            this.level = level;
        }

        @Override
        public int getIntValue() {
            return this.intValue;
        }

        @Override
        public Level getLevel() {
            return this.level;
        }

        @Override
        public String getMessage() {
            Application application = Application.getInstance();
            return application.getString(this, new Object[0]);
        }
    }
}

