/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.base.interview.common.view;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import oracle.install.commons.base.driver.common.SetupDriver;
import oracle.install.commons.base.driver.common.SetupDriverEvent;
import oracle.install.commons.base.driver.common.SetupDriverException;
import oracle.install.commons.base.driver.common.SetupDriverListener;
import oracle.install.commons.flow.EventType;
import oracle.install.commons.flow.FlowContext;
import oracle.install.commons.flow.FlowControl;
import oracle.install.commons.flow.FlowDirection;
import oracle.install.commons.flow.FlowWorker;
import oracle.install.commons.flow.View;
import oracle.install.commons.flow.annotation.ViewDef;
import oracle.install.commons.swing.CardStack;
import oracle.install.commons.swing.CardStackRegistry;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.Resource;
import oracle.install.commons.util.StatusControl;
import oracle.install.commons.util.progress.Job;
import oracle.install.commons.util.progress.JobHelper;
import oracle.install.commons.util.progress.ProgressPane;
import oracle.install.commons.util.progress.Status;
import oracle.install.commons.util.progress.resource.StringResourceBundle;

@ViewDef(id="SetupUI")
public class SetupGUI
implements View {
    private Resource resource;
    private Resource statusResource;
    private ProgressPane progressPage = new ProgressPane(false);

    public SetupGUI() {
        this.progressPage.setErrorReportingEnabled(true);
        Application application = Application.getInstance();
        this.resource = application.getResource(oracle.install.commons.base.interview.common.resource.StringResourceBundle.class.getName());
        this.statusResource = application.getResource(StringResourceBundle.class.getName());
    }

    @Override
    public Component getView() {
        return this.progressPage;
    }

    @Override
    public void localize(FlowContext flowContext) {
    }

    @Override
    public void onEvent(final FlowContext flowContext, EventType eventType) {
        CardStack cardStack = CardStackRegistry.getCardStack("oracle.install.commons.flow.jewt.cardstack");
        switch (eventType) {
            case INIT: {
                this.progressPage.buildUI();
                Object setupDriver = SetupDriver.getInstance();
                ((SetupDriver)setupDriver).addSetupDriverListener(new SetupDriverListener(){

                    @Override
                    public void update(SetupDriverEvent e) {
                        FlowControl flowControl = flowContext.getFlowControl();
                        Status status = e.getStatus();
                        String message = null;
                        switch (status) {
                            case SUCCEEDED: {
                                if (flowControl != null) {
                                    flowControl.forward();
                                }
                                message = SetupGUI.this.resource.getString("Setup.completion.text", "Installation completed with overall status as {0}", SetupGUI.this.statusResource.getString(status.toString(), status.toString(), new Object[0]));
                                SetupGUI.this.progressPage.log(Level.INFO, message, new Object[0]);
                                break;
                            }
                            case FAILED: 
                            case SUCCEEDED_PARTIALLY: {
                                message = SetupGUI.this.resource.getString("Setup.completion.text", "Setup completed with overall status as {0}", SetupGUI.this.statusResource.getString(status.toString(), status.toString(), new Object[0]));
                                SetupGUI.this.progressPage.log(Level.INFO, message, new Object[0]);
                                flowControl.lock(FlowDirection.FORWARD, false);
                                break;
                            }
                            case INPROGRESS: 
                            case REVERT_INPROGRESS: {
                                flowControl.lock(FlowDirection.FORWARD, true);
                                break;
                            }
                        }
                    }
                });
                this.progressPage.setEnableListnerBasedControlOptions(true);
                this.progressPage.addPropertyChangeListener("ProgressPane.retryOptionSelected", new PropertyChangeListener((SetupDriver)setupDriver){
                    final /* synthetic */ SetupDriver val$setupDriver;
                    {
                        this.val$setupDriver = setupDriver;
                    }

                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                        if (evt.getNewValue() != null && evt.getNewValue() instanceof Job) {
                            final Job failedJob = (Job)evt.getNewValue();
                            FlowWorker worker = FlowWorker.getInstance(flowContext);
                            worker.perform(new Callable<Void>(){

                                @Override
                                public Void call() throws Exception {
                                    try {
                                        val$setupDriver.retry();
                                    }
                                    catch (SetupDriverException e) {
                                        failedJob.handleException(e);
                                    }
                                    return null;
                                }
                            });
                        }
                    }
                });
                this.progressPage.addPropertyChangeListener("ProgressPane.skipOptionSelected", new PropertyChangeListener((SetupDriver)setupDriver){
                    final /* synthetic */ SetupDriver val$setupDriver;
                    {
                        this.val$setupDriver = setupDriver;
                    }

                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                        if (evt.getNewValue() != null && evt.getNewValue() instanceof Job) {
                            final Job jobToSkip = (Job)evt.getNewValue();
                            JobHelper.setStatusRecursively(jobToSkip, Status.IGNORED);
                            FlowWorker worker = FlowWorker.getInstance(flowContext);
                            worker.perform(new Callable<Void>(){

                                @Override
                                public Void call() throws Exception {
                                    try {
                                        val$setupDriver.retry();
                                    }
                                    catch (SetupDriverException e) {
                                        jobToSkip.handleException(e);
                                    }
                                    return null;
                                }
                            });
                        }
                    }
                });
                this.progressPage.addPropertyChangeListener("ProgressPane.revertOptionSelected", new PropertyChangeListener((SetupDriver)setupDriver){
                    final /* synthetic */ SetupDriver val$setupDriver;
                    {
                        this.val$setupDriver = setupDriver;
                    }

                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                        if (evt.getNewValue() != null && evt.getNewValue() instanceof Job) {
                            final Job lastExecutedJob = (Job)evt.getNewValue();
                            FlowWorker worker = FlowWorker.getInstance(flowContext);
                            worker.perform(new Callable<Void>(){

                                @Override
                                public Void call() throws Exception {
                                    try {
                                        val$setupDriver.revert(lastExecutedJob);
                                    }
                                    catch (SetupDriverException e) {
                                        lastExecutedJob.handleException(e);
                                    }
                                    return null;
                                }
                            });
                        }
                    }
                });
                this.progressPage.addPropertyChangeListener("ProgressPane.revertAllOptionSelected", new PropertyChangeListener((SetupDriver)setupDriver){
                    final /* synthetic */ SetupDriver val$setupDriver;
                    {
                        this.val$setupDriver = setupDriver;
                    }

                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                        if (evt.getNewValue() != null && evt.getNewValue() instanceof Job) {
                            final Job lastExecutedJob = (Job)evt.getNewValue();
                            FlowWorker worker = FlowWorker.getInstance(flowContext);
                            worker.perform(new Callable<Void>(){

                                @Override
                                public Void call() throws Exception {
                                    try {
                                        val$setupDriver.revertAll();
                                    }
                                    catch (SetupDriverException e) {
                                        lastExecutedJob.handleException(e);
                                    }
                                    return null;
                                }
                            });
                        }
                    }
                });
                ((SetupDriver)setupDriver).setProgressUI(this.progressPage);
                break;
            }
            case LOAD: {
                Application application = Application.getInstance();
                StatusControl statusControl = application.getStatusControl();
                if (statusControl != null) {
                    statusControl.close();
                }
                cardStack.showCard("oracle.install.commons.flow.jewt.billboard");
                break;
            }
            case UNLOAD: {
                cardStack.showBlankCard();
                break;
            }
        }
    }

    @Override
    public void processInput(FlowContext flowContext) {
    }

    protected ProgressPane getProgressPane() {
        return this.progressPage;
    }
}

