/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.base.prereq;

import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.cluster.verification.ClusterVerification;
import oracle.cluster.verification.FixupException;
import oracle.cluster.verification.FixupManualInstruction;
import oracle.cluster.verification.OverallStatus;
import oracle.cluster.verification.VerificationError;
import oracle.cluster.verification.VerificationException;
import oracle.cluster.verification.VerificationResultSet;
import oracle.cluster.verification.VerificationTask;
import oracle.install.commons.base.prereq.FixupScriptExecutionJob;
import oracle.install.commons.base.prereq.PrereqChecker;
import oracle.install.commons.base.prereq.PrereqCheckerErrorCode;
import oracle.install.commons.base.prereq.PrereqCheckerException;
import oracle.install.commons.base.prereq.ui.FixupDialog;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.Resource;
import oracle.install.commons.util.UIType;
import oracle.install.commons.util.exception.ErrorCode;

public class DefaultPrereqChecker
extends PrereqChecker {
    private static final Logger logger = Logger.getLogger(DefaultPrereqChecker.class.getName());
    private Resource resource = Application.getInstance().getResource("oracle.install.commons.base.prereq.resource.StringResourceBundle");

    @Override
    protected void prepareNodes(String ... nodes) throws VerificationException {
        VerificationResultSet resultSet;
        ClusterVerification cvu = ClusterVerification.getInstance();
        Application application = Application.getInstance();
        boolean tracingEnabled = application.getLogLevel() == Level.FINEST;
        cvu.setTracing(tracingEnabled);
        logger.log(Level.INFO, "CVU tracingEnabled = " + tracingEnabled);
        VerificationResultSet verificationResultSet = resultSet = nodes == null || nodes.length == 0 ? cvu.checkFrameworkSetup() : cvu.checkFrameworkSetup(nodes);
        if (resultSet != null) {
            OverallStatus status = resultSet.getOverallStatus();
            switch (status) {
                case VERIFICATION_FAILED: 
                case OPERATION_FAILED: {
                    StringBuffer buffer = new StringBuffer();
                    List errors = resultSet.getErrors();
                    for (VerificationError error : errors) {
                        buffer.append("- ").append(error.getCause()).append("\n");
                    }
                    logger.log(Level.INFO, "Preparation of nodes for running verifications failed. Reason:\n{0}", buffer.toString());
                    break;
                }
                default: {
                    logger.log(Level.INFO, "Nodes are prepared for verification.");
                }
            }
        }
    }

    @Override
    public void verify() throws Exception {
        ClusterVerification cvu = ClusterVerification.getInstance();
        cvu.getErrorLogs();
        super.verify();
    }

    @Override
    protected void performPostVerifyOper() throws Exception {
        super.performPostVerifyOper();
        this.logCVUErrors();
        ClusterVerification cvu = ClusterVerification.getInstance();
        List<VerificationTask> fixableTasks = this.getFixableVerificationTasks();
        if (fixableTasks == null || fixableTasks.size() == 0) {
            this.setFixableVerificationTasks(cvu.getFixupTaskList());
        }
    }

    @Override
    public void fix() throws PrereqCheckerException {
        Application application = Application.getInstance();
        UIType uiType = application.getUIType();
        if (uiType == UIType.GRAPHICAL) {
            ClusterVerification cvu = null;
            try {
                cvu = ClusterVerification.getInstance();
            }
            catch (VerificationException e) {
                throw new PrereqCheckerException(e);
            }
            String fixupScript = null;
            List failedNodes = null;
            try {
                List<VerificationTask> fixableTasks = null;
                FixupScriptExecutionJob fixupScriptExecJob = this.getFixupScriptExecutionJob();
                fixableTasks = fixupScriptExecJob != null && fixupScriptExecJob.getFixableTasks() != null ? fixupScriptExecJob.getFixableTasks() : this.getFixableVerificationTasks();
                cvu.setupFixups(fixableTasks);
                logger.log(Level.INFO, "quering for fixup execution instructions");
                Application.showStatus(this.resource.getString("DefaultPrereqChecker.waitpanel.generatingScriptMessage", "Generating fixup script...", new Object[0]));
                FixupManualInstruction instruction = cvu.getManualFixupInstruction();
                fixupScript = instruction.getFixupInstruction();
                failedNodes = instruction.getParticipatingNodes();
                Application.hideStatus();
                logger.log(Level.INFO, "Fixup cmd:" + fixupScript + " participating nodes:" + failedNodes);
            }
            catch (FixupException e) {
                logger.log(Level.WARNING, "FixupException while generating the fixup routine: " + e.getMessage());
                throw new PrereqCheckerException((ErrorCode)PrereqCheckerErrorCode.FIXUP_ROUTINES_NOT_AVAILABLE, new Object[0]);
            }
            if (fixupScript != null && failedNodes != null && failedNodes.size() > 0) {
                int selectedOption = FixupDialog.showDialog(null, fixupScript, failedNodes, this.isFixupScriptExecutionSupported());
                if (selectedOption == -1) {
                    throw new PrereqCheckerException((ErrorCode)PrereqCheckerErrorCode.FIXUP_NOT_PERFORMED, new Object[0]);
                }
            } else {
                throw new PrereqCheckerException((ErrorCode)PrereqCheckerErrorCode.FIXUP_NOT_PERFORMED, new Object[0]);
            }
        }
    }

    @Override
    protected void performPostFixupAndVerifyOper() throws Exception {
        super.performPostFixupAndVerifyOper();
        this.logCVUErrors();
        ClusterVerification cvu = ClusterVerification.getInstance();
    }

    protected void logCVUErrors() throws VerificationException {
        ClusterVerification cvu = ClusterVerification.getInstance();
        List errorLogs = cvu.getErrorLogs();
        if (errorLogs != null && errorLogs.size() > 0) {
            logger.log(Level.INFO, "****************** CVU Error logs ******************");
            for (String message : errorLogs) {
                logger.log(Level.INFO, message);
            }
            logger.log(Level.INFO, "*************** End of CVU Error logs ***************");
        }
    }
}

