/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.base.util.cli;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.install.commons.base.util.cli.ArgumentContext;
import oracle.install.commons.base.util.cli.CLIArgument;
import oracle.install.commons.base.util.cli.CommandArgDependencyType;
import oracle.install.commons.base.util.cli.CommandArgType;
import oracle.install.commons.base.util.cli.CommandLineArgErrorCode;
import oracle.install.commons.base.util.cli.CommandLineArgument;
import oracle.install.commons.base.util.cli.CommandLineArgumentDependency;
import oracle.install.commons.base.util.cli.CommandLineArguments;
import oracle.install.commons.base.util.cli.ParentArgumentContext;
import oracle.install.commons.util.exception.ErrorInfo;

public class CommandLineArgHelper {
    public static boolean isCommandArgType(String argStr) {
        for (CommandArgType type : CommandArgType.values()) {
            if (!type.toString().equalsIgnoreCase(argStr)) continue;
            return true;
        }
        return false;
    }

    public static List<String> replaceArgPlaceHolders(List<String> argsToReplace, CommandLineArguments commandLineArguments) {
        if (argsToReplace != null) {
            ArrayList<String> replacedArgsList = new ArrayList<String>();
            for (String arg : argsToReplace) {
                if (arg == null || arg.isEmpty()) continue;
                if (arg.contains("|")) {
                    String[] alternativeArgs = arg.split("\\|");
                    if (alternativeArgs == null || alternativeArgs.length <= 0) continue;
                    StringBuffer resultingString = new StringBuffer();
                    for (String alternativeArg : alternativeArgs) {
                        String replacedString = CommandLineArgHelper.replaceArgPlaceHolder(alternativeArg, commandLineArguments);
                        if (replacedString == null || replacedString.isEmpty()) continue;
                        resultingString.append(replacedString);
                        resultingString.append("|");
                    }
                    String resultingArg = resultingString.toString();
                    if (resultingArg == null || resultingArg.isEmpty()) continue;
                    resultingArg = resultingArg.endsWith("|") ? resultingArg.substring(0, resultingArg.length()) : resultingArg;
                    replacedArgsList.add(resultingArg);
                    continue;
                }
                String replacedString = CommandLineArgHelper.replaceArgPlaceHolder(arg, commandLineArguments);
                if (replacedString == null || replacedString.isEmpty()) continue;
                replacedArgsList.add(replacedString);
            }
            return replacedArgsList;
        }
        return argsToReplace;
    }

    private static String replaceArgPlaceHolder(String argument, CommandLineArguments commandLineArguments) {
        if (argument != null && !argument.isEmpty() && CommandLineArgHelper.isCommandArgType(argument) && commandLineArguments != null) {
            if (CommandArgType.COMMAND.toString().equalsIgnoreCase(argument) && commandLineArguments.getCommandArgs() != null) {
                return CommandLineArgHelper.getStringRepresentationOfArgs(commandLineArguments.getCommandArgs());
            }
            if (CommandArgType.FLAG.toString().equalsIgnoreCase(argument) && commandLineArguments.getFlagArgs() != null) {
                return CommandLineArgHelper.getStringRepresentationOfArgs(commandLineArguments.getFlagArgs());
            }
            if (CommandArgType.OPTION.toString().equalsIgnoreCase(argument) && commandLineArguments.getOptionArgs() != null) {
                return CommandLineArgHelper.getStringRepresentationOfArgs(commandLineArguments.getOptionArgs());
            }
        }
        return argument;
    }

    private static String getStringRepresentationOfArgs(List<String> args) {
        if (args != null) {
            StringBuffer resultingArgStringBuffer = new StringBuffer("");
            for (String arg : args) {
                resultingArgStringBuffer.append(arg);
                resultingArgStringBuffer.append("|");
            }
            String resultingArg = resultingArgStringBuffer.toString();
            return resultingArg.endsWith("|") ? resultingArg.substring(0, resultingArg.length()) : resultingArg;
        }
        return "";
    }

    public static List<String> extractArgs(List<String> targetArgs, Map<String, List<String>> supportedMandatoryDependentGroups, CommandLineArguments commandLineArguments) {
        if (targetArgs != null) {
            ArrayList<String> extractedArgs = new ArrayList<String>();
            for (String targetArg : targetArgs) {
                if ((targetArg = CommandLineArgHelper.replaceArgPlaceHolder(targetArg, commandLineArguments)).contains("|")) {
                    String[] argAlternatives = targetArg.split("\\|");
                    if (argAlternatives == null || argAlternatives.length <= 0) continue;
                    for (String alternative : argAlternatives) {
                        if (alternative.isEmpty()) continue;
                        extractedArgs.add(alternative);
                    }
                    continue;
                }
                extractedArgs.add(targetArg);
            }
            if (supportedMandatoryDependentGroups != null && supportedMandatoryDependentGroups.size() > 0) {
                ArrayList<String> replaceableArgs = new ArrayList<String>();
                for (String extractedArg : extractedArgs) {
                    if (!supportedMandatoryDependentGroups.containsKey(extractedArg)) continue;
                    replaceableArgs.add(extractedArg);
                }
                for (String replaceableArg : replaceableArgs) {
                    extractedArgs.remove(replaceableArg);
                    List<String> argsToBeAdded = CommandLineArgHelper.extractArgs(supportedMandatoryDependentGroups.get(replaceableArg), supportedMandatoryDependentGroups, commandLineArguments);
                    extractedArgs.addAll(argsToBeAdded);
                }
            }
            return extractedArgs;
        }
        return targetArgs;
    }

    public static boolean doesHaveDependencies(CLIArgument targetArg) {
        List<CLIArgument> argDependencies = targetArg.getArgDependencies();
        return argDependencies != null && argDependencies.size() > 0;
    }

    public static Map<String, CommandLineArgumentDependency> resolveArgDependencies(CommandLineArgument targetArg, List<String> passedArgTrace, CommandArgDependencyType dependancyType, String currentContextID) throws IllegalArgumentException {
        boolean doesItHaveContextDependencyRules;
        Map<String, CommandLineArgumentDependency> resultingDependenciesMap = null;
        List<ArgumentContext> contextArgRules = targetArg.getContextSpecifications();
        boolean bl = doesItHaveContextDependencyRules = contextArgRules != null && contextArgRules.size() > 0;
        if (doesItHaveContextDependencyRules) {
            ArgumentContext argumentContextMatch = null;
            ArgumentContext argumentContextDefaultMatch = null;
            for (ArgumentContext currentArgumentContext : contextArgRules) {
                List<String> compatibleContexts = currentArgumentContext.getCompatibleContextIDs();
                if (currentContextID != null && !currentContextID.isEmpty() && compatibleContexts.contains(currentContextID)) {
                    argumentContextMatch = currentArgumentContext;
                    break;
                }
                if (!compatibleContexts.contains("all")) continue;
                argumentContextDefaultMatch = currentArgumentContext;
            }
            if (argumentContextMatch == null && argumentContextDefaultMatch != null) {
                argumentContextMatch = argumentContextDefaultMatch;
            }
            if (argumentContextMatch != null) {
                resultingDependenciesMap = CommandLineArgHelper.resolveParentArgDependencies(argumentContextMatch.getParentArgumentRules(), passedArgTrace, dependancyType);
            }
            if (resultingDependenciesMap != null && resultingDependenciesMap.size() > 0) {
                return resultingDependenciesMap;
            }
        } else {
            resultingDependenciesMap = new HashMap<String, CommandLineArgumentDependency>();
            List<String> depNames = null;
            if (dependancyType == CommandArgDependencyType.MANDATORY) {
                depNames = targetArg.getMandatoryDependentArgs();
            } else if (dependancyType == CommandArgDependencyType.OPTIONAL) {
                depNames = targetArg.getOptionalDependentArgs();
            }
            if (depNames != null) {
                for (String depName : depNames) {
                    resultingDependenciesMap.put(depName, new CommandLineArgumentDependency());
                }
            }
        }
        return resultingDependenciesMap;
    }

    private static Map<String, CommandLineArgumentDependency> resolveParentArgDependencies(List<ParentArgumentContext> parentArgRules, List<String> passedArgTrace, CommandArgDependencyType dependancyType) throws IllegalArgumentException {
        Map<String, CommandLineArgumentDependency> resultingDependenciesMap = null;
        ParentArgumentContext matchCandidate = null;
        for (ParentArgumentContext currentParentRule : parentArgRules) {
            List<String> candidateKeyArgs = currentParentRule.getKeyArguments();
            if (candidateKeyArgs == null) continue;
            int depMatches = 0;
            block1: for (String currentDep : candidateKeyArgs) {
                for (String previousPasedArg : passedArgTrace) {
                    if (!previousPasedArg.equalsIgnoreCase(currentDep)) continue;
                    ++depMatches;
                    continue block1;
                }
            }
            if (depMatches != candidateKeyArgs.size()) continue;
            if (matchCandidate == null) {
                matchCandidate = currentParentRule;
                continue;
            }
            if (depMatches > matchCandidate.getKeyArguments().size()) {
                matchCandidate = currentParentRule;
                continue;
            }
            if (depMatches != matchCandidate.getKeyArguments().size()) continue;
            ErrorInfo errorInfo = ErrorInfo.getInstance(CommandLineArgErrorCode.APPLICATION_CONFLICTING_ARG_DEPENDENCIES_ERROR, Arrays.deepToString(candidateKeyArgs.toArray()));
            throw new IllegalArgumentException(errorInfo.getMessage());
        }
        if (matchCandidate != null) {
            Object dependencyMap = null;
            if (dependancyType == CommandArgDependencyType.MANDATORY) {
                resultingDependenciesMap = matchCandidate.getMandatoryDependencies();
            } else if (dependancyType == CommandArgDependencyType.OPTIONAL) {
                resultingDependenciesMap = matchCandidate.getOptionalDependencies();
            }
        }
        return resultingDependenciesMap;
    }
}

