/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.bean;

import oracle.install.commons.bean.BeanStore;
import oracle.install.commons.bean.BeanStoreException;
import oracle.install.commons.bean.BeanStoreSource;
import oracle.install.commons.bean.xml.XmlBeanStoreFactory;
import oracle.install.commons.util.ProxyFactory;

public abstract class BeanStoreFactory<T extends BeanStore> {
    private static BeanStoreFactory instance = null;

    public static BeanStoreFactory getInstance() {
        if (instance == null && (instance = ProxyFactory.getInstance().createProxy(BeanStoreFactory.class)) == null) {
            instance = new XmlBeanStoreFactory();
        }
        return instance;
    }

    public static <A extends BeanStoreFactory> A getInstance(Class<A> type) {
        if (instance == null || !instance.getClass().equals(type)) {
            try {
                instance = (BeanStoreFactory)type.newInstance();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return (A)instance;
    }

    protected BeanStoreFactory() {
    }

    public T newBeanStore() throws BeanStoreException {
        return this.newBeanStore(null);
    }

    public abstract T newBeanStore(BeanStoreSource var1) throws BeanStoreException;
}

