/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.flow;

import oracle.install.commons.flow.Route;

public class ConditionResult {
    private static final Route ROUTE_MATCHED = new Route("matched");
    private static final Route ROUTE_MISMATCHED = new Route("mismatched");
    public static final ConditionResult MISMATCHED = new ConditionResult(ROUTE_MISMATCHED);
    public static final ConditionResult MATCHED = new ConditionResult(ROUTE_MATCHED);
    public static final ConditionResult MATCHED_PERPETUALLY = new ConditionResult(ROUTE_MATCHED, true);
    private boolean conditionMatched;
    private Route route;
    private boolean perpetual;

    public ConditionResult() {
        this(null, false);
    }

    public ConditionResult(Route route) {
        this(route, false);
    }

    public ConditionResult(Route route, boolean perpetual) {
        this.route = route;
        this.perpetual = perpetual;
        this.conditionMatched = route != null && !route.equals(ROUTE_MISMATCHED);
    }

    public ConditionResult(boolean conditionMatched, Route route, boolean perpetual) {
        this.route = route;
        this.perpetual = perpetual;
        this.conditionMatched = conditionMatched;
    }

    public boolean isConditionMatched() {
        return this.conditionMatched;
    }

    public Route getRoute() {
        return this.route;
    }

    public boolean isPerpetual() {
        return this.perpetual;
    }
}

