/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.flow;

import java.util.logging.Logger;
import oracle.install.commons.flow.AbstractFlowExecutor;
import oracle.install.commons.flow.FlowContext;
import oracle.install.commons.flow.FlowDisplay;
import oracle.install.commons.flow.FlowDisplayAdapter;
import oracle.install.commons.flow.FlowException;
import oracle.install.commons.flow.FlowExecutionMode;
import oracle.install.commons.flow.FlowExecutorType;
import oracle.install.commons.flow.Route;
import oracle.install.commons.flow.State;
import oracle.install.commons.flow.checkpoint.CheckpointHandler;
import oracle.install.commons.flow.validation.ConsoleValidationExceptionHandler;
import oracle.install.commons.flow.validation.ValidationException;
import oracle.install.commons.flow.validation.ValidationStatusMessage;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.Console;
import oracle.install.commons.util.ConsoleStatusControl;
import oracle.install.commons.util.Graph;
import oracle.install.commons.util.StatusMessages;
import oracle.install.commons.util.exception.Advice;
import oracle.install.commons.util.exception.ExceptionManager;
import oracle.install.commons.util.exception.Severity;

public class ConsoleFlowExecutor
extends AbstractFlowExecutor {
    private static Logger logger = Logger.getLogger(ConsoleFlowExecutor.class.getName());
    FlowDisplay flowDisplay = new ConsoleFlowDisplay();

    public ConsoleFlowExecutor() {
        ExceptionManager.getInstance().addExceptionHandler(ValidationException.class, new ConsoleValidationExceptionHandler());
    }

    @Override
    protected FlowExecutionMode confirmSessionContinuation() {
        FlowExecutionMode flowExecutionMode = FlowExecutionMode.NEW;
        String input = Console.getInput("Do you like to continue the previous session ? [Y]es or [N]o");
        if (input != null && input.equalsIgnoreCase("N")) {
            flowExecutionMode = FlowExecutionMode.CONTINUE;
            CheckpointHandler checkpointHandler = CheckpointHandler.getInstance();
            checkpointHandler.reset(this.flowContext);
        }
        return flowExecutionMode;
    }

    @Override
    public void execute() {
        Application.getInstance().setStatusControl(new ConsoleStatusControl());
        logger.info("Executing Flow in Interactive Mode with Console Based User Interface.");
        ExceptionManager em = ExceptionManager.getInstance();
        State state = null;
        do {
            try {
                state = super.nextState();
            }
            catch (FlowException e) {
                em.handleException(e);
            }
            catch (ValidationException e) {
                em.handleException(e);
            }
        } while (state != null);
    }

    @Override
    public FlowExecutorType getFlowExecutorType() {
        return FlowExecutorType.INTERACTIVE;
    }

    @Override
    public FlowDisplay getFlowDisplay() {
        return this.flowDisplay;
    }

    @Override
    protected Advice advise(StatusMessages<ValidationStatusMessage> messages) {
        Advice advice = Advice.CONTINUE;
        Severity severity = ExceptionManager.getSeverity(messages.getAggregateLevel());
        System.out.println("Validation Failed");
        for (ValidationStatusMessage message : messages) {
            System.out.printf("[%s] %s\n", new Object[]{message.getSeverity(), message.getMessage()});
        }
        if (severity == Severity.FATAL) {
            advice = Advice.WITHDRAW;
        } else if (severity == Severity.WARNING) {
            boolean stop = true;
            do {
                String input;
                if ("n".equalsIgnoreCase(input = Console.getInput("\nDo you want to continue ? ([Y]es or [N]o)."))) {
                    advice = Advice.WITHDRAW;
                    break;
                }
                if (!"y".equalsIgnoreCase(input)) continue;
                advice = Advice.CONTINUE;
            } while (!stop);
        }
        return advice;
    }

    class ConsoleFlowDisplay
    extends FlowDisplayAdapter {
        ConsoleFlowDisplay() {
        }

        @Override
        public void display(FlowContext flowContext, Graph<Route, State> vertex) {
            Console.printf("[Stage: %s]\n", vertex.getValue().getId());
        }
    }
}

