/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.flow.jewt;

import java.awt.AWTEvent;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import javax.swing.SwingUtilities;
import oracle.bali.ewt.wizard.Wizard;
import oracle.bali.ewt.wizard.WizardEvent;
import oracle.bali.ewt.wizard.WizardPage;
import oracle.install.commons.flow.FlowContext;
import oracle.install.commons.flow.FlowControl;
import oracle.install.commons.flow.FlowDisplay;
import oracle.install.commons.flow.FlowNavigator;
import oracle.install.commons.flow.Route;
import oracle.install.commons.flow.RoutePlan;
import oracle.install.commons.flow.RoutePlanChangeEvent;
import oracle.install.commons.flow.RoutePlanChangeListener;
import oracle.install.commons.flow.State;
import oracle.install.commons.flow.StateType;
import oracle.install.commons.flow.View;
import oracle.install.commons.flow.jewt.FlowWizardPage;
import oracle.install.commons.util.Graph;

public class FlowWizard
extends Wizard
implements FlowDisplay,
RoutePlanChangeListener {
    private FlowNavigator flowNavigator;
    private List<WizardPage> pages;
    private WizardPage currentPage;
    private boolean jumping;
    private boolean finishing;
    private TransitionManager transitionManager;
    private Runnable doNextTask = new Runnable(){

        @Override
        public void run() {
            FlowWizard.this.jumping = false;
            FlowWizard.this.flowNavigator.goForward();
            FlowWizard.this.jumping = true;
            FlowWizard.this.finishing = false;
        }
    };
    private Runnable doPreviousTask = new Runnable(){

        @Override
        public void run() {
            FlowWizard.this.jumping = false;
            FlowWizard.this.flowNavigator.goBackward();
            FlowWizard.this.jumping = true;
        }
    };

    public FlowWizard() {
        this.pages = new ArrayList<WizardPage>();
        this.transitionManager = new TransitionManager();
    }

    @Override
    public void stateChanged(final RoutePlanChangeEvent changeEvent) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.__updateRoadmap(changeEvent);
        } else {
            FutureTask<Void> updateRoadmapTask = new FutureTask<Void>(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    FlowWizard.this.__updateRoadmap(changeEvent);
                    return null;
                }
            });
            SwingUtilities.invokeLater(updateRoadmapTask);
            try {
                updateRoadmapTask.get();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void __updateRoadmap(RoutePlanChangeEvent changeEvent) {
        RoutePlan routePlan = changeEvent.getSource();
        int eventId = changeEvent.getId();
        State currentState = routePlan.getCurrentVertex().getValue();
        if (this.pages.isEmpty() && currentState.isViewState() || (eventId & 4) == 4) {
            if (routePlan.getTracedPath().isEmpty()) {
                return;
            }
            List<Graph<Route, State>> rolledBackPath = routePlan.getRolledBackPath();
            for (Graph<Route, State> vertex : rolledBackPath) {
                FlowWizardPage mappedPage = FlowWizardPage.getInstance(vertex);
                if (mappedPage == null) continue;
                this.pages.remove((Object)mappedPage);
                super.removePage((WizardPage)mappedPage);
                mappedPage.dispose();
            }
            List<Graph<Route, State>> tentativePath = routePlan.getTentativeTracedPath();
            for (Graph<Route, State> vertex : tentativePath) {
                if (FlowWizardPage.getInstance(vertex) != null) continue;
                FlowWizardPage wizardPage = FlowWizardPage.newBlankInstance(vertex);
                this.pages.add(wizardPage);
                super.addPage((WizardPage)wizardPage);
                switch (wizardPage.getType()) {
                    case 1: {
                        super.setProgressWizardPage((WizardPage)wizardPage);
                        break;
                    }
                    case 2: {
                        super.setEndOfProcessWizardPage((WizardPage)wizardPage);
                    }
                }
            }
        }
    }

    public WizardPage getCurrentPage() {
        return this.currentPage;
    }

    protected void doNext() {
        this.transitionManager.perform(this.doNextTask);
    }

    public void doNext(FlowControl flowControl) {
        this.transitionManager.perform(flowControl, this.doNextTask);
    }

    protected void doPrevious() {
        this.transitionManager.perform(this.doPreviousTask);
    }

    public void doPrevious(FlowControl flowControl) {
        this.transitionManager.perform(flowControl, this.doPreviousTask);
    }

    @Override
    public FlowNavigator getFlowNavigator() {
        return this.flowNavigator;
    }

    @Override
    public void setFlowNavigator(FlowNavigator flowNavigator) {
        this.flowNavigator = flowNavigator;
        RoutePlan routePlan = this.flowNavigator.getRoutePlan();
        routePlan.addRoutePlanChangeListener(this);
        this.removeAllPages();
        this.restart();
    }

    public int getCurrentPageIndex() {
        return Math.max(this.pages.indexOf(this.currentPage), 0);
    }

    public WizardPage getNextPage(WizardPage page) {
        WizardPage nextPage = null;
        int index = this.pages.indexOf(page);
        if (index != -1 && index < this.pages.size() - 1) {
            nextPage = this.pages.get(index + 1);
        }
        return nextPage;
    }

    public WizardPage getPageAt(int index) {
        WizardPage wizardPage = this.pages.get(index);
        if (wizardPage != null) {
            wizardPage.setEnabled(true);
        }
        return this.pages.get(index);
    }

    public int getPageCount() {
        return this.pages.size();
    }

    public void restart() {
        this.jumping = false;
        this.transitionManager.setTransitionInProgress(true);
        this.flowNavigator.reset();
        this.transitionManager.setTransitionInProgress(false);
        this.jumping = true;
    }

    protected void selectPage(final WizardPage page, boolean doValidate) {
        State value;
        FlowWizardPage currentPageFlowWizard;
        Graph<Route, State> vertex;
        if (this.finishing) {
            return;
        }
        if (this.currentPage != null && this.currentPage instanceof FlowWizardPage && (vertex = (currentPageFlowWizard = (FlowWizardPage)this.currentPage).getVertex()) != null && (value = vertex.getValue()) != null) {
            boolean isCurrentPageDecision;
            boolean bl = isCurrentPageDecision = value.getStateType() == StateType.decision;
            if (isCurrentPageDecision && this.pages != null && page != null && this.pages.contains(page) && this.pages.contains(this.currentPage)) {
                boolean isDirectionForward;
                boolean bl2 = isDirectionForward = this.pages.indexOf(page) > this.pages.indexOf(this.currentPage);
                if (isDirectionForward) {
                    return;
                }
            }
        }
        if (this.jumping) {
            this.transitionManager.perform(new Runnable(){

                @Override
                public void run() {
                    if (page != null) {
                        Graph<Route, State> selectedVertex = ((FlowWizardPage)page).getVertex();
                        FlowWizard.this.flowNavigator.moveTo(selectedVertex);
                    }
                }
            });
        } else {
            super.selectPage(page, doValidate);
        }
    }

    @Override
    public void display(FlowContext flowContext, Graph<Route, State> vertex) {
        State state = vertex.getValue();
        if (state != null) {
            View view = state.getView();
            FlowWizardPage wizardPage = FlowWizardPage.getInstance(vertex);
            if (wizardPage != null) {
                if (this.finishing) {
                    super.doFinish();
                }
                Component content = view.getView();
                wizardPage.setContent(content);
                this.currentPage = wizardPage;
                super.selectPage((WizardPage)wizardPage, false);
                if (state.getStateType() == StateType.decision && this.isVisitedLinkEnabled()) {
                    this.resetNextPages(wizardPage);
                    this.processEvent((AWTEvent)new WizardEvent((Object)this, 2001, (WizardPage)wizardPage));
                }
            }
        }
    }

    protected void doFinish() {
        this.finishing = true;
        this.transitionManager.perform(this.doNextTask);
    }

    protected void resetNextPages(WizardPage currentPage) {
        int index;
        if (currentPage != null && (index = this.pages.indexOf(currentPage)) != -1 && index < this.pages.size() - 1) {
            for (int i = index + 1; i < this.pages.size(); ++i) {
                WizardPage nextPage = this.pages.get(i);
                if (nextPage == null) continue;
                nextPage.reset();
            }
        }
    }

    public void moveTo(Graph<Route, State> vertex) {
        FlowWizardPage wizardPage;
        if (vertex != null && (wizardPage = FlowWizardPage.getInstance(vertex)) != null) {
            int pageIdx = Math.max(this.pages.indexOf((Object)wizardPage), 0);
            this.selectPage(wizardPage, this.getCurrentPageIndex() < pageIdx);
        }
    }

    class TransitionManager {
        private ExecutorService executorService = Executors.newSingleThreadExecutor();
        private boolean transitionInProgress = false;

        public void perform(Runnable runnable) {
            this.perform(null, runnable);
        }

        protected void setTransitionInProgress(boolean transitionInProgress) {
            this.transitionInProgress = transitionInProgress;
        }

        public synchronized void perform(FlowControl flowControl, final Runnable runnable) {
            if (!(runnable == null || this.transitionInProgress && flowControl == null)) {
                this.transitionInProgress = true;
                try {
                    this.executorService.submit(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                runnable.run();
                            }
                            finally {
                                TransitionManager.this.transitionInProgress = false;
                            }
                        }
                    });
                }
                catch (Throwable t) {
                    this.transitionInProgress = false;
                }
            }
        }
    }
}

