/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.flow.validation;

import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.install.commons.flow.validation.ActionableStatusMessage;
import oracle.install.commons.flow.validation.ValidationHelper;
import oracle.install.commons.flow.validation.ValidationStatusMessage;
import oracle.install.commons.util.exception.ErrorCode;
import oracle.install.commons.util.exception.Severity;

public abstract class AbstractActionableStatusMessage<T, S>
extends ValidationStatusMessage
implements ActionableStatusMessage<S> {
    private T result;
    private static Logger logger = Logger.getLogger(AbstractActionableStatusMessage.class.getName());

    public AbstractActionableStatusMessage(String message, T result) {
        this(message, null, result);
    }

    public AbstractActionableStatusMessage(Throwable cause, T result) {
        super(cause);
        this.init(result, null);
    }

    public AbstractActionableStatusMessage(String message, Severity severity, T result) {
        super(message, severity);
        this.init(result, severity);
    }

    public AbstractActionableStatusMessage(ErrorCode errorCode, T result, Object ... messageArgs) {
        this(errorCode, (Severity)null, result, messageArgs);
    }

    public AbstractActionableStatusMessage(ErrorCode errorCode, Severity severity, T result, Object ... messageArgs) {
        super(errorCode, severity, messageArgs);
        this.init(result, severity);
    }

    protected void init(T result, Severity severity) {
        this.result = result;
        if (severity == null) {
            Severity newSeverity = ValidationHelper.getActionableValidationSeverity();
            if (newSeverity != null) {
                this.setSeverity(newSeverity);
            } else {
                logger.log(Level.INFO, "Property: actionable.validation.advisor.severity is not specified. So using default severity.");
            }
        }
    }

    public T getResult() {
        return this.result;
    }

    @Override
    public boolean isFixable() {
        return false;
    }

    @Override
    public boolean fix() {
        return true;
    }
}

