/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.flow.validation;

import java.util.ArrayList;
import java.util.List;
import oracle.install.commons.flow.FlowContext;
import oracle.install.commons.flow.Route;
import oracle.install.commons.flow.RoutePlan;
import oracle.install.commons.flow.State;
import oracle.install.commons.flow.validation.ValidationPolicy;
import oracle.install.commons.util.Graph;

public class OptimisticValidationPolicy
implements ValidationPolicy {
    @Override
    public boolean requireValidation(FlowContext flowContext, Graph<Route, State> sourceVertex) {
        return sourceVertex.getValue().isDirty();
    }

    @Override
    public List<Graph<Route, State>> requireValidation(FlowContext flowContext, Graph<Route, State> sourceVertex, Graph<Route, State> destVertex) {
        RoutePlan routePlan = flowContext.getRoutePlan();
        List<Graph<Route, State>> followedPath = routePlan.getFollowedPath();
        ArrayList<Graph<Route, State>> sublist = new ArrayList<Graph<Route, State>>();
        for (Graph<Route, State> vertex : followedPath) {
            if (!vertex.getValue().isDirty()) continue;
            sublist.add(vertex);
        }
        return sublist;
    }
}

