/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.IllegalComponentStateException;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Locale;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleAction;
import javax.accessibility.AccessibleComponent;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleEditableText;
import javax.accessibility.AccessibleIcon;
import javax.accessibility.AccessibleRelationSet;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleSelection;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleTable;
import javax.accessibility.AccessibleText;
import javax.accessibility.AccessibleValue;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ChangeListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.text.JTextComponent;
import javax.swing.text.View;
import oracle.bali.share.nls.StringUtils;
import oracle.install.commons.swing.HidableTableColumnModel;
import oracle.install.commons.swing.LazyTextChangeListenerThread;
import oracle.install.commons.swing.MultilineLabel;
import oracle.install.commons.swing.SortOrder;
import oracle.install.commons.swing.SortableTableModel;
import oracle.install.commons.swing.TableCellListener;
import oracle.install.commons.swing.TogglePane;
import oracle.install.commons.swing.icon.DownArrowIcon;
import oracle.install.commons.swing.icon.UpArrowIcon;
import oracle.install.commons.util.exception.ApplicationException;
import oracle.install.commons.util.exception.CommonErrorCode;
import oracle.install.commons.util.exception.ErrorCode;

public class SwingUtils {
    private static final String MOVE_TO_PREVIOUS_ROW_ACTION = SwingUtils.class.getName() + ".tableAction.moveToPreviousRow";
    private static final String MOVE_TO_PREVIOUS_ROW_ACTION_BACKUP = MOVE_TO_PREVIOUS_ROW_ACTION + ".old";
    private static final String MOVE_TO_NEXT_ROW_ACTION = SwingUtils.class.getName() + ".tableAction.moveToNextRow";
    private static final String MOVE_TO_NEXT_ROW_ACTION_BACKUP = MOVE_TO_NEXT_ROW_ACTION + ".old";
    private static final String MOVE_TO_NEXT_COMPONENT_ACTION = SwingUtils.class.getName() + ".genericAction.moveToNextComponent";
    private static final String MOVE_TO_NEXT_COMPONENT_ACTION_BACKUP = MOVE_TO_NEXT_COMPONENT_ACTION + ".old";
    private static final String MOVE_TO_PREVIOUS_COMPONENT_ACTION = SwingUtils.class.getName() + ".genericAction.moveToPreviousComponent";
    private static final String MOVE_TO_PREVIOUS_COMPONENT_ACTION_BACKUP = MOVE_TO_PREVIOUS_COMPONENT_ACTION + ".old";

    public static Dimension getBestSize(JTextComponent txtComp, Dimension maxSize) {
        Dimension bestSize = new Dimension(maxSize);
        View view = txtComp.getUI().getRootView(txtComp);
        view.setSize(maxSize.width, Float.MAX_VALUE);
        int height = (int)view.getPreferredSpan(1);
        Insets insets = txtComp.getMargin();
        height = insets.top + insets.bottom + height;
        if (height < maxSize.height) {
            bestSize.height = height;
        }
        view.setSize(Float.MAX_VALUE, maxSize.height);
        int width = (int)view.getPreferredSpan(0);
        insets = txtComp.getMargin();
        width = insets.right + insets.left + width;
        if (width < maxSize.width) {
            bestSize.width = width;
        }
        return bestSize;
    }

    public static <A> A invokeTask(Callable<A> callable) {
        A value = null;
        if (SwingUtilities.isEventDispatchThread()) {
            try {
                value = callable.call();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            FutureTask<A> processInputTask = new FutureTask<A>(callable);
            SwingUtilities.invokeLater(processInputTask);
            try {
                value = processInputTask.get();
            }
            catch (ExecutionException e) {
                Throwable t = e.getCause();
                t.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return value;
    }

    public static Component getRoot() {
        return SwingUtils.getRoot(null);
    }

    public static Component getRoot(Component component) {
        Component root = null;
        if (component != null) {
            root = SwingUtilities.getRoot(component);
        } else {
            KeyboardFocusManager focusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            Component lastFocusOwner = focusManager.getPermanentFocusOwner();
            if (lastFocusOwner != null) {
                root = SwingUtilities.getRoot(lastFocusOwner);
            }
        }
        return root;
    }

    private static <A> A createDialog(Class<A> type, Class paramType, Object owner) {
        A instance = null;
        try {
            Constructor<A> constructor = type.getConstructor(paramType);
            instance = constructor.newInstance(owner);
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InstantiationException instantiationException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return instance;
    }

    public static <A extends Dialog> A createDialog(Class<A> type) {
        return SwingUtils.createDialog(null, type);
    }

    public static <A extends Dialog> A createDialog(Component owner, Class<A> type) {
        Dialog dialog = null;
        if (owner == null) {
            KeyboardFocusManager focusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            owner = focusManager.getPermanentFocusOwner();
        }
        Component root = null;
        if (owner != null) {
            root = SwingUtilities.getRoot(owner);
        }
        dialog = root instanceof Dialog ? (Dialog)SwingUtils.createDialog(type, Dialog.class, root) : (root instanceof Frame ? (Dialog)SwingUtils.createDialog(type, Frame.class, root) : (Dialog)SwingUtils.createDialog(type, Frame.class, null));
        return (A)dialog;
    }

    public static void addLazyTextChangeListener(JTextComponent txtComponent, ChangeListener changeListener) {
        LazyTextChangeListenerThread lazyTextChangeListenerThread = LazyTextChangeListenerThread.getInstance(txtComponent);
        lazyTextChangeListenerThread.addChangeListener(changeListener);
    }

    public static void removeLazyTextChangeListener(JTextComponent txtComponent, ChangeListener changeListener) {
        LazyTextChangeListenerThread lazyTextChangeListenerThread = LazyTextChangeListenerThread.getInstance(txtComponent);
        lazyTextChangeListenerThread.removeChangeListener(changeListener);
    }

    public static void scaleFont(Component component, float percentage) {
        if ((double)percentage > 0.0 && percentage <= 2.0f) {
            Font font = component.getFont();
            int size = font.getSize();
            size += Math.round(percentage * (float)size);
            font = new Font(font.getFamily(), font.getStyle(), size);
            component.setFont(font);
        }
    }

    public static String getTextWithoutMnemonics(String text) {
        if (text != null) {
            if (StringUtils.getMnemonicIndex((String)text) != -1) {
                return StringUtils.stripMnemonic((String)text);
            }
            return text;
        }
        return "";
    }

    public static void setText(AbstractButton button, String text) {
        if (button != null && text != null) {
            if (StringUtils.getMnemonicIndex((String)text) != -1) {
                button.setText(StringUtils.stripMnemonic((String)text));
                button.setMnemonic(StringUtils.getMnemonicKeyCode((String)text));
                button.setDisplayedMnemonicIndex(StringUtils.getMnemonicIndex((String)text));
            } else {
                button.setText(text);
            }
        }
    }

    public static void setText(JLabel label, String text) {
        if (label != null && text != null) {
            if (StringUtils.getMnemonicIndex((String)text) != -1) {
                label.setText(StringUtils.stripMnemonic((String)text));
                label.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)text));
                label.setDisplayedMnemonicIndex(StringUtils.getMnemonicIndex((String)text));
            } else {
                label.setText(text);
            }
        }
    }

    public static void addTab(JTabbedPane pane, String text, Component component) {
        if (pane != null && text != null && component != null) {
            if (StringUtils.getMnemonicIndex((String)text) != -1) {
                pane.addTab(StringUtils.stripMnemonic((String)text), component);
                int tabIndex = pane.getTabCount() - 1;
                pane.setDisplayedMnemonicIndexAt(tabIndex, StringUtils.getMnemonicIndex((String)text));
                pane.setMnemonicAt(tabIndex, StringUtils.getMnemonicKeyCode((String)text));
            } else {
                pane.addTab(text, component);
            }
        }
    }

    public static void setComponentEnabled(Component component, boolean enabled) {
        if (component != null) {
            Component[] components;
            if (enabled && component instanceof TogglePane) {
                boolean tpbuttonenabled = ((TogglePane)component).getToggleButton().isSelected();
                ((TogglePane)component).getToggleButton().setEnabled(enabled);
                if (tpbuttonenabled) {
                    SwingUtils.setComponentEnabled(((TogglePane)component).getContent(), tpbuttonenabled);
                }
            } else if (component instanceof Container && (components = ((Container)component).getComponents()) != null) {
                for (Component item : components) {
                    SwingUtils.setComponentEnabled(item, enabled);
                }
            }
            component.setEnabled(enabled);
        }
    }

    public static void setRowWiseFocusTraveralEnabled(JTable table, boolean enabled) {
        SwingUtils.setFocusTraversalEnabled(table, enabled, MOVE_TO_NEXT_ROW_ACTION, MOVE_TO_NEXT_ROW_ACTION_BACKUP, new TableTabAction(table, true), MOVE_TO_PREVIOUS_ROW_ACTION, MOVE_TO_PREVIOUS_ROW_ACTION_BACKUP, new TableTabAction(table, false));
    }

    public static void setGenericFocusTraversalEnabled(JComponent component, boolean enabled) {
        SwingUtils.setFocusTraversalEnabled(component, enabled, MOVE_TO_NEXT_COMPONENT_ACTION, MOVE_TO_NEXT_COMPONENT_ACTION_BACKUP, new GenericTabAction(component, true), MOVE_TO_PREVIOUS_COMPONENT_ACTION, MOVE_TO_PREVIOUS_COMPONENT_ACTION_BACKUP, new GenericTabAction(component, false));
    }

    private static void setFocusTraversalEnabled(JComponent component, boolean enabled, String forwardKey, String oldForwardKey, Action forwardAction, String backwardKey, String oldBackwardKey, Action backwardAction) {
        if (component == null) {
            return;
        }
        InputMap inputMap = component.getInputMap(1);
        ActionMap actionMap = component.getActionMap();
        KeyStroke tabStroke = KeyStroke.getKeyStroke(9, 0, false);
        KeyStroke shiftTabStroke = KeyStroke.getKeyStroke(9, 1, false);
        if (enabled) {
            Object oldTabActionId = inputMap.get(tabStroke);
            if (oldTabActionId != null) {
                component.putClientProperty(MOVE_TO_NEXT_ROW_ACTION_BACKUP, oldTabActionId);
            }
            inputMap.put(tabStroke, MOVE_TO_NEXT_ROW_ACTION);
            actionMap.put(MOVE_TO_NEXT_ROW_ACTION, forwardAction);
            Object oldShiftTabActionId = inputMap.get(shiftTabStroke);
            if (oldShiftTabActionId != null) {
                component.putClientProperty(MOVE_TO_PREVIOUS_ROW_ACTION_BACKUP, oldShiftTabActionId);
            }
            inputMap.put(shiftTabStroke, MOVE_TO_PREVIOUS_ROW_ACTION);
            actionMap.put(MOVE_TO_PREVIOUS_ROW_ACTION, backwardAction);
        } else {
            Object oldTabActionId = component.getClientProperty(MOVE_TO_NEXT_ROW_ACTION_BACKUP);
            if (oldTabActionId != null) {
                inputMap.put(tabStroke, oldTabActionId);
            } else {
                inputMap.remove(tabStroke);
            }
            actionMap.remove(MOVE_TO_NEXT_ROW_ACTION);
            Object oldShiftTabActionId = component.getClientProperty(MOVE_TO_PREVIOUS_ROW_ACTION_BACKUP);
            if (oldShiftTabActionId != null) {
                inputMap.put(tabStroke, oldShiftTabActionId);
            } else {
                inputMap.remove(tabStroke);
            }
            actionMap.remove(MOVE_TO_PREVIOUS_ROW_ACTION);
        }
    }

    public static JCheckBox setCheckedTableColumn(JTable table, int columnIndex, ItemListener ... itemListeners) {
        TableColumnModel columnModel = table.getColumnModel();
        TableColumn column = columnModel.getColumn(columnIndex);
        return SwingUtils.setCheckedTableColumn(table, column, itemListeners);
    }

    public static JCheckBox setCheckedTableColumn(JTable table, TableColumn column, ItemListener ... itemListeners) {
        JCheckBox checkBox = new JCheckBox();
        final TableModel model = table.getModel();
        final TableColumnModel columnModel = table.getColumnModel();
        final TableColumn col = column;
        final CheckboxTableHeaderCellRenderer renderer = new CheckboxTableHeaderCellRenderer(table, checkBox, column);
        if (itemListeners.length == 0) {
            checkBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (renderer.getUpdateColumn()) {
                        boolean selected = e.getStateChange() == 1;
                        int colIndex = -1;
                        for (int j = 0; j < model.getColumnCount(); ++j) {
                            if (!columnModel.getColumn(j).equals(col)) continue;
                            colIndex = j;
                            break;
                        }
                        if (colIndex != -1) {
                            int n = model.getRowCount();
                            for (int i = 0; i < n; ++i) {
                                model.setValueAt(selected, i, colIndex);
                            }
                        }
                    }
                }
            });
        } else {
            for (ItemListener l : itemListeners) {
                checkBox.addItemListener(l);
            }
        }
        column.setHeaderRenderer(renderer);
        table.getTableHeader().addMouseListener(renderer);
        return checkBox;
    }

    public static void setSortableColumnHeader(JTable table, SortableTableModel tableModel, Integer ... columns) {
        if (table != null && tableModel != null && columns != null && columns.length > 0) {
            TableColumnModel columnModel = table.getColumnModel();
            LabelHeaderRenderer renderer = new LabelHeaderRenderer(table, tableModel);
            Integer[] integerArray = columns;
            int n = integerArray.length;
            for (int i = 0; i < n; ++i) {
                int i2 = integerArray[i];
                TableColumn column = columnModel.getColumn(i2);
                column.setHeaderRenderer(renderer);
            }
            JTableHeader header = table.getTableHeader();
            header.setUpdateTableInRealTime(true);
            header.addMouseListener(new SortableTableHeaderListener(table, tableModel));
        }
    }

    public static JSpinner createDescriptiveSpinner(SpinnerNumberModel model, final MultilineLabel lblDescription) {
        JSpinner spinner = new JSpinner(model){
            private AccessibleContext ctxt;

            @Override
            public AccessibleContext getAccessibleContext() {
                if (this.ctxt == null) {
                    this.ctxt = new FormattedAccessibleCtxt(SwingUtils.createAccessibleContext(JSpinner.AccessibleJSpinner.class, this, JSpinner.class), lblDescription.getAccessibleContext());
                }
                return this.ctxt;
            }
        };
        return spinner;
    }

    public static JButton createDescriptiveButton(final MultilineLabel lblDescription) {
        JButton button = new JButton(){
            private AccessibleContext ctxt;

            @Override
            public AccessibleContext getAccessibleContext() {
                if (this.ctxt == null) {
                    this.ctxt = new FormattedAccessibleCtxt(SwingUtils.createAccessibleContext(JButton.AccessibleJButton.class, this, JButton.class), lblDescription.getAccessibleContext());
                }
                return this.ctxt;
            }
        };
        return button;
    }

    public static JCheckBox createDescriptiveCheckBox(final MultilineLabel lblDescription) {
        JCheckBox checkBox = new JCheckBox(){
            private AccessibleContext ctxt;

            @Override
            public AccessibleContext getAccessibleContext() {
                if (this.ctxt == null) {
                    this.ctxt = new FormattedAccessibleCtxt(SwingUtils.createAccessibleContext(JCheckBox.AccessibleJCheckBox.class, this, JCheckBox.class), lblDescription.getAccessibleContext());
                }
                return this.ctxt;
            }
        };
        return checkBox;
    }

    public static JTextField createDescriptiveTextField(final MultilineLabel lblDescription) {
        JTextField textField = new JTextField(){
            private AccessibleContext ctxt;

            @Override
            public AccessibleContext getAccessibleContext() {
                if (this.ctxt == null) {
                    this.ctxt = new FormattedAccessibleCtxt(SwingUtils.createAccessibleContext(JTextField.AccessibleJTextField.class, this, JTextField.class), lblDescription.getAccessibleContext());
                }
                return this.ctxt;
            }
        };
        return textField;
    }

    public static JComboBox createDescriptiveComboBox(final MultilineLabel lblDescription) {
        JComboBox comboBox = new JComboBox(){
            private AccessibleContext ctxt;

            @Override
            public AccessibleContext getAccessibleContext() {
                if (this.ctxt == null) {
                    this.ctxt = new FormattedAccessibleCtxt(SwingUtils.createAccessibleContext(JComboBox.AccessibleJComboBox.class, this, JComboBox.class), lblDescription.getAccessibleContext());
                }
                return this.ctxt;
            }
        };
        return comboBox;
    }

    public static JRadioButton createDescriptiveRadioButton(final MultilineLabel lblDescription) {
        JRadioButton button = new JRadioButton(){
            private AccessibleContext ctxt;

            @Override
            public AccessibleContext getAccessibleContext() {
                if (this.ctxt == null) {
                    this.ctxt = new FormattedAccessibleCtxt(SwingUtils.createAccessibleContext(JRadioButton.AccessibleJRadioButton.class, this, JRadioButton.class), lblDescription.getAccessibleContext());
                }
                return this.ctxt;
            }
        };
        return button;
    }

    private static AccessibleContext createAccessibleContext(Class claz, Component component, Class componentClaz) {
        try {
            Constructor<?> ctor = Class.forName(claz.getName()).getDeclaredConstructor(componentClaz);
            ctor.setAccessible(true);
            return (AccessibleContext)ctor.newInstance(component);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new ApplicationException((Throwable)e, (ErrorCode)CommonErrorCode.UNABLE_TO_CREATE_COMPONENT_INSTANCE, componentClaz.getName());
        }
    }

    public static boolean containsItem(JComboBox combo, String item, boolean ignoreCase) {
        boolean contains = false;
        for (int i = 0; i < combo.getItemCount(); ++i) {
            if (ignoreCase) {
                if (!item.equalsIgnoreCase((String)combo.getItemAt(i))) continue;
                contains = true;
                continue;
            }
            if (!item.equals((String)combo.getItemAt(i))) continue;
            contains = true;
        }
        return contains;
    }

    private static class FormattedAccessibleCtxt
    extends AccessibleContext {
        private AccessibleContext originalCtxt;
        private AccessibleContext labelCtxt;

        public FormattedAccessibleCtxt(AccessibleContext ctxt, AccessibleContext descriptionComponentAccessibleContext) {
            this.originalCtxt = ctxt;
            this.labelCtxt = descriptionComponentAccessibleContext;
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return this.originalCtxt.getAccessibleRole();
        }

        @Override
        public AccessibleStateSet getAccessibleStateSet() {
            return this.originalCtxt.getAccessibleStateSet();
        }

        @Override
        public int getAccessibleIndexInParent() {
            return this.originalCtxt.getAccessibleIndexInParent();
        }

        @Override
        public int getAccessibleChildrenCount() {
            return this.originalCtxt.getAccessibleChildrenCount();
        }

        @Override
        public Accessible getAccessibleChild(int i) {
            return this.originalCtxt.getAccessibleChild(i);
        }

        @Override
        public Locale getLocale() throws IllegalComponentStateException {
            return this.originalCtxt.getLocale();
        }

        @Override
        public String getAccessibleName() {
            String description;
            StringBuffer buffer = new StringBuffer();
            String accessibleName = this.originalCtxt.getAccessibleName();
            if (accessibleName != null) {
                buffer.append(accessibleName);
            }
            if ((description = this.getAccessibleDescription()) != null) {
                buffer.append(".");
                buffer.append(" ");
                buffer.append(description);
            }
            return buffer.toString();
        }

        @Override
        public String getAccessibleDescription() {
            return this.labelCtxt != null ? this.labelCtxt.getAccessibleDescription() : this.originalCtxt.getAccessibleDescription();
        }

        @Override
        public void setAccessibleName(String s) {
            this.originalCtxt.setAccessibleName(s);
        }

        @Override
        public void setAccessibleDescription(String s) {
            this.originalCtxt.setAccessibleDescription(s);
        }

        @Override
        public Accessible getAccessibleParent() {
            return this.originalCtxt.getAccessibleParent();
        }

        @Override
        public void setAccessibleParent(Accessible a) {
            this.originalCtxt.setAccessibleParent(a);
        }

        @Override
        public void addPropertyChangeListener(PropertyChangeListener listener) {
            this.originalCtxt.addPropertyChangeListener(listener);
        }

        @Override
        public void removePropertyChangeListener(PropertyChangeListener listener) {
            this.originalCtxt.removePropertyChangeListener(listener);
        }

        @Override
        public AccessibleAction getAccessibleAction() {
            return this.originalCtxt.getAccessibleAction();
        }

        @Override
        public AccessibleComponent getAccessibleComponent() {
            return this.originalCtxt.getAccessibleComponent();
        }

        @Override
        public AccessibleSelection getAccessibleSelection() {
            return this.originalCtxt.getAccessibleSelection();
        }

        @Override
        public AccessibleText getAccessibleText() {
            return this.originalCtxt.getAccessibleText();
        }

        @Override
        public AccessibleEditableText getAccessibleEditableText() {
            return this.originalCtxt.getAccessibleEditableText();
        }

        @Override
        public AccessibleValue getAccessibleValue() {
            return this.originalCtxt.getAccessibleValue();
        }

        @Override
        public AccessibleIcon[] getAccessibleIcon() {
            return this.originalCtxt.getAccessibleIcon();
        }

        @Override
        public AccessibleRelationSet getAccessibleRelationSet() {
            return this.originalCtxt.getAccessibleRelationSet();
        }

        @Override
        public AccessibleTable getAccessibleTable() {
            return this.originalCtxt.getAccessibleTable();
        }

        @Override
        public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
            this.originalCtxt.firePropertyChange(propertyName, oldValue, newValue);
        }
    }

    static class SortableTableHeaderListener
    extends MouseAdapter {
        protected JTable table;
        SortableTableModel tableModel;

        public SortableTableHeaderListener(JTable t, SortableTableModel tableModel) {
            this.table = t;
            this.tableModel = tableModel;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            int columnModelIndex;
            JTableHeader header = (JTableHeader)e.getSource();
            TableColumnModel colModel = this.table.getColumnModel();
            int modelIndex = colModel.getColumn(columnModelIndex = colModel.getColumnIndexAtX(e.getX())).getModelIndex();
            if (modelIndex < 0) {
                return;
            }
            this.tableModel.sort(modelIndex);
            header.repaint();
        }
    }

    static class LabelHeaderRenderer
    extends JLabel
    implements TableCellRenderer {
        Icon upIcon = new UpArrowIcon();
        Icon downIcon = new DownArrowIcon();
        private TableCellRenderer oldHeaderRenderer;
        SortableTableModel tableModel;

        LabelHeaderRenderer(JTable table, SortableTableModel tableModel) {
            this.oldHeaderRenderer = table.getTableHeader().getDefaultRenderer();
            this.tableModel = tableModel;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            SortOrder order;
            Component component = this.oldHeaderRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            this.setText(value == null ? "" : value.toString());
            this.setIcon(null);
            TableColumnModel columnModel = table.getColumnModel();
            if (columnModel instanceof HidableTableColumnModel) {
                TableColumn tableColumn = ((HidableTableColumnModel)columnModel).getColumn(column, true);
                column = ((HidableTableColumnModel)columnModel).getColumnIndex(tableColumn.getIdentifier(), false);
            }
            if ((order = this.tableModel.getColumnSortOrder(column)) != SortOrder.NONE) {
                if (order == SortOrder.ASCENDING) {
                    this.setIcon(this.upIcon);
                } else {
                    this.setIcon(this.downIcon);
                }
            }
            this.setHorizontalAlignment(0);
            this.setIconTextGap(5);
            this.setHorizontalTextPosition(10);
            if (component instanceof JComponent) {
                JComponent comp = (JComponent)component;
                this.setFont(comp.getFont());
                this.setBorder(comp.getBorder());
                this.setBackground(comp.getBackground());
            }
            return this;
        }
    }

    static class CheckboxTableHeaderCellRenderer
    implements TableCellRenderer,
    MouseListener {
        private JPanel panel;
        private JCheckBox checkBox;
        private TableColumn column;
        private TableCellRenderer oldHeaderRenderer;
        private boolean updateColumn = true;

        public CheckboxTableHeaderCellRenderer(final JTable table, JCheckBox checkBox, TableColumn column) {
            this.oldHeaderRenderer = table.getTableHeader().getDefaultRenderer();
            this.column = column;
            this.checkBox = checkBox;
            this.checkBox.setBorder(BorderFactory.createEmptyBorder());
            this.panel = new JPanel();
            this.panel.setBorder(BorderFactory.createEmptyBorder());
            this.panel.setOpaque(false);
            this.panel.add(checkBox);
            AbstractAction action = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TableCellListener tcl = (TableCellListener)e.getSource();
                    int index = column.getModelIndex();
                    boolean selected = Boolean.getBoolean(tcl.getNewValue().toString());
                    if (tcl.getColumn() == index && !selected) {
                        updateColumn = false;
                        checkBox.setSelected(false);
                        JTableHeader header = table.getTableHeader();
                        if (!header.getReorderingAllowed()) {
                            header.repaint();
                        }
                    }
                }
            };
            TableCellListener tcl = new TableCellListener(table, action);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            Rectangle headerRect;
            JTableHeader header = (JTableHeader)e.getSource();
            JTable table = header.getTable();
            TableColumnModel colModel = table.getColumnModel();
            int vColIndex = colModel.getColumnIndexAtX(e.getX());
            int mColIndex = table.convertColumnIndexToModel(vColIndex);
            if (vColIndex == -1) {
                return;
            }
            TableColumn c = colModel.getColumn(vColIndex);
            if (this.column == c && (headerRect = new Rectangle(this.checkBox.getX(), this.checkBox.getY(), this.checkBox.getWidth(), this.checkBox.getHeight())).contains(e.getX(), e.getY())) {
                this.updateColumn = true;
                boolean selected = !this.checkBox.isSelected();
                this.checkBox.setSelected(selected);
                if (!header.getReorderingAllowed()) {
                    header.repaint();
                }
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        protected boolean getUpdateColumn() {
            return this.updateColumn;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component component = this.oldHeaderRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (component instanceof JComponent) {
                Border border = ((JComponent)component).getBorder();
                this.panel.setBorder(border);
            }
            this.checkBox.setFont(table.getTableHeader().getFont());
            if (value instanceof Boolean) {
                this.checkBox.setSelected((Boolean)value);
            }
            return this.panel;
        }
    }

    private static class GenericTabAction
    extends AbstractAction {
        private Component component;
        private boolean focusForward;

        public GenericTabAction(Component component, boolean focusForward) {
            this.component = component;
            this.focusForward = focusForward;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (this.focusForward) {
                this.component.transferFocus();
            } else {
                this.component.transferFocusBackward();
            }
        }
    }

    private static class TableTabAction
    extends AbstractAction {
        private JTable table;
        private boolean focusForward;

        public TableTabAction(JTable table, boolean focusForward) {
            this.table = table;
            this.focusForward = focusForward;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            int row = this.table.getSelectedRow();
            if (this.focusForward) {
                if (row == -1) {
                    if (this.table.getRowCount() > 0) {
                        this.table.setRowSelectionInterval(0, 0);
                    } else {
                        this.table.transferFocus();
                    }
                } else {
                    int nextRow = row + 1;
                    if (nextRow < this.table.getRowCount()) {
                        this.table.setRowSelectionInterval(nextRow, nextRow);
                    } else {
                        this.table.transferFocus();
                    }
                }
            } else if (row == -1) {
                if (this.table.getRowCount() > 0) {
                    this.table.setRowSelectionInterval(0, 0);
                } else {
                    this.table.transferFocusBackward();
                }
            } else {
                int prevRow = row - 1;
                if (prevRow >= 0) {
                    this.table.setRowSelectionInterval(prevRow, prevRow);
                } else {
                    this.table.transferFocusBackward();
                }
            }
        }
    }
}

