/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.swing;

import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import oracle.install.commons.bean.xml.XmlBeanStoreFormat;
import oracle.install.commons.bean.xml.XmlBeanStoreFormatRegistry;

public class XmlBeanStoreFileChooser
extends JFileChooser {
    private XmlBeanStoreFormatRegistry registry;
    private String[] supportedFileExts;

    public XmlBeanStoreFileChooser() {
        this.init();
    }

    public XmlBeanStoreFileChooser(File currentDirectory) {
        super(currentDirectory);
        this.init();
    }

    public XmlBeanStoreFileChooser(String currentDirectoryPath) {
        super(currentDirectoryPath);
        this.init();
    }

    protected void init() {
        this.setFileSelectionMode(0);
        this.registry = XmlBeanStoreFormatRegistry.getInstance();
        this.supportedFileExts = this.registry.getSupportFileExtensions();
        if (this.supportedFileExts != null && this.supportedFileExts.length > 0) {
            this.setAcceptAllFileFilterUsed(false);
            this.setFileFilter(new XmlBeanStoreFileFilter(this.supportedFileExts));
        }
    }

    @Override
    public File getSelectedFile() {
        File selectedFile = super.getSelectedFile();
        if (selectedFile != null && this.supportedFileExts != null && this.supportedFileExts.length > 0 && !this.registry.isBeanStoreFileSupported(selectedFile)) {
            XmlBeanStoreFormat defaultFormat = this.registry.getDefaultFormat();
            String defaultFileExt = this.registry.getDefaultFileExtn();
            if (defaultFileExt == null || defaultFileExt.isEmpty() || this.registry.getFileFormat(defaultFileExt) != defaultFormat) {
                defaultFileExt = this.supportedFileExts[0];
                if (this.supportedFileExts.length > 1) {
                    for (String fileExt : this.supportedFileExts) {
                        if (this.registry.getFileFormat(fileExt) != defaultFormat) continue;
                        defaultFileExt = fileExt;
                        break;
                    }
                }
            }
            String path = selectedFile.getPath();
            path = path + "." + defaultFileExt;
            selectedFile = new File(path);
        }
        return selectedFile;
    }

    class XmlBeanStoreFileFilter
    extends FileFilter {
        private String description;

        public XmlBeanStoreFileFilter(String[] fileExts) {
            StringBuffer buffer = new StringBuffer();
            for (String fileExt : fileExts) {
                buffer.append(" *.");
                buffer.append(fileExt);
                buffer.append(",");
            }
            buffer.deleteCharAt(buffer.length() - 1);
            this.description = buffer.toString();
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        @Override
        public boolean accept(File pathname) {
            boolean accept = false;
            accept = pathname.isFile() ? XmlBeanStoreFileChooser.this.registry.isBeanStoreFileSupported(pathname) : true;
            return accept;
        }
    }
}

