/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.system.filemgmt;

import java.io.File;
import java.io.FileFilter;
import java.util.Arrays;
import java.util.List;

public class PatternFilter
implements FileFilter {
    private List<String> patterns;
    private Type type;

    public PatternFilter(Type type, String ... patterns) {
        this.type = type == null ? Type.INCLUDE : type;
        this.patterns = Arrays.asList(patterns);
    }

    public Type getType() {
        return this.type;
    }

    public List<String> getPatterns() {
        return this.patterns;
    }

    @Override
    public boolean accept(File pathname) {
        boolean match = false;
        String path = pathname.getPath();
        for (String pattern : this.patterns) {
            if (!path.contains(pattern)) continue;
            match = true;
            break;
        }
        return this.type == Type.INCLUDE ? match : !match;
    }

    public static enum Type {
        EXCLUDE,
        INCLUDE;

    }
}

