/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import oracle.sysman.oii.oiix.OiixFunctionOps;

public class StringUtils {
    public static boolean isEmpty(String string) {
        return string == null || string.trim().length() == 0;
    }

    public static boolean areEqual(String string1, String string2) {
        return string1 != null && string2 != null && string1.equals(string2);
    }

    public static String sanitizeString(String str) {
        if (str.matches("^\\{.*\\}$")) {
            String temp = str.substring(1, str.length() - 1);
            if (temp != null && temp.length() > 0) {
                String[] temparr = OiixFunctionOps.explodeString((String)temp.toString(), (String)",");
                StringBuffer s = new StringBuffer();
                for (int i = 0; i < temparr.length; ++i) {
                    s.append(StringUtils.sanitizeString(temparr[i]));
                    s.append(",");
                }
                s.deleteCharAt(s.length() - 1);
                return s.toString();
            }
            return temp;
        }
        if (str.matches("^\".*\"$")) {
            return str.substring(1, str.length() - 1);
        }
        return str;
    }

    public static boolean containsIgnoreCase(List<String> strList, String str) {
        if (strList != null && strList.size() > 0 && str != null) {
            for (String strName : strList) {
                if (strName == null || !strName.equalsIgnoreCase(str)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean containsIgnoreCase(Collection<String> strList, String str) {
        if (strList != null && strList.size() > 0 && str != null) {
            for (String strName : strList) {
                if (strName == null || !strName.equalsIgnoreCase(str)) continue;
                return true;
            }
        }
        return false;
    }

    public static String textToHtml(String plainText) {
        return plainText.replaceAll("<", "&lt;");
    }

    public static int indexOfIgnoreCase(List<String> strList, String str) {
        if (strList != null && strList.size() > 0 && str != null) {
            int index = 0;
            for (String strName : strList) {
                if (strName != null && strName.equalsIgnoreCase(str)) {
                    return index;
                }
                ++index;
            }
        }
        return -1;
    }

    public static String getCommaSeparatedString(Object[] filePaths) {
        String commaSeparatedString = "";
        if (filePaths != null && filePaths.length != 0) {
            String filePathString = Arrays.toString(filePaths);
            if (filePathString.startsWith("[")) {
                filePathString = filePathString.substring(1, filePathString.length());
            }
            if (filePathString.endsWith("]")) {
                filePathString = filePathString.substring(0, filePathString.length() - 1);
            }
            commaSeparatedString = filePathString;
        }
        return commaSeparatedString;
    }
}

