/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.util.exception;

import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.install.commons.swing.StandardDialog;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.StatusMessages;
import oracle.install.commons.util.UIType;
import oracle.install.commons.util.exception.AbstractErrorAdvisor;
import oracle.install.commons.util.exception.Advice;
import oracle.install.commons.util.exception.ErrorAdvisor;
import oracle.install.commons.util.exception.ErrorMessage;
import oracle.install.commons.util.exception.ExceptionManager;
import oracle.install.commons.util.exception.Severity;

public class DefaultErrorAdvisor
implements ErrorAdvisor {
    private static final Logger logger = Logger.getLogger(DefaultErrorAdvisor.class.getName());
    private Map<UIType, ErrorAdvisor> errorAdvisorMap = new HashMap<UIType, ErrorAdvisor>();

    public DefaultErrorAdvisor() {
        this.errorAdvisorMap.put(UIType.GRAPHICAL, new GraphicalErrorAdvisor());
        this.errorAdvisorMap.put(UIType.TEXTUAL, new TextualErrorAdvisor());
        this.errorAdvisorMap.put(UIType.NONE, new SilentErrorAdvisor());
    }

    public Map<UIType, ErrorAdvisor> getErrorAdvisorMap() {
        return this.errorAdvisorMap;
    }

    public void setErrorAdvisorMap(Map<UIType, ErrorAdvisor> errorAdvisorMap) {
        this.errorAdvisorMap = errorAdvisorMap;
    }

    @Override
    public Advice advise(Object observer, StatusMessages<? extends ErrorMessage> errorMessages) {
        Application application = Application.getInstance();
        UIType uiType = application.getUIType();
        ErrorAdvisor delegate = this.errorAdvisorMap.get((Object)uiType);
        return delegate.advise(observer, errorMessages);
    }

    class TextualErrorAdvisor
    extends AbstractErrorAdvisor {
        TextualErrorAdvisor() {
        }

        @Override
        public Advice advise(Object observer, StatusMessages<? extends ErrorMessage> errorMessages, String detailedMessage) {
            Advice advice = Advice.CONTINUE;
            return advice;
        }
    }

    class SilentErrorAdvisor
    extends AbstractErrorAdvisor {
        SilentErrorAdvisor() {
        }

        @Override
        public Advice advise(Object observer, StatusMessages<? extends ErrorMessage> errorMessages, String detailedMessage) {
            Advice advice = Advice.CONTINUE;
            System.out.print(detailedMessage);
            Level aggregateLevel = errorMessages.getAggregateLevel();
            if (ExceptionManager.getSeverity(aggregateLevel) == Severity.FATAL) {
                advice = Advice.ABORT;
            }
            return advice;
        }
    }

    class GraphicalErrorAdvisor
    extends AbstractErrorAdvisor {
        GraphicalErrorAdvisor() {
        }

        @Override
        public Advice advise(Object observer, StatusMessages<? extends ErrorMessage> errorMessages, String detailedMessage) {
            Component owner = observer instanceof Component ? (Component)observer : null;
            return StandardDialog.showErrors(owner, errorMessages);
        }
    }
}

