/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.util.exception;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.DefaultStatusMessage;
import oracle.install.commons.util.Option;
import oracle.install.commons.util.Resource;
import oracle.install.commons.util.StatusMessages;
import oracle.install.commons.util.UIType;
import oracle.install.commons.util.exception.AbstractErrorAdvisor;
import oracle.install.commons.util.exception.Advice;
import oracle.install.commons.util.exception.DefaultErrorMessage;
import oracle.install.commons.util.exception.ErrMsgAdvisor;
import oracle.install.commons.util.exception.ErrMsgAnalyzer;
import oracle.install.commons.util.exception.ErrMsgHandler;
import oracle.install.commons.util.exception.ErrorAdvisor;
import oracle.install.commons.util.exception.ErrorMessage;
import oracle.install.commons.util.exception.ExceptionManager;
import oracle.install.commons.util.exception.GraphicalErrMsgAdvisor;
import oracle.install.commons.util.exception.Severity;
import oracle.install.commons.util.exception.SilentErrMsgAdvisor;
import oracle.install.commons.util.exception.TextualErrMsgAdvisor;

public class SynchronizedErrMsgHandler
extends AbstractErrorAdvisor
implements ErrMsgHandler {
    public static final String GENERIC_TASK_ID = "Generic";
    protected static final Resource resource = Application.getInstance().getResource("oracle.install.commons.util.resource.StringResourceBundle");
    private static final Logger logger = Logger.getLogger(SynchronizedErrMsgHandler.class.getName());
    private Map<String, ErrMsgAnalyzer> errorAnalyzerMap = new HashMap<String, ErrMsgAnalyzer>();
    private ErrMsgAdvisor customErrMsgAdvisor;
    private ErrorAdvisor errorAdvisor;
    private Map<UIType, ErrMsgAdvisor> errMsgAdvisorMap;

    protected SynchronizedErrMsgHandler() {
        this.errorAnalyzerMap.put(GENERIC_TASK_ID, new ErrMsgAnalyzer());
        this.errMsgAdvisorMap = new HashMap<UIType, ErrMsgAdvisor>();
        this.errMsgAdvisorMap.put(UIType.GRAPHICAL, new GraphicalErrMsgAdvisor());
        this.errMsgAdvisorMap.put(UIType.TEXTUAL, new TextualErrMsgAdvisor());
        this.errMsgAdvisorMap.put(UIType.NONE, new SilentErrMsgAdvisor());
    }

    @Override
    public synchronized Advice adviceMessage(String taskId, Severity severity, String message) {
        DefaultStatusMessage statusMessage = new DefaultStatusMessage(ExceptionManager.getLevel(severity), message);
        return this.adviceMessage(taskId, statusMessage);
    }

    @Override
    public synchronized Advice adviceMessage(String taskId, DefaultStatusMessage message) {
        if (message != null) {
            StatusMessages<DefaultStatusMessage> messages = new StatusMessages<DefaultStatusMessage>();
            messages.add(message);
            return this.adviceMessages(taskId, messages);
        }
        return Advice.NONE;
    }

    @Override
    public synchronized Advice adviceMessages(String taskId, StatusMessages<? extends DefaultStatusMessage> messages) {
        if (messages != null && !messages.isEmpty()) {
            Level level = messages.getAggregateLevel();
            ErrMsgAnalyzer errMsgAnalyzer = this.getErrMsgAnalyzer(this.getTaskId(taskId));
            if (errMsgAnalyzer != null) {
                Option option = this.adviceMessages(null, null, messages, errMsgAnalyzer.getDefaultOption(level), errMsgAnalyzer.getMessageOptions(level));
                return errMsgAnalyzer.getAdvice(level, option);
            }
        }
        return Advice.NONE;
    }

    @Override
    public synchronized Option adviceMessage(DefaultStatusMessage message, Option defaultOption, Option ... options) {
        return this.adviceMessage(null, null, message, defaultOption, options);
    }

    @Override
    public synchronized Option adviceMessage(Component owner, String title, DefaultStatusMessage message, Option defaultOption, Option ... options) {
        if (message != null) {
            StatusMessages<DefaultStatusMessage> messages = new StatusMessages<DefaultStatusMessage>();
            messages.add(message);
            return this.adviceMessages(owner, title, messages, defaultOption, options);
        }
        return defaultOption;
    }

    @Override
    public synchronized Option adviceMessages(Component owner, String title, StatusMessages<? extends DefaultStatusMessage> messages, Option defaultOption, Option ... options) {
        if (messages != null && !messages.isEmpty() && options != null) {
            logger.log(Level.INFO, "Following messages are begin reported:");
            for (DefaultStatusMessage defaultStatusMessage : messages) {
                logger.log(defaultStatusMessage.getLevel(), defaultStatusMessage.getMessage());
            }
            logger.log(messages.getAggregateLevel(), "Options specified:" + options + " Default option:" + defaultOption);
            Option selectedOption = null;
            selectedOption = this.errorAdvisor != null && this.errorAdvisor instanceof ErrMsgAdvisor ? ((ErrMsgAdvisor)this.errorAdvisor).adviceMessages(owner, title, messages, defaultOption, options) : this.getErrMsgAdvisor().adviceMessages(owner, title, messages, defaultOption, options);
            logger.log(messages.getAggregateLevel(), "Option selected is:" + selectedOption);
            return selectedOption;
        }
        return defaultOption;
    }

    @Override
    public synchronized Advice adviseError(String taskId, String errorStr) {
        if (errorStr != null && !errorStr.isEmpty()) {
            ArrayList<String> errors = new ArrayList<String>();
            errors.add(errorStr);
            return this.adviseErrors(taskId, errors);
        }
        return Advice.NONE;
    }

    @Override
    public synchronized Advice adviseErrors(String taskId, List<String> errors) {
        if (errors != null && !errors.isEmpty()) {
            ErrMsgAnalyzer errorAnalyzer = this.getErrMsgAnalyzer(this.getTaskId(taskId));
            StatusMessages<DefaultErrorMessage> errorMessages = new StatusMessages<DefaultErrorMessage>();
            if (errorAnalyzer != null) {
                for (String error : errors) {
                    ErrMsgAnalyzer.ErrorIdType errorId = errorAnalyzer.getErrorId(error);
                    DefaultErrorMessage message = new DefaultErrorMessage(error, errorAnalyzer.getErrMessageSeverity(errorId));
                    errorMessages.add(message);
                }
                return this.advise(taskId, errorMessages);
            }
        }
        return Advice.NONE;
    }

    @Override
    public final synchronized Advice advise(Object observer, StatusMessages<? extends ErrorMessage> errorMessages, String detailedMessage) {
        if (errorMessages != null && !errorMessages.isEmpty()) {
            if (this.errorAdvisor != null) {
                return this.errorAdvisor.advise(observer, errorMessages);
            }
            return this.getErrMsgAdvisor().advise(observer, errorMessages, detailedMessage);
        }
        return Advice.NONE;
    }

    @Override
    public synchronized Advice advise(String taskId, ErrorMessage errorMessage) {
        if (errorMessage != null) {
            StatusMessages<ErrorMessage> errorMessages = new StatusMessages<ErrorMessage>();
            errorMessages.add(errorMessage);
            return this.advise(taskId, errorMessages);
        }
        return Advice.NONE;
    }

    @Override
    public synchronized Advice advise(String taskId, StatusMessages<? extends ErrorMessage> errorMessages) {
        if (errorMessages != null && !errorMessages.isEmpty()) {
            StatusMessages<? extends ErrorMessage> reportableErrors = this.prepareForAdvice(taskId, errorMessages);
            String detailedMessage = this.getDetailedMessage(reportableErrors);
            return this.advise(null, reportableErrors, detailedMessage);
        }
        return null;
    }

    @Override
    protected StatusMessages<? extends ErrorMessage> prepareForAdvice(StatusMessages<? extends ErrorMessage> errorMessages) {
        return this.prepareForAdvice(GENERIC_TASK_ID, errorMessages);
    }

    protected StatusMessages<? extends ErrorMessage> prepareForAdvice(String taskId, StatusMessages<? extends ErrorMessage> errorMessages) {
        if (errorMessages != null && !errorMessages.isEmpty()) {
            ErrMsgAnalyzer errorAnalyzer = this.getErrMsgAnalyzer(this.getTaskId(taskId));
            StatusMessages<Object> reportableErrors = new StatusMessages<ErrorMessage>();
            if (errorAnalyzer != null) {
                for (ErrorMessage errorMessage : errorMessages) {
                    ErrMsgAnalyzer.ErrorIdType errorId = errorAnalyzer.getErrorId(errorMessage);
                    if (errorAnalyzer.needReporting(errorId)) {
                        reportableErrors.add((Object)errorMessage);
                        continue;
                    }
                    logger.log(Level.INFO, "Error message is not marked for reporting:" + errorMessage.getMessage());
                }
            } else {
                reportableErrors.addAll((Collection<Object>)errorMessages);
            }
            reportableErrors = super.prepareForAdvice(reportableErrors);
            return reportableErrors;
        }
        return errorMessages;
    }

    protected synchronized ErrMsgAnalyzer getErrMsgAnalyzer(String taskId) {
        ErrMsgAnalyzer analyzer = this.errorAnalyzerMap.get(taskId = this.getTaskId(taskId));
        if (analyzer == null) {
            analyzer = this.errorAnalyzerMap.get(GENERIC_TASK_ID);
        }
        return analyzer;
    }

    protected synchronized void setErrorAnalyzer(String taskId, ErrMsgAnalyzer analyzer) {
        if (analyzer != null && taskId != null && !taskId.isEmpty()) {
            this.errorAnalyzerMap.put(taskId, analyzer);
        }
    }

    protected synchronized void removeErrorAnalyzer(String taskId) {
        if (taskId != null && !taskId.isEmpty() && !taskId.equalsIgnoreCase(GENERIC_TASK_ID)) {
            this.errorAnalyzerMap.remove(taskId);
        }
    }

    protected synchronized void setCustomErrMessageAdvisor(ErrMsgAdvisor errMsgAdvisor) {
        this.customErrMsgAdvisor = errMsgAdvisor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setErrorAdvisor(ErrorAdvisor errAdvisor) {
        if (errAdvisor != null) {
            SynchronizedErrMsgHandler synchronizedErrMsgHandler = this;
            synchronized (synchronizedErrMsgHandler) {
                this.errorAdvisor = errAdvisor;
            }
        }
    }

    protected synchronized ErrorAdvisor getErrorAdvisor() {
        return this.errorAdvisor;
    }

    protected synchronized ErrMsgAdvisor getErrMsgAdvisor() {
        if (this.customErrMsgAdvisor != null) {
            return this.customErrMsgAdvisor;
        }
        UIType uiType = Application.getInstance().getUIType();
        return this.errMsgAdvisorMap.get((Object)uiType);
    }

    private String getTaskId(String taskId) {
        if (taskId == null || taskId.isEmpty()) {
            return GENERIC_TASK_ID;
        }
        return taskId;
    }
}

