/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.driver.oui;

import java.util.List;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.install.commons.base.driver.common.SetupDriver;
import oracle.install.commons.base.util.PlatformInfo;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.ApplicationHelper;
import oracle.install.commons.util.Resource;
import oracle.install.commons.util.progress.CompositeJob;
import oracle.install.commons.util.progress.Job;
import oracle.install.commons.util.progress.Pausable;
import oracle.install.commons.util.progress.Status;
import oracle.install.driver.oui.DriverConstants;
import oracle.install.driver.oui.InstallProgressMonitor;
import oracle.install.driver.oui.OUISetupDriver;
import oracle.install.driver.oui.RemoteCopyJob;
import oracle.install.driver.oui.SessionDetails;
import oracle.install.driver.oui.SessionInitProgressMonitor;
import oracle.sysman.oii.oiif.oiifm.OiifmIRootShInfo;
import oracle.sysman.oii.oiif.oiifr.OiifrProgressPhases;

public class SetupJob
extends CompositeJob
implements Callable<Void> {
    private boolean multinodeSetup;
    private boolean sharedHome;
    private SessionDetails sessionDetails;
    private SessionInitProgressMonitor sessionInitMonitor;
    private InstallProgressMonitor installProgressMonitor;
    private OiifmIRootShInfo[] rootScripts;
    private boolean configurationRequired;
    private OUISetupMode ouiSetupMode = OUISetupMode.INSTALL;
    private String oracleHome;
    private String oracleBase;
    private String[] remoteNodes;
    private List<String> successfulRemoteNodes;
    private String excludeFilePath;
    private static Logger logger = Logger.getLogger(SetupJob.class.getName());
    private boolean tolerantMode;
    private static final Pausable PAUSABLE = new Pausable(){

        @Override
        public void pause() throws Exception {
            Object driver = SetupDriver.getInstance();
            ((SetupDriver)driver).pause();
        }

        @Override
        public void resume() throws Exception {
            Object driver = SetupDriver.getInstance();
            ((SetupDriver)driver).resume();
        }
    };

    public SetupJob(Object id, String description, float weightage, SessionDetails sessionDetails) {
        this(id, description, weightage, sessionDetails, false, false);
    }

    public SetupJob(Object id, String description, float weightage, SessionDetails sessionDetails, boolean multinodeSetup) {
        this(id, description, weightage, sessionDetails, multinodeSetup, false);
    }

    public SetupJob(Object id, String description, float weightage, SessionDetails sessionDetails, boolean multinodeSetup, boolean sharedHome) {
        super(id, description, weightage);
        this.sessionDetails = sessionDetails;
        Application application = Application.getInstance();
        Resource resource = application.getResource(DriverConstants.STRING_RESOURCE_BUNDLE_NAME);
        this.multinodeSetup = multinodeSetup;
        this.sharedHome = sharedHome;
        this.populateJobs(OUISetupMode.INSTALL);
        this.setPausable(PAUSABLE);
    }

    public SetupJob(Object id, String description, float weightage, SessionDetails sessionDetails, OUISetupMode mode) {
        this(id, description, weightage, sessionDetails, mode, false, false);
    }

    public SetupJob(Object id, String description, float weightage, SessionDetails sessionDetails, OUISetupMode mode, boolean multinodeSetup, boolean isShared) {
        super(id, description, weightage);
        this.multinodeSetup = multinodeSetup;
        this.sharedHome = isShared;
        this.sessionDetails = sessionDetails;
        this.ouiSetupMode = mode;
        this.populateJobs(mode);
        this.setPausable(PAUSABLE);
    }

    public SetupJob(Object id, String description, float weightage, SessionDetails sessionDetails, boolean multinodeSetup, boolean sharedHome, String oracleHome, String oracleBase, String[] remoteNodes, String excludeFilePath, boolean tolerantMode) {
        super(id, description, weightage);
        this.sessionDetails = sessionDetails;
        Application application = Application.getInstance();
        Resource resource = application.getResource(DriverConstants.STRING_RESOURCE_BUNDLE_NAME);
        this.multinodeSetup = multinodeSetup;
        this.sharedHome = sharedHome;
        this.oracleHome = oracleHome;
        this.oracleBase = oracleBase;
        this.remoteNodes = remoteNodes;
        this.excludeFilePath = excludeFilePath;
        this.tolerantMode = tolerantMode;
        this.populateJobs(OUISetupMode.INSTALL);
        this.setPausable(PAUSABLE);
    }

    public SetupJob(Object id, String description, float weightage, SessionDetails sessionDetails, OUISetupMode mode, boolean multinodeSetup, boolean isShared, String oracleHome, String oracleBase, String[] remoteNodes, String excludeFilePath, boolean tolerantMode) {
        super(id, description, weightage);
        this.multinodeSetup = multinodeSetup;
        this.sharedHome = isShared;
        this.sessionDetails = sessionDetails;
        this.ouiSetupMode = mode;
        this.oracleHome = oracleHome;
        this.oracleBase = oracleBase;
        this.remoteNodes = remoteNodes;
        this.excludeFilePath = excludeFilePath;
        this.tolerantMode = tolerantMode;
        this.populateJobs(mode);
        this.setPausable(PAUSABLE);
    }

    private void populateJobs(OUISetupMode setupMode) {
        Application application = Application.getInstance();
        Resource resource = application.getResource(DriverConstants.STRING_RESOURCE_BUNDLE_NAME);
        switch (setupMode) {
            case INSTALL: {
                CompositeJob initPhase = new CompositeJob((Object)"init", 0.1f);
                initPhase.setHidden(true);
                Job job = new Job((Object)"prepare", resource.getString("setupJob.init.prepare.text", "Prepare", new Object[0]));
                initPhase.add(job);
                this.add(initPhase);
                CompositeJob installPhase = new CompositeJob((Object)"install", 0.9f);
                installPhase.setHidden(true);
                job = new Job(OiifrProgressPhases.INSTALL_PHASE, resource.getString("setupJob.install.copy.text", "Copy files", new Object[0]), 0.6f);
                installPhase.add(job);
                if (!PlatformInfo.getInstance().isWindows()) {
                    job = new Job(OiifrProgressPhases.LINK_PHASE, resource.getString("setupJob.install.link.text", "Link binaries", new Object[0]), 0.2f);
                    installPhase.add(job);
                }
                CompositeJob setup = new CompositeJob("setup", resource.getString("setupJob.install.compositeSetup.text", "Setup", new Object[0]), 0.2f);
                job = new Job(OiifrProgressPhases.INSTALL_PHASE2, resource.getString("setupJob.install.setup.text", "Setup files", new Object[0]), 0.5f);
                job.setHidden(true);
                setup.add(job);
                job = new Job(OiifrProgressPhases.SAVE_INVENTORY_PHASE, resource.getString("setupJob.install.saveinventory.text", "Setup inventory", new Object[0]), 0.2f);
                job.setHidden(true);
                setup.add(job);
                job = new Job(OiifrProgressPhases.POSTINSTALL_PHASE, resource.getString("setupJob.install.finishsetup.text", "Finish Setup", new Object[0]), 0.3f);
                job.setHidden(true);
                setup.add(job);
                installPhase.add(setup);
                String useSeparateRemoteNodeOps = ApplicationHelper.getProperty("oracle.installer.remotecopy.standalone");
                boolean separateRemoteJobOp = false;
                if (useSeparateRemoteNodeOps != null && useSeparateRemoteNodeOps.length() > 0) {
                    separateRemoteJobOp = Boolean.valueOf(useSeparateRemoteNodeOps);
                }
                logger.log(Level.FINEST, "Install setup separation property: " + separateRemoteJobOp);
                if (!separateRemoteJobOp && this.multinodeSetup) {
                    CompositeJob remoteSetup = new CompositeJob("remoteSetup", resource.getString("setupJob.install.remotesetup.text", "Perform remote operations", new Object[0]), 0.2f);
                    if (!this.sharedHome) {
                        boolean useOUIRemoteCopy = Boolean.getBoolean("oracle.installer.performRemoteCopyInAPIMode");
                        job = !useOUIRemoteCopy ? new RemoteCopyJob(OiifrProgressPhases.CLUSTER_PHASE, resource.getString("setupJob.install.remotesetup.text", "Setup remote nodes", new Object[0]), 0.9f, this.multinodeSetup, this.sharedHome, this.oracleHome, this.oracleBase, this.remoteNodes, this.excludeFilePath, this, this.tolerantMode) : new Job(OiifrProgressPhases.CLUSTER_PHASE, resource.getString("setupJob.install.remotesetup.text", "Setup remote nodes", new Object[0]), 0.6f);
                        job.setHidden(true);
                        remoteSetup.add(job);
                    }
                    job = new Job(OiifrProgressPhases.ADD_NODE_SAVE_INV_PHASE, resource.getString("setupJob.install.remoteinventorycopy.text", "Setup cluster inventory", new Object[0]), 0.4f);
                    job.setHidden(true);
                    remoteSetup.add(job);
                    installPhase.add(remoteSetup);
                }
                this.add(installPhase);
                this.sessionInitMonitor = new SessionInitProgressMonitor(initPhase, null);
                this.installProgressMonitor = new InstallProgressMonitor(installPhase, null, this.ouiSetupMode);
                break;
            }
            case CLONE: {
                CompositeJob clonePhase = new CompositeJob((Object)"clone", 0.9f);
                clonePhase.setHidden(true);
                Job job = new Job(OiifrProgressPhases.INSTALL_PHASE, resource.getString("setupJob.install.copy.text", "Copy files", new Object[0]), 0.6f);
                clonePhase.add(job);
                if (!PlatformInfo.getInstance().isWindows() && !Application.isCommandLineSwitchEnabled("-nolink")) {
                    job = new Job(OiifrProgressPhases.LINK_PHASE, resource.getString("setupJob.install.link.text", "Link binaries", new Object[0]), 0.2f);
                    this.installProgressMonitor = new InstallProgressMonitor(clonePhase, null);
                    clonePhase.add(job);
                }
                CompositeJob setup = new CompositeJob("setup", resource.getString("setupJob.install.compositeSetup.text", "Setup", new Object[0]), 0.2f);
                job = new Job(OiifrProgressPhases.INSTALL_PHASE2, resource.getString("setupJob.install.setup.text", "Setup files", new Object[0]), 0.5f);
                job.setHidden(true);
                setup.add(job);
                job = new Job(OiifrProgressPhases.SAVE_INVENTORY_PHASE, resource.getString("setupJob.install.saveinventory.text", "Setup inventory", new Object[0]), 0.2f);
                job.setHidden(true);
                setup.add(job);
                job = new Job(OiifrProgressPhases.POSTINSTALL_PHASE, resource.getString("setupJob.install.finishsetup.text", "Finish Setup", new Object[0]), 0.3f);
                job.setHidden(true);
                setup.add(job);
                clonePhase.add(setup);
                this.add(clonePhase);
                this.installProgressMonitor = new InstallProgressMonitor(clonePhase, null);
                break;
            }
            case ADDNODE: {
                CompositeJob initPhase = new CompositeJob((Object)"init", 0.1f);
                initPhase.setHidden(true);
                CompositeJob addnodePhase = new CompositeJob((Object)"Add node", 0.9f);
                addnodePhase.setHidden(true);
                Job job = new Job(OiifrProgressPhases.ADD_NODE_INSTANTIATE_PHASE, resource.getString("ADDNODE_INSTANTIATE_FILES_DESC", "Instantiate files", new Object[0]), 0.09f);
                addnodePhase.add(job);
                if (!Boolean.getBoolean("oracle.installer.remotecopy.standalone") && !this.isSharedHome()) {
                    boolean useOUIRemoteCopy = Boolean.getBoolean("oracle.installer.performRemoteCopyInAPIMode");
                    job = !useOUIRemoteCopy ? new RemoteCopyJob(OiifrProgressPhases.ADD_NODE_COPY_PHASE, resource.getString("ADDNODE_COPY_FILES_DESC", "Copying files to node", new Object[0]), 0.9f, this.multinodeSetup, this.sharedHome, this.oracleHome, this.oracleBase, this.remoteNodes, this.excludeFilePath, this, this.tolerantMode) : new Job(OiifrProgressPhases.ADD_NODE_COPY_PHASE, resource.getString("ADDNODE_COPY_FILES_DESC", "Copying files to node", new Object[0]), 0.9f);
                    addnodePhase.add(job);
                }
                job = new Job(OiifrProgressPhases.ADD_NODE_SAVE_INV_PHASE, resource.getString("ADDNODE_SAVE_CLUSTER_INVENTORY_DESC", "Saving cluster inventory", new Object[0]), 0.11f);
                addnodePhase.add(job);
                this.add(addnodePhase);
                this.sessionInitMonitor = new SessionInitProgressMonitor(initPhase, null);
                this.installProgressMonitor = new InstallProgressMonitor(addnodePhase, null, this.ouiSetupMode);
            }
        }
    }

    public boolean isMultinodeSetup() {
        return this.multinodeSetup;
    }

    public boolean isSharedHome() {
        return this.sharedHome;
    }

    public OiifmIRootShInfo[] getRootScripts() {
        return this.rootScripts;
    }

    public void setRootScripts(OiifmIRootShInfo[] rootScripts) {
        this.rootScripts = rootScripts;
    }

    public OUISetupMode getOUISetupMode() {
        return this.ouiSetupMode;
    }

    public Callable<Void> getWork() {
        return this;
    }

    @Override
    public Void call() throws Exception {
        Object driver = SetupDriver.getInstance();
        if (this.ouiSetupMode != null && this.ouiSetupMode == OUISetupMode.ADDNODE) {
            List<String> nodeList = ((SetupDriver)driver).getNodeList();
            boolean multiNodeSetup = false;
            boolean gridSetupWizard = Boolean.getBoolean("oracle.installer.setupWizard");
            if (gridSetupWizard) {
                multiNodeSetup = nodeList != null && nodeList.size() > 1;
            } else {
                boolean bl = multiNodeSetup = nodeList != null && nodeList.size() > 0;
            }
            if (!multiNodeSetup) {
                this.setRequired(false);
                this.setStatus(Status.IGNORED);
                Job addNodePhaseJob = this.findJob(this.getJobs(), "Add node");
                if (addNodePhaseJob != null) {
                    this.setStatusRecursively(addNodePhaseJob, Status.IGNORED);
                }
                return null;
            }
        }
        if (driver instanceof OUISetupDriver) {
            OUISetupDriver ouiSetupDriver = (OUISetupDriver)driver;
            ouiSetupDriver.setup(this);
        }
        return null;
    }

    public InstallProgressMonitor getInstallProgressMonitor() {
        return this.installProgressMonitor;
    }

    public SessionInitProgressMonitor getSessionInitMonitor() {
        return this.sessionInitMonitor;
    }

    public SessionDetails getSessionDetails() {
        return this.sessionDetails;
    }

    public void setSessionDetails(SessionDetails sessionInfo) {
        this.sessionDetails = sessionInfo;
    }

    public boolean isConfigurationRequired() {
        return this.configurationRequired;
    }

    public void setConfigurationRequired(boolean configurationRequired) {
        this.configurationRequired = configurationRequired;
    }

    public void setSuccessfulRemoteNodes(List<String> remoteNodeList) {
        this.successfulRemoteNodes = remoteNodeList;
    }

    public void setExcludeFilePath(String excludeFilePath) {
        this.excludeFilePath = excludeFilePath;
    }

    public String getExcludeFilePath() {
        return this.excludeFilePath;
    }

    private Job findJob(List<Job> joblist, Object jobId) {
        if (joblist != null) {
            for (Job job : joblist) {
                Job expectedJob;
                Object id = job.getId();
                if (id != null && jobId.equals(id)) {
                    return job;
                }
                if (!(job instanceof CompositeJob) || (expectedJob = this.findJob(((CompositeJob)job).getJobs(), jobId)) == null) continue;
                return expectedJob;
            }
        }
        return null;
    }

    private void setStatusRecursively(Job job, Status status) {
        if (job instanceof CompositeJob) {
            for (Job j : ((CompositeJob)job).getJobs()) {
                this.setStatusRecursively(j, status);
            }
        } else {
            job.setStatus(status);
        }
    }

    public static enum OUISetupMode {
        INSTALL,
        CLONE,
        ADDNODE;

    }
}

