/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oip.oipc.oipcc;

import java.io.File;
import java.io.IOException;
import java.util.Properties;
import oracle.sysman.oii.oiic.OiicBaseApp;
import oracle.sysman.oii.oiic.OiicISession;
import oracle.sysman.oii.oiic.OiicISessionProxy;
import oracle.sysman.oii.oiic.OiicInstVersion;
import oracle.sysman.oii.oiic.OiicInvalidCmdLineException;
import oracle.sysman.oii.oiic.OiicSessionProvider;
import oracle.sysman.oii.oiil.OiilNativeException;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiip.oiipg.OiipgSRVMTracing;
import oracle.sysman.oii.oiip.osd.unix.OiipuUnixOps;
import oracle.sysman.oii.oiix.OiixJarClassLoader;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oii.oiix.OiixPlatform;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oii.oiix.OiixTeePrintStream;
import oracle.sysman.oii.oiix.OiixUtilityOps;
import oracle.sysman.oip.oipc.oipcc.OipccEndPrereqSessionException;
import oracle.sysman.oip.oipc.oipcc.OipccPreReqSession;
import oracle.sysman.oip.oipc.oipcl.OipclPrereqLogger;

public class OipccPrereqApp
extends OiicBaseApp
implements OiicISessionProxy {
    public static final int S_EXIT_SUCCESS = 0;
    public static final int S_EXIT_FAILURE = -1;
    public static final int S_EXIT_PREREQ_ERROR = 1;
    public static final int S_EXIT_PREREQ_WARNING = 2;
    private OipccPreReqSession m_oSession;
    private static int m_iExitCode;
    private OipclPrereqLogger m_prereqLogger;

    public OipccPrereqApp(String sAppName) {
        super(sAppName);
    }

    private static void setExitCode(int iCode) {
        m_iExitCode = iCode;
    }

    public OipccPreReqSession getPrereqSession() {
        return this.m_oSession;
    }

    protected String getSystemPropertyPrefix() {
        return "oracle.installer.";
    }

    void initialize() throws OipccEndPrereqSessionException {
        String sLogLoc = System.getProperty("oracle.installer.prereqLogLoc");
        if (sLogLoc == null || sLogLoc.length() == 0) {
            sLogLoc = OiixPathOps.concatPath((String)System.getProperty("user.home"), (String)"prereq/log");
            System.setProperty("oracle.installer.prereqLogLoc", sLogLoc);
        }
        try {
            OipclPrereqLogger.initialize(sLogLoc);
            this.createDuplicateStreams(sLogLoc);
            this.m_prereqLogger = OipclPrereqLogger.getLogger();
            OiicSessionProvider.setSessionProxy((OiicISessionProxy)this);
            this.m_oSession = new OipccPreReqSession(this.getCommandLineArgs());
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            throw new OipccEndPrereqSessionException(ioe);
        }
    }

    public void executePrereqs() {
        try {
            this.initialize();
            OiixJarClassLoader.setEnableMultipleLoading((boolean)true);
            int iExCode = this.m_oSession.executePrereqs();
            OipccPrereqApp.setExitCode(0);
            if (Boolean.getBoolean("oracle.installer.detailedExitCodes")) {
                OipccPrereqApp.setExitCode(iExCode);
            }
        }
        catch (OipccEndPrereqSessionException e) {
            OiiolTextLogger.writeToLogAndConsole((String)("Session ended due to error: " + e.getMessage()));
            OipccPrereqApp.setExitCode(-1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        OipccPrereqApp prereqApp = new OipccPrereqApp("prereqchecker");
        try {
            String sLibraryLoc;
            Properties sysProps;
            String sOUILoc;
            prereqApp.displayStartupMessages();
            prereqApp.processCommandLine(args);
            prereqApp.setJREScratchDirectories();
            if (prereqApp.isHelpOptionSpecified()) {
                prereqApp.displayHelp();
                System.exit(0);
            }
            if (Boolean.getBoolean("oracle.installer.debug")) {
                OiipgSRVMTracing.setTraceEnabled((boolean)true);
                OiipgSRVMTracing.setTraceLevel((int)5);
            }
            if ((sOUILoc = (sysProps = System.getProperties()).getProperty("oracle.installer.oui_loc")) != null && ((sLibraryLoc = sysProps.getProperty("oracle.installer.library_loc")) == null || sLibraryLoc.startsWith(".") || sLibraryLoc.startsWith(".."))) {
                sLibraryLoc = OiixPathOps.concatPath((String)sOUILoc, (String)"lib");
                sLibraryLoc = OiixPathOps.concatPath((String)sLibraryLoc, (String)OiixPlatform.getCurrentPlatformDirectoryName());
                sLibraryLoc = OiixPathOps.getNativeForm((String)sLibraryLoc);
                sysProps.put("oracle.installer.library_loc", sLibraryLoc);
            }
            prereqApp.executePrereqs();
            OiixJarClassLoader.setEnableMultipleLoading((boolean)false);
        }
        catch (OiicInvalidCmdLineException e) {
            Object[] msgArgs = new String[]{e.getMessage()};
            String sInvalidArgsError = OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcc.resources.OipccRuntimeRes", (String)"20003", (Object[])msgArgs);
            System.out.println(sInvalidArgsError);
            OipccPrereqApp.setExitCode(-1);
        }
        finally {
            System.exit(m_iExitCode);
        }
    }

    private String getBannerMessage() {
        String sAppExternalName = "Prerequisite Checker";
        String sVersion = OiicInstVersion.getVersionString();
        Object[] args = new String[]{sAppExternalName, sVersion};
        return OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcc.resources.OipccRuntimeRes", (String)"OIIPC41", (Object[])args);
    }

    private static String getCopyrightMessage() {
        Object[] sArgs = new String[]{OiicInstVersion.getCopyrightCurrentYear()};
        return OiixResourceBundle.getString((String)"S_BANNER_COPYRIGHT", (Object[])sArgs);
    }

    private void displayStartupMessages() {
        System.out.println("\n" + this.getBannerMessage());
        System.out.println(this.getCopyrightMessage() + "\n");
    }

    protected String getPropFileName() {
        return "prereqchecker_app";
    }

    public OiicISession getCurrentSession() {
        return this.m_oSession;
    }

    private void createDuplicateStreams(String sLogLoc) throws IOException {
        String logsDir = sLogLoc;
        String fileName = this.getOutStreamFileName() + OiixUtilityOps.getSessionTimeStamp();
        File dupOut = new File(logsDir, fileName + ".out");
        File dupErr = new File(logsDir, fileName + ".err");
        OiixTeePrintStream.setOutputTee((String)dupOut.getPath());
        OiixTeePrintStream.setErrorTee((String)dupErr.getPath());
        if (OiixPlatform.getPlatGroup((int)OiixPlatform.getCurrentPlatform()) == -1) {
            try {
                OiipuUnixOps.changePermission((String)OiixTeePrintStream.getErrFileLoc(), (int)384);
                OiipuUnixOps.changePermission((String)OiixTeePrintStream.getOutFileLoc(), (int)384);
            }
            catch (OiilNativeException natEx) {
                natEx.printStackTrace();
            }
        }
    }

    private String getOutStreamFileName() {
        return "prereq";
    }
}

