/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oip.oipc.oipcf;

import java.util.Iterator;
import oracle.sysman.oii.oiix.OiixAssert;
import oracle.sysman.oii.oiix.OiixInvalidDataException;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oii.oiix.OiixSet;
import oracle.sysman.oip.oipc.oipcf.OipcfFixUpRule;
import oracle.sysman.oip.oipc.oipcf.OipcfFixUpRuleNotFoundException;

public class OipcfFixUpRuleSet {
    private String m_sClass = null;
    private String m_sName = null;
    private OiixSet m_oFixUpRules = null;
    private static final String FIXUP_RULE_CLASSNAME = "oracle.sysman.oip.oipc.oipcf.OipcfFixUpRule";

    OipcfFixUpRuleSet(String sName, String sClass) {
        this.m_sName = sName;
        this.m_sClass = sClass;
    }

    String getClassName() {
        return this.m_sClass;
    }

    String getName() {
        return this.m_sName;
    }

    Iterator getFixUpRules() {
        Iterator oFixUpRules = null;
        try {
            oFixUpRules = this.m_oFixUpRules == null ? new OiixSet(FIXUP_RULE_CLASSNAME).elementsVect().iterator() : this.m_oFixUpRules.elementsVect().iterator();
        }
        catch (OiixInvalidDataException e) {
            OiixAssert.assertion((boolean)false, (String)("Unexpected invalid data exception encountered:" + e.getMessage()));
        }
        return oFixUpRules;
    }

    OipcfFixUpRule getFixUpRule(String sFixUpRule) throws OipcfFixUpRuleNotFoundException {
        OipcfFixUpRule oFixUpRule = null;
        if (this.m_oFixUpRules != null) {
            oFixUpRule = (OipcfFixUpRule)this.m_oFixUpRules.getElementLike((Object)sFixUpRule);
        }
        if (oFixUpRule == null) {
            Object[] args = new String[]{sFixUpRule};
            throw new OipcfFixUpRuleNotFoundException("OUI-65002", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcf.resources.OipcfRuntimeRes", (String)"OUI-65002", (Object[])args));
        }
        return oFixUpRule;
    }

    OipcfFixUpRule addFixUpRule(OipcfFixUpRule fixUpRule) {
        if (fixUpRule != null) {
            try {
                if (this.m_oFixUpRules == null) {
                    this.m_oFixUpRules = new OiixSet(FIXUP_RULE_CLASSNAME);
                }
                fixUpRule = (OipcfFixUpRule)this.m_oFixUpRules.addElement((Object)fixUpRule);
            }
            catch (OiixInvalidDataException e) {
                OiixAssert.assertion((boolean)false, (String)("Unexpected invalid data exception encountered:" + e.getMessage()));
            }
        }
        return fixUpRule;
    }

    public boolean equals(Object o) {
        boolean bResult = false;
        if (o != null) {
            if (o == this) {
                bResult = true;
            } else if (o instanceof OipcfFixUpRuleSet) {
                OipcfFixUpRuleSet other = (OipcfFixUpRuleSet)o;
                bResult = this.getName().equalsIgnoreCase(other.getName());
            } else if (o instanceof String) {
                String other = (String)o;
                bResult = this.getName().equalsIgnoreCase(other);
            }
        }
        return bResult;
    }

    public int hashCode() {
        return this.m_sName.toLowerCase().hashCode();
    }
}

