/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oip.oipc.oipcp;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oip.oipc.oipcp.OipcpIPrereqChecker;
import oracle.sysman.oip.oipc.oipcp.OipcpIPrereqListener;
import oracle.sysman.oip.oipc.oipcp.OipcpPrereqEvent;
import oracle.sysman.oip.oipc.oipcp.OipcpPrereqInputException;
import oracle.sysman.oip.oipc.oipcp.OipcpPrerequisiteCheck;
import oracle.sysman.oip.oipc.oipcp.OipcpPrerequisiteResult;
import oracle.sysman.oip.oipc.oipcu.OipcuPrereqProps;
import oracle.sysman.oix.oixd.OixdDOMReader;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class OipcpPrereqWriter
implements OipcpIPrereqListener {
    private Map m_oPrereqResultsMap = new HashMap(10, 10.0f);
    private OipcuPrereqProps m_oPrereqProps;

    public OipcpPrereqWriter(OipcuPrereqProps oProps) {
        this.m_oPrereqProps = oProps;
    }

    @Override
    public void onPrereqEvent(OipcpPrereqEvent oEvent) {
        int nEventId = oEvent.getID();
        switch (nEventId) {
            case 3: {
                OipcpPrerequisiteCheck oCheck = (OipcpPrerequisiteCheck)oEvent.getEventInfo();
                this.m_oPrereqResultsMap.put(oCheck.getName(), oCheck.getResult());
                break;
            }
            case 1: {
                this.writeResults();
            }
        }
    }

    private void writeResults(String sFile) {
        char firstChar;
        if (sFile.length() > 0 && (firstChar = sFile.charAt(0)) == '/') {
            sFile = sFile.substring(1);
        }
        String sDir = "";
        int iSep = sFile.lastIndexOf(47);
        if (iSep != -1) {
            sDir = sFile.substring(0, iSep);
        }
        String sInputFile = OiixPathOps.getNativeForm((String)OiixPathOps.concatPath((String)this.m_oPrereqProps.getConfigLoc(), (String)sFile));
        File oInputFile = new File(sInputFile);
        String sOutputFileName = this.constructOutputFileName(sFile);
        String sOutputFile = OiixPathOps.concatPath((String)this.m_oPrereqProps.getResultsLoc(), (String)sOutputFileName);
        File oOutputFile = new File(sOutputFile = OiixPathOps.getNativeForm((String)sOutputFile));
        if (oOutputFile.exists()) {
            oOutputFile.delete();
        }
        try {
            FileInputStream in = new FileInputStream(sInputFile);
            Document oPrereqDoc = OixdDOMReader.getDocument((InputStream)in);
            Element oPrereqTestsNode = oPrereqDoc.getDocumentElement();
            NodeList oCheckNodes = oPrereqTestsNode.getElementsByTagName("PREREQUISITE");
            int nSize = oCheckNodes.getLength();
            for (int i = 0; i < nSize; ++i) {
                Element oNode = (Element)oCheckNodes.item(i);
                OipcpPrerequisiteCheck oCheck = this.createPrereqCheck(oNode, sInputFile);
                if (!this.m_oPrereqResultsMap.containsKey(oCheck.getName())) continue;
                OipcpPrerequisiteResult oResult = (OipcpPrerequisiteResult)this.m_oPrereqResultsMap.get(oCheck.getName());
                Element resultNode = oPrereqDoc.createElement("RESULT");
                resultNode.setAttribute("VALUE", oResult.getEnglishResultText());
                String sResultText = oResult.getFormattedResultText();
                resultNode.setAttribute("TEXT", sResultText);
                oNode.appendChild(resultNode);
            }
            File sOutputDir = new File(OiixPathOps.concatPath((String)this.m_oPrereqProps.getResultsLoc(), (String)sDir));
            sOutputDir.mkdirs();
            DOMSource source = new DOMSource(oPrereqDoc);
            File out = new File(sOutputFile);
            FileOutputStream outStream = new FileOutputStream(sOutputFile);
            StreamResult result = new StreamResult(outStream);
            Transformer xformer = TransformerFactory.newInstance().newTransformer();
            xformer.transform(source, result);
        }
        catch (TransformerConfigurationException tcEx) {
            tcEx.printStackTrace();
        }
        catch (TransformerException tEx) {
            tEx.printStackTrace();
        }
        catch (OipcpPrereqInputException pe) {
            pe.printStackTrace();
        }
        catch (SAXException se) {
            se.printStackTrace();
        }
        catch (ParserConfigurationException pe) {
            pe.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    private void writeResults() {
        Iterator oInputFiles = this.m_oPrereqProps.getFilesListForProperty("prerequisite_input");
        while (oInputFiles.hasNext()) {
            String sFile = (String)oInputFiles.next();
            this.writeResults(sFile);
        }
    }

    private OipcpPrerequisiteCheck createPrereqCheck(Element oNode, String sInputFile) throws OipcpPrereqInputException {
        String sName = oNode.getAttribute("NAME");
        String sTitle = oNode.getAttribute("EXTERNALNAME");
        String sTitleId = oNode.getAttribute("EXTERNALNAMEID");
        int nSeverity = this.getSeverityAsInt(oNode.getAttribute("SEVERITY"));
        String sDesc = "";
        String sDescId = "";
        NodeList oList = oNode.getElementsByTagName("DESCRIPTION");
        if (oList != null && oList.getLength() >= 1) {
            Element oElem = (Element)oList.item(0);
            sDesc = oElem.getAttribute("TEXT");
            sDescId = oElem.getAttribute("TEXTID");
        } else {
            sDesc = sName;
        }
        String sRule = "";
        String sRuleSet = "";
        String sRefFile = "";
        oList = oNode.getElementsByTagName("RULESETREF");
        if (oList != null && oList.getLength() >= 1) {
            Element oElem = (Element)oList.item(0);
            sRule = oElem.getAttribute("RULE");
            sRuleSet = oElem.getAttribute("NAME");
            sRefFile = oElem.getAttribute("FILE");
        }
        String sErrMsg = "";
        String sErrMsgId = "";
        oList = oNode.getElementsByTagName("PROBLEM");
        if (oList != null && oList.getLength() >= 1) {
            Element oElem = (Element)oList.item(0);
            sErrMsg = oElem.getAttribute("TEXT");
            sErrMsgId = oElem.getAttribute("TEXTID");
        }
        String sRecText = "";
        String sRecTextId = "";
        oList = oNode.getElementsByTagName("RECOMMENDATION");
        if (oList != null && oList.getLength() >= 1) {
            Element oElem = (Element)oList.item(0);
            sRecText = oElem.getAttribute("TEXT");
            sRecTextId = oElem.getAttribute("TEXTID");
        }
        OipcpPrerequisiteCheck oCheck = new OipcpPrerequisiteCheck(sName, sRuleSet, sRule, nSeverity, sErrMsg, sErrMsgId, sTitle, sTitleId, sDesc, sDescId, sRecText, sRecTextId, sRefFile);
        return oCheck;
    }

    private String formatResultText(OipcpPrerequisiteResult oResult) {
        String sExpectedHeader = OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcp.resources.OipcpRuntimeRes", (String)"OUI-62007");
        String sActualHeader = OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcp.resources.OipcpRuntimeRes", (String)"OUI-62008");
        StringBuffer sb = new StringBuffer(sExpectedHeader);
        sb.append(oResult.getExpectedResultString());
        sb.append(" ");
        sb.append(sActualHeader);
        sb.append(oResult.getActualResultString());
        return sb.toString();
    }

    private int getSeverityAsInt(String sSeverity) {
        int nSeverity = 1;
        if (sSeverity.equalsIgnoreCase("Error")) {
            nSeverity = 0;
        } else if (sSeverity.equalsIgnoreCase("Warning")) {
            nSeverity = 1;
        }
        return nSeverity;
    }

    private String constructOutputFileName(String sInputFileName) {
        String ext = ".xml";
        String outFileName = sInputFileName;
        int extIndex = sInputFileName.indexOf(".");
        if (extIndex != -1) {
            outFileName = sInputFileName.substring(0, extIndex) + "_results";
        }
        return outFileName + ext;
    }

    @Override
    public void registerChecker(OipcpIPrereqChecker oChecker) {
    }
}

