/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.opatchsdk;

import oracle.opatch.opatchsdk.OPatchArchiveAction;
import oracle.opatch.opatchsdk.OPatchCopyAction;
import oracle.opatch.opatchsdk.OPatchDeleteAction;
import oracle.opatch.opatchsdk.OPatchJarAction;
import oracle.opatch.opatchsdk.OPatchMakeAction;
import oracle.opatch.opatchsdk.OPatchOnewayCopyAction;
import oracle.opatch.opatchsdk.OPatchOnlineAction;

public abstract class OPatchAction {
    private int lineNumber = -1;
    private String oracleHomePath = null;
    public static final int INVALID_OPATCH_ACTION = -1;
    public static final int COPY_ACTION = 1;
    public static final int JAR_ACTION = 2;
    public static final int ARCHIVE_ACTION = 3;
    public static final int MAKE_ACTION = 4;
    public static final int ONLINE_ACTION = 5;
    public static final int ONEWAY_COPY_ACTION = 6;
    public static final int DELETE_ACTION = 7;

    protected void setLineNumber(int lineNumber) {
        this.lineNumber = lineNumber;
    }

    public String getOracleHome() {
        return this.oracleHomePath;
    }

    protected void setOracleHome(String oracleHomePath) {
        this.oracleHomePath = oracleHomePath;
    }

    public static int getActionType(OPatchAction pa) {
        if (pa instanceof OPatchCopyAction) {
            return 1;
        }
        if (pa instanceof OPatchJarAction) {
            return 2;
        }
        if (pa instanceof OPatchArchiveAction) {
            return 3;
        }
        if (pa instanceof OPatchMakeAction) {
            return 4;
        }
        if (pa instanceof OPatchOnlineAction) {
            return 5;
        }
        if (pa instanceof OPatchOnewayCopyAction) {
            return 6;
        }
        if (pa instanceof OPatchDeleteAction) {
            return 7;
        }
        return -1;
    }

    public abstract String getActionName();

    public abstract String getActionDescription();

    public abstract String getRelativeChildPath();

    public abstract String getRelativeParentFilePath();

    public int getLineNumber() {
        return this.lineNumber;
    }
}

