/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.opatchsdk;

import java.io.File;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import oracle.opatch.CopyAction;
import oracle.opatch.FMWClientFactory;
import oracle.opatch.OneOffEntry;
import oracle.opatch.PatchComponent;
import oracle.opatch.PatchObject;
import oracle.opatch.PrereqSession;
import oracle.opatch.fmwpatchverbs.DeployActionEl;
import oracle.opatch.ipm.IIPMReadServices;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.opatchprereq.PrereqAPI;
import oracle.opatch.opatchsdk.OPatchAction;
import oracle.opatch.opatchsdk.OPatchComponent;
import oracle.opatch.opatchsdk.OPatchCopyAction;
import oracle.opatch.opatchsdk.OPatchException;
import oracle.opatch.opatchsdk.OPatchFAAutomationAction;
import oracle.opatch.opatchsdk.OPatchFAOperation;
import oracle.opatch.opatchsdk.OPatchFAStep;
import oracle.opatch.opatchsdk.OPatchPatch;
import oracle.opatch.opatchsdk.OPatchPatchType;
import oracle.opatch.opatchsdk.OPatchStepOperation;
import oracle.opatch.opatchsdk.OPatchUtils;
import oracle.opatch.patchverbs.AutomationElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OPatchDeployAction
extends OPatchFAAutomationAction
implements Cloneable {
    protected DeployActionEl dael = null;
    protected static Map<CopyAction, String> copyVerHash = null;
    protected Map<String, OPatchCopyAction> copyPaths = null;
    protected boolean switchOffPatchInstallCheck = false;
    protected String inputPatchLoc = "";

    protected OPatchDeployAction(AutomationElement auto_el) {
        super(auto_el);
        this.dael = (DeployActionEl)auto_el;
    }

    protected OPatchDeployAction() {
    }

    @Override
    protected Map constructMap() {
        return super.constructMap();
    }

    protected void doPrereq(OPatchFAOperation operation, String patchLocation) throws OPatchException {
        try {
            this.inputPatchLoc = patchLocation;
            this.doPrereq(operation);
            Object var5_3 = null;
            this.inputPatchLoc = "";
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            this.inputPatchLoc = "";
            throw throwable;
        }
    }

    protected void setCopyPathsWithOracleHomeComp(Map<String, OPatchCopyAction> m) {
        this.copyPaths = m;
    }

    protected static void resetCopyVerHashMap() {
        copyVerHash = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static void setCopyVerHashMap(String oracleHomePath) throws OPatchException {
        OPatchException ex;
        block19: {
            block17: {
                block18: {
                    ex = null;
                    try {
                        try {
                            if (copyVerHash != null) {
                                Object var5_2 = null;
                                if (oracleHomePath.equals("")) break block17;
                                break block18;
                            }
                            OPatchUtils.lockHome(oracleHomePath);
                            copyVerHash = PrereqAPI.getCopyActionMap((String)oracleHomePath);
                            break block19;
                        }
                        catch (Throwable t) {
                            OPatchException oe = new OPatchException(t.getMessage());
                            oe.setStackTrace(t.getStackTrace());
                            ex = oe;
                            Object var5_4 = null;
                            if (!oracleHomePath.equals("")) {
                                try {
                                    OPatchUtils.unlockHome(oracleHomePath);
                                }
                                catch (Throwable t2) {
                                    OPatchException oe2 = new OPatchException(t2.getMessage());
                                    oe2.setStackTrace(t2.getStackTrace());
                                    throw oe2;
                                }
                            }
                            if (ex == null) return;
                            throw ex;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var5_5 = null;
                        if (!oracleHomePath.equals("")) {
                            try {}
                            catch (Throwable t2) {
                                OPatchException oe2 = new OPatchException(t2.getMessage());
                                oe2.setStackTrace(t2.getStackTrace());
                                throw oe2;
                            }
                            OPatchUtils.unlockHome(oracleHomePath);
                        }
                        if (ex == null) throw throwable;
                        throw ex;
                    }
                }
                try {}
                catch (Throwable t2) {
                    OPatchException oe2 = new OPatchException(t2.getMessage());
                    oe2.setStackTrace(t2.getStackTrace());
                    throw oe2;
                }
                OPatchUtils.unlockHome(oracleHomePath);
            }
            if (ex == null) return;
            throw ex;
        }
        Object var5_3 = null;
        if (!oracleHomePath.equals("")) {
            try {}
            catch (Throwable t2) {
                OPatchException oe2 = new OPatchException(t2.getMessage());
                oe2.setStackTrace(t2.getStackTrace());
                throw oe2;
            }
            OPatchUtils.unlockHome(oracleHomePath);
        }
        if (ex == null) return;
        throw ex;
    }

    protected void doPrereqForPatchLoc(OPatchFAOperation operation, String patchLocation) throws OPatchException {
        OPatchPatch patch = null;
        OPatchStepOperation step = null;
        try {
            patch = new OPatchPatch(patchLocation);
            if (patch == null) {
                String errorMsg = "OPatch was not able to get a valid patch location input.";
                String stepMsg = "Check patch location";
                step = OPatchUtils.constructFailedStep(OPatchFAStep.CHECK_ORACLE_HOME_BIND_TO_ARTIFACT, stepMsg, errorMsg, null);
                this.setFailedPrereqStep(step);
                OLogger.justlog((int)OLogger.INFO, (String)step.toString());
                throw new OPatchException(errorMsg);
            }
        }
        catch (Exception e) {
            String errorMsg = "OPatch was not able to get a valid patch location input.";
            String stepMsg = "Check patch location";
            RuntimeException r = new RuntimeException(e.getMessage());
            r.setStackTrace(e.getStackTrace());
            step = OPatchUtils.constructFailedStep(OPatchFAStep.CHECK_PATCH_LOCATION, stepMsg, errorMsg, r);
            this.setFailedPrereqStep(step);
            OLogger.justlog((int)OLogger.INFO, (String)step.toString());
            OPatchException re = new OPatchException(errorMsg);
            re.setStackTrace(e.getStackTrace());
            throw re;
        }
        OPatchPatch appliedPatch = this.getWrapperPatch();
        if (appliedPatch == null) {
            String errorMsg = "OPatch was not able to find out the patch to which this artifact is mapped.";
            String stepMsg = "Check if there is a patch associated with the artifact.";
            step = OPatchUtils.constructFailedStep(OPatchFAStep.CHECK_ENCLOSED_PATCH_FOR_ARTIFACT, stepMsg, errorMsg, null);
            this.setFailedPrereqStep(step);
            OLogger.justlog((int)OLogger.INFO, (String)step.toString());
            throw new OPatchException(errorMsg);
        }
        Calendar cal1 = Calendar.getInstance();
        Calendar cal2 = Calendar.getInstance();
        cal1.setTime(patch.getCreationTime());
        cal2.setTime(appliedPatch.getCreationTime());
        if (!appliedPatch.equals(patch) || !cal1.equals(cal2)) {
            String errorMsg = "OPatch finds that input patch location and the Oracle Home artifact based patch are not the same.";
            String stepMsg = "Compare if two patches are same.";
            step = OPatchUtils.constructFailedStep(OPatchFAStep.COMPARE_TWO_SAME_PATCHES, stepMsg, errorMsg, null);
            this.setFailedPrereqStep(step);
            OLogger.justlog((int)OLogger.INFO, (String)step.toString());
            throw new OPatchException(errorMsg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void doPrereq(OPatchFAOperation operation) throws OPatchException {
        block39: {
            String oracleHomePath = this.getOracleHome();
            OPatchException ex = null;
            OPatchStepOperation step = null;
            if (oracleHomePath == null || oracleHomePath.equals("")) {
                String errorMsg = "OPatch was not able to find out the Oracle Home for which this artifact needs to be mapped.";
                String stepMsg = "Find if artifact is mapped to OH.";
                step = OPatchUtils.constructFailedStep(OPatchFAStep.CHECK_ORACLE_HOME_BIND_TO_ARTIFACT, stepMsg, errorMsg, null);
                this.setFailedPrereqStep(step);
                OLogger.justlog((int)OLogger.INFO, (String)step.toString());
                throw new OPatchException(errorMsg);
            }
            OPatchPatch patch = this.getWrapperPatch();
            if (patch == null) {
                String errorMsg = "OPatch was not able to find out the patch to which this artifact is mapped.";
                String stepMsg = "Check if there is a patch associated with the artifact.";
                step = OPatchUtils.constructFailedStep(OPatchFAStep.CHECK_ENCLOSED_PATCH_FOR_ARTIFACT, stepMsg, errorMsg, null);
                this.setFailedPrereqStep(step);
                OLogger.justlog((int)OLogger.INFO, (String)step.toString());
                throw new OPatchException(errorMsg);
            }
            try {
                OPatchUtils.lockHome(oracleHomePath);
            }
            catch (OPatchException e) {
                String errorMsg = "Not able to lock the Oracle Home \"" + oracleHomePath + "\"";
                String stepMsg = "Check if we are able to lock the Oracle Home.";
                RuntimeException re = new RuntimeException(e.getMessage());
                re.setStackTrace(e.getStackTrace());
                step = OPatchUtils.constructFailedStep(OPatchFAStep.CHECK_LOCK_HOME, stepMsg, errorMsg, re);
                this.setFailedPrereqStep(step);
                OLogger.justlog((int)OLogger.INFO, (String)step.toString());
                throw e;
            }
            if (!this.isDryRun()) {
                if (!this.switchOffPatchInstallCheck && !OPatchUtils.isApplied(patch, oracleHomePath)) {
                    String errorMsg = "OPatch requires that Patch \"" + patch.getPatchLanguageId() + "\" be " + "installed in Oracle Home \"" + oracleHomePath + "\" for the FA operation \"" + operation.toString() + "\"";
                    String stepMsg = "Check if FA Patch is installed.";
                    step = OPatchUtils.constructFailedStep(OPatchFAStep.CHECK_FA_PATCH_INSTALLED, stepMsg, errorMsg, null);
                    this.setFailedPrereqStep(step);
                    OLogger.justlog((int)OLogger.INFO, (String)step.toString());
                    throw new OPatchException(errorMsg);
                }
                boolean fileCopied = true;
                try {
                    fileCopied = OPatchUtils.isFileCopied(patch, this, oracleHomePath);
                }
                catch (Exception e) {
                    String errorMsg = "OPatch was not able to verify if the artifact was copied during the installation of the patch \"" + patch.getPatchLanguageId() + "\"";
                    String stepMsg = "Check if the artifact file is copied.";
                    RuntimeException r = new RuntimeException(e.getMessage());
                    r.setStackTrace(e.getStackTrace());
                    step = OPatchUtils.constructFailedStep(OPatchFAStep.CHECK_ARTIFACT_COPY, stepMsg, errorMsg, r);
                    this.setFailedPrereqStep(step);
                    OLogger.justlog((int)OLogger.INFO, (String)step.toString());
                    OPatchException re = new OPatchException(errorMsg);
                    re.setStackTrace(e.getStackTrace());
                    throw re;
                }
                if (!fileCopied) {
                    String errorMsg = "OPatch will not able to deploy this artifact as the corresponding file was not copied during installation of the patch \"" + patch.getPatchLanguageId() + "\"";
                    String stepMsg = "Check if the artifact file is copied.";
                    step = OPatchUtils.constructFailedStep(OPatchFAStep.CHECK_ARTIFACT_COPY, stepMsg, errorMsg, null);
                    this.setFailedPrereqStep(step);
                    OLogger.justlog((int)OLogger.INFO, (String)step.toString());
                    throw new OPatchException(errorMsg);
                }
            } else {
                if (this.copyPaths == null) {
                    this.copyPaths = new HashMap<String, OPatchCopyAction>();
                    Vector includedPC = new Vector();
                    PrereqAPI.checkComponents((String)this.getOracleHome(), (PatchObject)patch.po, includedPC);
                    Vector validActions = new Vector();
                    for (int i = 0; i < includedPC.size(); ++i) {
                        PatchComponent validPC = (PatchComponent)includedPC.get(i);
                        OPatchComponent oPC = new OPatchComponent(validPC);
                        OPatchAction[] oa = patch.getActions(oPC);
                        for (int j = 0; j < oa.length; ++j) {
                            if (!(oa[j] instanceof OPatchCopyAction)) continue;
                            OPatchCopyAction oca = (OPatchCopyAction)oa[j];
                            this.copyPaths.put(new File(oca.getCompleteFilePath(this.getOracleHome())).getCanonicalPath(), oca);
                        }
                    }
                }
                if (this.copyPaths.size() == 0) {
                    String errorMsg = "OPatch will not able to deploy this artifact as there are no valid patch actions to be applied for the Oracle Home.";
                    String stepMsg = "Check if copy action can be performed.";
                    step = OPatchUtils.constructFailedStep(OPatchFAStep.CHECK_ARTIFACT_COPY, stepMsg, errorMsg, null);
                    this.setFailedPrereqStep(step);
                    OLogger.justlog((int)OLogger.INFO, (String)step.toString());
                    throw new OPatchException(errorMsg);
                }
                if (patch.getPatchType() == OPatchPatchType.SNOWBALL) {
                    String cp = this.getCompleteDeployFilePath();
                    String cpCan = new File(cp).getCanonicalPath();
                    boolean cpPresent = false;
                    if (this.copyPaths.containsKey(cpCan)) {
                        cpPresent = true;
                    }
                    if (!cpPresent) {
                        String errorMsg = "OPatch will not able to deploy this artifact as there is no equivalent copy action in the patch.";
                        String stepMsg = "Check for the presence of copy action in the patch.";
                        step = OPatchUtils.constructFailedStep(OPatchFAStep.CHECK_ARTIFACT_COPY, stepMsg, errorMsg, null);
                        this.setFailedPrereqStep(step);
                        OLogger.justlog((int)OLogger.INFO, (String)step.toString());
                        throw new OPatchException(errorMsg);
                    }
                    Map m = null;
                    m = copyVerHash != null ? copyVerHash : PrereqAPI.getCopyActionMap((String)oracleHomePath);
                    OPatchCopyAction copyAct = this.copyPaths.get(cpCan);
                    if (!PrereqAPI.checkFileVersion((String)oracleHomePath, (CopyAction)copyAct.getCopyAction(), (Map)m)) {
                        String errorMsg = "OPatch will not able to deploy this artifact as the equivalent copy action has version less than or equal to the ones installed in Oracle Home.";
                        String stepMsg = "Check if copy action can be performed.";
                        step = OPatchUtils.constructFailedStep(OPatchFAStep.CHECK_ARTIFACT_COPY, stepMsg, errorMsg, null);
                        this.setFailedPrereqStep(step);
                        OLogger.justlog((int)OLogger.INFO, (String)step.toString());
                        throw new OPatchException(errorMsg);
                    }
                }
            }
            if (!this.isDryRun() && (this.inputPatchLoc == null || this.inputPatchLoc.equals(""))) {
                boolean isTouched = false;
                try {
                    if (!this.switchOffPatchInstallCheck) {
                        isTouched = OPatchDeployAction.isTouchedByLaterAppliedPatch(new OPatchDeployAction[]{this});
                    }
                }
                catch (Exception e) {
                    String errorMsg = "OPatch could not figure out if some patches installed later touch this artifact \"" + this.toString() + "\"";
                    String stepMsg = "Check if any later installed patch touches this artifact";
                    RuntimeException re = new RuntimeException(e.getMessage());
                    re.setStackTrace(e.getStackTrace());
                    step = OPatchUtils.constructFailedStep(OPatchFAStep.CHECK_ARTIFACT_TOUCHED_BY_LATER_INSTALLED_PATCH, stepMsg, errorMsg, re);
                    this.setFailedPrereqStep(step);
                    OLogger.justlog((int)OLogger.INFO, (String)step.toString());
                    throw new OPatchException(errorMsg);
                }
                if (isTouched) {
                    String errorMsg = "OPatch cannot deploy this artifact as this artifact \"" + this.toString() + "\"" + "is touched by a later installed patch";
                    String stepMsg = "Check if any later installed patch touches this artifact";
                    step = OPatchUtils.constructFailedStep(OPatchFAStep.CHECK_ARTIFACT_TOUCHED_BY_LATER_INSTALLED_PATCH, stepMsg, errorMsg, null);
                    this.setFailedPrereqStep(step);
                    OLogger.justlog((int)OLogger.INFO, (String)step.toString());
                    throw new OPatchException(errorMsg);
                }
            }
            Object var15_39 = null;
            OPatchStepOperation failedStep = null;
            try {
                if (!oracleHomePath.equals("")) {
                    OPatchUtils.unlockHome(oracleHomePath);
                }
            }
            catch (Throwable t2) {
                String errorMsg = "OPatch failed to unlock the Oracle Home \"" + oracleHomePath + "\"";
                String stepMsg = "Check if OPatch can unlock the Oracle Home.";
                RuntimeException re = new RuntimeException(t2.getMessage());
                re.setStackTrace(t2.getStackTrace());
                failedStep = OPatchUtils.constructFailedStep(OPatchFAStep.CHECK_UNLOCK_HOME, stepMsg, errorMsg, re);
                OLogger.justlog((int)OLogger.INFO, (String)failedStep.toString());
            }
            if (ex != null) {
                throw ex;
            }
            break block39;
            {
                catch (Throwable t) {
                    OPatchException oe = new OPatchException(t.getMessage());
                    oe.setStackTrace(t.getStackTrace());
                    ex = oe;
                    Object var15_40 = null;
                    failedStep = null;
                    try {
                        if (!oracleHomePath.equals("")) {
                            OPatchUtils.unlockHome(oracleHomePath);
                        }
                    }
                    catch (Throwable t2) {
                        String errorMsg = "OPatch failed to unlock the Oracle Home \"" + oracleHomePath + "\"";
                        String stepMsg = "Check if OPatch can unlock the Oracle Home.";
                        RuntimeException re = new RuntimeException(t2.getMessage());
                        re.setStackTrace(t2.getStackTrace());
                        failedStep = OPatchUtils.constructFailedStep(OPatchFAStep.CHECK_UNLOCK_HOME, stepMsg, errorMsg, re);
                        OLogger.justlog((int)OLogger.INFO, (String)failedStep.toString());
                    }
                    if (ex != null) {
                        throw ex;
                    }
                }
            }
            catch (Throwable throwable) {
                Object var15_41 = null;
                failedStep = null;
                try {
                    if (!oracleHomePath.equals("")) {
                        OPatchUtils.unlockHome(oracleHomePath);
                    }
                }
                catch (Throwable t2) {
                    String errorMsg = "OPatch failed to unlock the Oracle Home \"" + oracleHomePath + "\"";
                    String stepMsg = "Check if OPatch can unlock the Oracle Home.";
                    RuntimeException re = new RuntimeException(t2.getMessage());
                    re.setStackTrace(t2.getStackTrace());
                    failedStep = OPatchUtils.constructFailedStep(OPatchFAStep.CHECK_UNLOCK_HOME, stepMsg, errorMsg, re);
                    OLogger.justlog((int)OLogger.INFO, (String)failedStep.toString());
                }
                if (ex != null) {
                    throw ex;
                }
                throw throwable;
            }
        }
    }

    public String getDeployFileName() {
        return this.dael.getDeployFileName();
    }

    public String getDeployFilePath() {
        return this.dael.getDeployPath();
    }

    public String getCompleteDeployFilePath() throws OPatchException {
        String fullPath = "";
        try {
            String oracleHomePath = this.getOracleHome();
            String filePath = this.getDeployFilePath();
            String fileName = this.getDeployFileName();
            fullPath = FMWClientFactory.sanitizePath((String)oracleHomePath, (String)filePath, (String)fileName);
        }
        catch (Exception e) {
            OPatchException re = new OPatchException(e.getMessage());
            re.setStackTrace(e.getStackTrace());
            throw re;
        }
        return fullPath;
    }

    protected static boolean isTouchedByLaterAppliedPatch(OPatchDeployAction[] actions) throws OPatchException {
        int k;
        IIPMReadServices readServices = null;
        if (actions == null || actions.length == 0) {
            throw new OPatchException("Input actions to isTouchedByLaterAppliedPatch() can't be null or empty");
        }
        try {
            readServices = PrereqSession.getReadServices((String)actions[0].getOracleHome());
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable t) {
            OLogger.justlog((int)OLogger.INFO, (String)"Unable to obtain inventory instance");
            OPatchException re = new OPatchException(t.getMessage());
            re.setStackTrace(t.getStackTrace());
            throw re;
        }
        boolean actionFound = false;
        Object[] activeOneOffs = readServices.getInstalledPatches();
        OneOffEntry[] inactiveOneOffs = readServices.getInactivePatches();
        Object[] oneOffs = null;
        if (!(activeOneOffs != null && activeOneOffs.length != 0 || inactiveOneOffs != null && inactiveOneOffs.length != 0)) {
            return false;
        }
        if (inactiveOneOffs != null) {
            if (activeOneOffs == null) {
                throw new OPatchException("The patch of the artifacts is not an active patch in Oracle Home or it was not installed.");
            }
            oneOffs = new OneOffEntry[activeOneOffs.length + inactiveOneOffs.length];
            System.arraycopy(activeOneOffs, 0, oneOffs, 0, activeOneOffs.length);
            System.arraycopy(inactiveOneOffs, 0, oneOffs, activeOneOffs.length, inactiveOneOffs.length);
        } else {
            oneOffs = activeOneOffs;
        }
        Arrays.sort(oneOffs);
        OPatchPatch patchObj = actions[0].getWrapperPatch();
        OneOffEntry targetOneOff = null;
        if (patchObj != null) {
            targetOneOff = patchObj.patch;
        }
        boolean currPatchFound = false;
        for (k = 0; k < oneOffs.length; ++k) {
            if (!oneOffs[k].equals((Object)targetOneOff)) continue;
            currPatchFound = true;
            break;
        }
        if (!currPatchFound) {
            return false;
        }
        for (int i = 0; i < k; ++i) {
            OPatchPatch laterPatch = new OPatchPatch((OneOffEntry)oneOffs[i]);
            for (int j = 0; j < actions.length; ++j) {
                try {
                    if (!OPatchUtils.isFileCopied(laterPatch, actions[j], actions[j].getOracleHome())) continue;
                    OLogger.justlog((int)OLogger.INFO, (String)("The artifact \"" + actions[j].toString() + "\" is " + "touched by a later installed patch \"" + laterPatch.getPatchId() + "\". Hence, this artifact cannot be deployed."));
                    actionFound = true;
                    continue;
                }
                catch (Exception e) {
                    OPatchException re = new OPatchException(e.getMessage());
                    re.setStackTrace(e.getStackTrace());
                    throw re;
                }
            }
        }
        return actionFound;
    }

    @Override
    public String toString() {
        String strOutput = this.dael.toString();
        String oh = this.getOracleHome();
        if (oh != null && !oh.equals("")) {
            strOutput = strOutput.replaceAll("%ORACLE_HOME%", oh);
        }
        return strOutput;
    }

    @Override
    public Object clone() {
        OPatchDeployAction oda = (OPatchDeployAction)super.clone();
        DeployActionEl dEl = new DeployActionEl();
        oda.dael = dEl = (DeployActionEl)this.dael.clone();
        return oda;
    }

    public boolean equals(Object o) {
        if (o instanceof OPatchDeployAction) {
            OPatchDeployAction faAction = (OPatchDeployAction)o;
            return this.getDeployFileName().equals(faAction.getDeployFileName()) && this.getDeployFilePath().equals(faAction.getDeployFilePath());
        }
        return false;
    }

    public static void destroyObject() {
        if (copyVerHash != null) {
            copyVerHash.clear();
        }
    }
}

