/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.opatchsdk;

import oracle.opatch.opatchsdk.OPatchException;

public class OPatchNApplyOptions {
    private boolean skipConflict = false;
    private boolean forceConflict = false;
    private boolean optimize = false;
    private boolean autorollback_subsets = false;
    private boolean ohInstanceUp = false;
    private boolean local = true;
    private boolean continueOnPrereqFailure = false;
    private boolean noRelink = false;

    public OPatchNApplyOptions() {
    }

    public OPatchNApplyOptions(boolean skipConflict, boolean forceConflict) throws OPatchException {
        this.skipConflict = skipConflict;
        this.forceConflict = forceConflict;
        if (skipConflict && forceConflict) {
            throw new OPatchException("OPatch does not allow 'skipConflict' & 'forceConflict' to be given together as 'true'.");
        }
    }

    public OPatchNApplyOptions(boolean optimize) throws OPatchException {
        this.optimize = optimize;
    }

    public OPatchNApplyOptions skipConflict(boolean skipConflict) throws OPatchException {
        if (skipConflict && this.forceConflict) {
            throw new OPatchException("OPatch does not allow 'skipConflict' & 'forceConflict' to be given together as 'true'.");
        }
        this.skipConflict = skipConflict;
        return this;
    }

    public OPatchNApplyOptions forceConflict(boolean forceConflict) throws OPatchException {
        if (forceConflict && this.skipConflict) {
            throw new OPatchException("OPatch does not allow 'skipConflict' & 'forceConflict' to be given together as 'true'.");
        }
        this.forceConflict = forceConflict;
        return this;
    }

    public OPatchNApplyOptions optimize(boolean optimize) {
        this.optimize = optimize;
        return this;
    }

    public OPatchNApplyOptions noRelink(boolean noRelink) {
        this.noRelink = noRelink;
        return this;
    }

    public OPatchNApplyOptions autorollbackSubsets(boolean autorollback_subsets) {
        this.autorollback_subsets = autorollback_subsets;
        return this;
    }

    public OPatchNApplyOptions ohInstanceUp(boolean ohInstanceUp) {
        this.ohInstanceUp = ohInstanceUp;
        return this;
    }

    public OPatchNApplyOptions continueOnPrereqFailure(boolean continueOnPrereqFailure) {
        this.continueOnPrereqFailure = continueOnPrereqFailure;
        return this;
    }

    public boolean getskipConflict() {
        return this.skipConflict;
    }

    public boolean getforceConflict() {
        return this.forceConflict;
    }

    public boolean getOptimize() {
        return this.optimize;
    }

    public boolean getNoRelink() {
        return this.noRelink;
    }

    public boolean getAutorollbackSubsets() {
        return this.autorollback_subsets;
    }

    public boolean isOhInstanceUp() {
        return this.ohInstanceUp;
    }

    public boolean isLocal() {
        return this.local;
    }

    public boolean continueOnPrereqFailure() {
        return this.continueOnPrereqFailure;
    }
}

