/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.opatchsdk;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import model.common.AbstractBaseTarget;
import model.fafmw.WLAdminServer;
import model.fafmw.WLDomain;
import oracle.opatch.FMWClientFactory;
import oracle.opatch.fmwclient.FMWClient;
import oracle.opatch.opatchfafmw.SOAComposite;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.opatchsdk.OPatchDeployAction;
import oracle.opatch.opatchsdk.OPatchDeployException;
import oracle.opatch.opatchsdk.OPatchException;
import oracle.opatch.opatchsdk.OPatchFAAutomationAction;
import oracle.opatch.opatchsdk.OPatchFAClonedConfigInstance;
import oracle.opatch.opatchsdk.OPatchFAOperation;
import oracle.opatch.opatchsdk.OPatchFAStep;
import oracle.opatch.opatchsdk.OPatchFATarget;
import oracle.opatch.opatchsdk.OPatchPatch;
import oracle.opatch.opatchsdk.OPatchStepOperation;
import oracle.opatch.opatchsdk.OPatchUtils;
import oracle.opatch.patchverbs.AutomationElement;

public class OPatchSOARbDeployAction
extends OPatchDeployAction
implements Cloneable {
    private WLDomain domainInfo = null;

    protected OPatchSOARbDeployAction(AutomationElement auto_el) {
        super(auto_el);
    }

    protected OPatchSOARbDeployAction() {
    }

    protected WLDomain getBoundDomain() {
        return this.domainInfo;
    }

    public String toString() {
        return super.toString();
    }

    protected Map constructMap() {
        HashMap<String, Object> env = new HashMap<String, Object>();
        Map superEnv = super.constructMap();
        env.putAll(superEnv);
        WLAdminServer adminServer = this.domainInfo.getWLAdminServer();
        String adminURL = adminServer.getURL();
        int adminPort = adminServer.getPort();
        String admP = adminServer.getPassword();
        String admUN = adminServer.getUserName();
        env.put("OPatch.COMMON_COMPONENTS_HOME", this.getCommonComponentsHome());
        env.put("AdminServerURL", adminURL + ":" + new Integer(adminPort).toString());
        env.put("ASP", admP.toCharArray());
        env.put("AdminUser", admUN);
        return env;
    }

    public void bindToClone(OPatchFAClonedConfigInstance faInstance, WLDomain domainInfo) throws OPatchException {
        if (faInstance == null) {
            throw new OPatchException("Please provide a non-null <OPatchFAClonedConfigInstance> object.");
        }
        if (!OPatchUtils.checkFAObjectSanity(faInstance, (AbstractBaseTarget)domainInfo)) {
            throw new OPatchException("The system model object could not be binded to cloned config instances.");
        }
        this.setBoundToConfigInstance(true);
        this.domainInfo = domainInfo;
    }

    public void deploy(String patchLocation) throws OPatchDeployException {
        try {
            this.inputPatchLoc = patchLocation;
            this.deploy();
            Object var4_2 = null;
            this.inputPatchLoc = "";
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            this.inputPatchLoc = "";
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void deploy() throws OPatchDeployException {
        block47: {
            String stepMsg;
            String errorMsg;
            String stepMsg2;
            FMWClient client = null;
            OPatchStepOperation failedStep = null;
            this.setFailedPrereqStep(null);
            this.setFailedClosingStep(null);
            String oracleHomePath = "";
            String logFile = "";
            boolean updatePrereqFailure = false;
            OPatchDeployException de = null;
            oracleHomePath = this.getOracleHome();
            OPatchPatch patch = this.getWrapperPatch();
            try {
                if (patch == null) {
                    throw new OPatchDeployException("Log file cannot be created because OPatch does not know the source patch for this artifact.");
                }
                String fileName = OPatchUtils.norm(this.getDeployFileName());
                String domainName = "";
                if (this.domainInfo != null) {
                    domainName = OPatchUtils.norm(this.domainInfo.getName());
                }
                logFile = OPatchUtils.initLogFile(oracleHomePath, patch.getLogTimeStamp(), "Deploy_SOARb_" + fileName + "_" + domainName, true);
                this.setLogFile(logFile);
            }
            catch (Throwable t) {
                stepMsg2 = "Check if log file is created properly for the operation.";
                String errorMsg2 = t.getMessage();
                failedStep = OPatchUtils.constructFailedStep(OPatchFAStep.CHECK_INIT_LOG_FILE, stepMsg2, errorMsg2, new RuntimeException(t));
                this.setFailedPrereqStep(failedStep);
            }
            if (!this.isArtifactBoundtoConfigInstance()) {
                String errorMsg3 = "Please bind the FA config instance object to the artifact using bindToClone() API.";
                stepMsg2 = "Check if artifact is bound to required end point instances from Cloned Configuration instance.";
                failedStep = OPatchUtils.constructFailedStep(OPatchFAStep.CHECK_FA_BIND_TO_CLONE_ARTIFACT, stepMsg2, errorMsg3, null);
                this.setFailedPrereqStep(failedStep);
                OLogger.log((int)OLogger.INFO, (String)failedStep.toString());
                throw new OPatchDeployException(errorMsg3);
            }
            if (this.inputPatchLoc != null && !this.inputPatchLoc.equals("")) {
                this.doPrereqForPatchLoc(OPatchFAOperation.PREREQ_DEPLOY, this.inputPatchLoc);
            }
            super.doPrereq(OPatchFAOperation.PREREQ_DEPLOY);
            try {
                OPatchUtils.lockHome(oracleHomePath);
            }
            catch (Throwable t) {
                errorMsg = "OPatch failed to lock the Oracle Home \"" + oracleHomePath + "\"";
                stepMsg = "Check if OPatch can lock the Oracle Home \"" + oracleHomePath + "\"";
                RuntimeException re = new RuntimeException(t.getMessage());
                re.setStackTrace(t.getStackTrace());
                failedStep = OPatchUtils.constructFailedStep(OPatchFAStep.CHECK_FA_BIND_TO_CLONE_ARTIFACT, stepMsg, errorMsg, re);
                this.setFailedPrereqStep(failedStep);
                OLogger.log((int)OLogger.INFO, (String)failedStep.toString());
                throw t;
            }
            try {
                client = FMWClientFactory.getClient((OPatchFAAutomationAction)this, (Map)this.constructMap(), (Properties)this.getInterviewProperties());
            }
            catch (Throwable t) {
                errorMsg = "OPatch failed to get the FMW client for artifact execution (Internal OPatch issue)";
                stepMsg = "Check if OPatch can get the client for artifact execution";
                RuntimeException re = new RuntimeException(t.getMessage());
                re.setStackTrace(t.getStackTrace());
                failedStep = OPatchUtils.constructFailedStep(OPatchFAStep.CHECK_FA_CLIENT, stepMsg, errorMsg, re);
                this.setFailedPrereqStep(failedStep);
                OLogger.log((int)OLogger.INFO, (String)failedStep.toString());
                throw t;
            }
            client.deploy();
            OPatchUtils.updatePrereq(client, this);
            updatePrereqFailure = true;
            OPatchStepOperation prereqStep = this.getFailedPrereqStep();
            if (prereqStep != null) {
                throw new OPatchDeployException("OPatch failed in prerequisite checks prior to deploy.");
            }
            Object var13_19 = null;
            try {
                if (!oracleHomePath.equals("")) {
                    OPatchUtils.unlockHome(oracleHomePath);
                }
            }
            catch (Throwable t2) {
                String errorMsg4 = "OPatch failed to unlock the Oracle Home \"" + oracleHomePath + "\"";
                String stepMsg3 = "Check if OPatch can unlock the Oracle Home.";
                RuntimeException re2 = new RuntimeException(t2.getMessage());
                re2.setStackTrace(t2.getStackTrace());
                failedStep = OPatchUtils.constructFailedStep(OPatchFAStep.CHECK_UNLOCK_HOME, stepMsg3, errorMsg4, re2);
                this.setFailedClosingStep(failedStep);
                OLogger.log((int)OLogger.INFO, (String)failedStep.toString());
            }
            OPatchUtils.closeLogFile();
            OPatchStepOperation prereqStep2 = this.getFailedPrereqStep();
            if (prereqStep2 != null) {
                if (client != null) {
                    client.close();
                }
                if (de != null) {
                    throw de;
                }
                return;
            }
            OPatchUtils.updateExecutionContext(client, this, OPatchFAOperation.DEPLOY);
            OPatchUtils.logExecutionContext(oracleHomePath, this.getOperatingFAContext(), "", this);
            if (client != null) {
                SOAComposite s = client.getSOAComposite();
                String rbPath = s.getPath();
                boolean failure = false;
                if (de != null) {
                    failure = true;
                }
                OPatchUtils.updateConfig(this.domainInfo, rbPath, failure, client.getSOAHost(), client.getSOAPort());
                if (this.getWrapperPatch() != null) {
                    OPatchUtils.logConfigContext(oracleHomePath, OPatchFATarget.getConfigContext(), this.getWrapperPatch().getLogTimeStamp(), this);
                }
                client.close();
            }
            if (de != null) {
                throw de;
            }
            break block47;
            {
                catch (Throwable t) {
                    if (!updatePrereqFailure) {
                        OPatchUtils.updatePrereq(client, this);
                        updatePrereqFailure = true;
                    }
                    while (t.getCause() != null) {
                        t = t.getCause();
                    }
                    OPatchDeployException re = new OPatchDeployException(t.getMessage());
                    re.setStackTrace(t.getStackTrace());
                    de = re;
                    Object var13_20 = null;
                    try {
                        if (!oracleHomePath.equals("")) {
                            OPatchUtils.unlockHome(oracleHomePath);
                        }
                    }
                    catch (Throwable t2) {
                        String errorMsg4 = "OPatch failed to unlock the Oracle Home \"" + oracleHomePath + "\"";
                        String stepMsg3 = "Check if OPatch can unlock the Oracle Home.";
                        RuntimeException re2 = new RuntimeException(t2.getMessage());
                        re2.setStackTrace(t2.getStackTrace());
                        failedStep = OPatchUtils.constructFailedStep(OPatchFAStep.CHECK_UNLOCK_HOME, stepMsg3, errorMsg4, re2);
                        this.setFailedClosingStep(failedStep);
                        OLogger.log((int)OLogger.INFO, (String)failedStep.toString());
                    }
                    OPatchUtils.closeLogFile();
                    prereqStep2 = this.getFailedPrereqStep();
                    if (prereqStep2 != null) {
                        if (client != null) {
                            client.close();
                        }
                        if (de != null) {
                            throw de;
                        }
                        return;
                    }
                    OPatchUtils.updateExecutionContext(client, this, OPatchFAOperation.DEPLOY);
                    OPatchUtils.logExecutionContext(oracleHomePath, this.getOperatingFAContext(), "", this);
                    if (client != null) {
                        SOAComposite s = client.getSOAComposite();
                        String rbPath = s.getPath();
                        boolean failure = false;
                        if (de != null) {
                            failure = true;
                        }
                        OPatchUtils.updateConfig(this.domainInfo, rbPath, failure, client.getSOAHost(), client.getSOAPort());
                        if (this.getWrapperPatch() != null) {
                            OPatchUtils.logConfigContext(oracleHomePath, OPatchFATarget.getConfigContext(), this.getWrapperPatch().getLogTimeStamp(), this);
                        }
                        client.close();
                    }
                    if (de != null) {
                        throw de;
                    }
                }
            }
            catch (Throwable throwable) {
                Object var13_21 = null;
                try {
                    if (!oracleHomePath.equals("")) {
                        OPatchUtils.unlockHome(oracleHomePath);
                    }
                }
                catch (Throwable t2) {
                    String errorMsg4 = "OPatch failed to unlock the Oracle Home \"" + oracleHomePath + "\"";
                    String stepMsg3 = "Check if OPatch can unlock the Oracle Home.";
                    RuntimeException re2 = new RuntimeException(t2.getMessage());
                    re2.setStackTrace(t2.getStackTrace());
                    failedStep = OPatchUtils.constructFailedStep(OPatchFAStep.CHECK_UNLOCK_HOME, stepMsg3, errorMsg4, re2);
                    this.setFailedClosingStep(failedStep);
                    OLogger.log((int)OLogger.INFO, (String)failedStep.toString());
                }
                OPatchUtils.closeLogFile();
                prereqStep2 = this.getFailedPrereqStep();
                if (prereqStep2 != null) {
                    if (client != null) {
                        client.close();
                    }
                    if (de != null) {
                        throw de;
                    }
                    return;
                }
                OPatchUtils.updateExecutionContext(client, this, OPatchFAOperation.DEPLOY);
                OPatchUtils.logExecutionContext(oracleHomePath, this.getOperatingFAContext(), "", this);
                if (client != null) {
                    SOAComposite s = client.getSOAComposite();
                    String rbPath = s.getPath();
                    boolean failure = false;
                    if (de != null) {
                        failure = true;
                    }
                    OPatchUtils.updateConfig(this.domainInfo, rbPath, failure, client.getSOAHost(), client.getSOAPort());
                    if (this.getWrapperPatch() != null) {
                        OPatchUtils.logConfigContext(oracleHomePath, OPatchFATarget.getConfigContext(), this.getWrapperPatch().getLogTimeStamp(), this);
                    }
                    client.close();
                }
                if (de != null) {
                    throw de;
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void doPrereq(OPatchFAOperation operation) throws OPatchException {
        block30: {
            String errorMsg;
            String stepMsg;
            OPatchStepOperation failedStep = null;
            this.setFailedPrereqStep(null);
            FMWClient client = null;
            OPatchException oe = null;
            String oracleHomePath = this.getOracleHome();
            OPatchPatch patch = this.getWrapperPatch();
            String logFile = "";
            this.setLogFile("");
            try {
                if (patch == null) {
                    throw new OPatchDeployException("Log file cannot be created because OPatch does not know the source patch for this artifact.");
                }
                String fileName = OPatchUtils.norm(this.getDeployFileName());
                String domainName = "";
                if (this.domainInfo != null) {
                    domainName = OPatchUtils.norm(this.domainInfo.getName());
                }
                logFile = OPatchUtils.initLogFile(oracleHomePath, patch.getLogTimeStamp(), "Prereq_SOARb_" + fileName + "_" + domainName, true);
                this.setLogFile(logFile);
            }
            catch (Throwable t) {
                stepMsg = "Check if log file is created properly for the operation.";
                String errorMsg2 = t.getMessage();
                failedStep = OPatchUtils.constructFailedStep(OPatchFAStep.CHECK_INIT_LOG_FILE, stepMsg, errorMsg2, new RuntimeException(t));
                this.setFailedPrereqStep(failedStep);
            }
            if (!this.isArtifactBoundtoConfigInstance()) {
                errorMsg = "Please bind the FA config instance object to the artifact using bindToClone() API.";
                stepMsg = "Check if artifact is bound to required end point instances from Cloned Configuration instance.";
                failedStep = OPatchUtils.constructFailedStep(OPatchFAStep.CHECK_FA_BIND_TO_CLONE_ARTIFACT, stepMsg, errorMsg, null);
                this.setFailedPrereqStep(failedStep);
                OLogger.justlog((int)OLogger.INFO, (String)failedStep.toString());
                throw new OPatchException(errorMsg);
            }
            super.doPrereq(operation);
            try {
                client = FMWClientFactory.getClient((OPatchFAAutomationAction)this, (Map)this.constructMap(), (Properties)this.getInterviewProperties());
            }
            catch (Throwable t) {
                String errorMsg3 = "OPatch failed to get the FMW client for artifact execution (Internal OPatch issue)";
                String stepMsg2 = "Check if OPatch can get the client for artifact execution";
                RuntimeException re = new RuntimeException(t.getMessage());
                re.setStackTrace(t.getStackTrace());
                failedStep = OPatchUtils.constructFailedStep(OPatchFAStep.CHECK_FA_CLIENT, stepMsg2, errorMsg3, re);
                this.setFailedPrereqStep(failedStep);
                OLogger.justlog((int)OLogger.INFO, (String)failedStep.toString());
                throw t;
            }
            try {
                if (operation != OPatchFAOperation.PREREQ_DEPLOY) {
                    errorMsg = "OPatch does not support the operation \"" + operation.toString() + "\" for this artifact.";
                    stepMsg = "Check if operation \"" + operation.toString() + "\" is supported.";
                    failedStep = OPatchUtils.constructFailedStep(OPatchFAStep.CHECK_OPERATION_SUPPORTED, stepMsg, errorMsg, null);
                    this.setFailedPrereqStep(failedStep);
                    OLogger.justlog((int)OLogger.INFO, (String)failedStep.toString());
                    OPatchException re = new OPatchException(errorMsg);
                    throw re;
                }
                client.prereq(true);
            }
            catch (Throwable t) {
                OPatchException re = new OPatchException("OPatch fails in prereq on the artifact. " + t.getMessage());
                re.setStackTrace(t.getStackTrace());
                throw re;
            }
            Object var13_18 = null;
            OPatchUtils.updatePrereq(client, this);
            try {
                if (!oracleHomePath.equals("")) {
                    OPatchUtils.unlockHome(oracleHomePath);
                }
            }
            catch (Throwable t2) {
                String errorMsg4 = "OPatch failed to unlock the Oracle Home \"" + oracleHomePath + "\"";
                String stepMsg3 = "Check if OPatch can unlock the Oracle Home.";
                RuntimeException re2 = new RuntimeException(t2.getMessage());
                re2.setStackTrace(t2.getStackTrace());
                failedStep = OPatchUtils.constructFailedStep(OPatchFAStep.CHECK_UNLOCK_HOME, stepMsg3, errorMsg4, re2);
                this.setFailedClosingStep(failedStep);
                OLogger.justlog((int)OLogger.INFO, (String)failedStep.toString());
            }
            OPatchUtils.closeLogFile();
            if (client != null) {
                client.close();
            }
            if (oe != null) {
                throw oe;
            }
            break block30;
            {
                catch (Throwable t) {
                    while (t.getCause() != null) {
                        t = t.getCause();
                    }
                    OPatchException re = new OPatchException(t.getMessage());
                    re.setStackTrace(t.getStackTrace());
                    oe = re;
                    Object var13_19 = null;
                    OPatchUtils.updatePrereq(client, this);
                    try {
                        if (!oracleHomePath.equals("")) {
                            OPatchUtils.unlockHome(oracleHomePath);
                        }
                    }
                    catch (Throwable t2) {
                        String errorMsg4 = "OPatch failed to unlock the Oracle Home \"" + oracleHomePath + "\"";
                        String stepMsg3 = "Check if OPatch can unlock the Oracle Home.";
                        RuntimeException re2 = new RuntimeException(t2.getMessage());
                        re2.setStackTrace(t2.getStackTrace());
                        failedStep = OPatchUtils.constructFailedStep(OPatchFAStep.CHECK_UNLOCK_HOME, stepMsg3, errorMsg4, re2);
                        this.setFailedClosingStep(failedStep);
                        OLogger.justlog((int)OLogger.INFO, (String)failedStep.toString());
                    }
                    OPatchUtils.closeLogFile();
                    if (client != null) {
                        client.close();
                    }
                    if (oe != null) {
                        throw oe;
                    }
                }
            }
            catch (Throwable throwable) {
                Object var13_20 = null;
                OPatchUtils.updatePrereq(client, this);
                try {
                    if (!oracleHomePath.equals("")) {
                        OPatchUtils.unlockHome(oracleHomePath);
                    }
                }
                catch (Throwable t2) {
                    String errorMsg4 = "OPatch failed to unlock the Oracle Home \"" + oracleHomePath + "\"";
                    String stepMsg3 = "Check if OPatch can unlock the Oracle Home.";
                    RuntimeException re2 = new RuntimeException(t2.getMessage());
                    re2.setStackTrace(t2.getStackTrace());
                    failedStep = OPatchUtils.constructFailedStep(OPatchFAStep.CHECK_UNLOCK_HOME, stepMsg3, errorMsg4, re2);
                    this.setFailedClosingStep(failedStep);
                    OLogger.justlog((int)OLogger.INFO, (String)failedStep.toString());
                }
                OPatchUtils.closeLogFile();
                if (client != null) {
                    client.close();
                }
                if (oe != null) {
                    throw oe;
                }
                throw throwable;
            }
        }
    }

    public Object clone() {
        OPatchSOARbDeployAction soaRb = (OPatchSOARbDeployAction)super.clone();
        return soaRb;
    }
}

