/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oip.oipc.oipch;

import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oip.oipc.oipch.OipchGenericRefBuilder;
import oracle.sysman.oip.oipc.oipch.OipchGenericRefHost;
import oracle.sysman.oip.oipc.oipck.OipckKnowledgeSourceException;
import oracle.sysman.oix.oixd.OixdDOMReader;
import oracle.sysman.oix.oixd.OixdInvalidDocumentException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

class OipchGenericRefReader
extends OipchGenericRefBuilder {
    private String m_sFileName;

    OipchGenericRefReader(String sFile) {
        this.m_sFileName = sFile;
    }

    @Override
    public Object build() throws OipckKnowledgeSourceException {
        try {
            Document oDoc = OixdDOMReader.getDocument((String)this.m_sFileName);
            OipchGenericRefHost oGenRefHost = this.build(oDoc, this.m_sFileName);
            return oGenRefHost;
        }
        catch (IOException e) {
            Object[] args = new String[]{this.m_sFileName, e.getMessage()};
            throw new OipckKnowledgeSourceException("OUI-11001", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipch.resources.OipchRuntimeRes", (String)"OUI-11001", (Object[])args), (Throwable)e);
        }
        catch (SAXException e) {
            Object[] args = new String[]{this.m_sFileName, e.getMessage()};
            throw new OipckKnowledgeSourceException("OUI-11002", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipch.resources.OipchRuntimeRes", (String)"OUI-11002", (Object[])args), (Throwable)e);
        }
        catch (OixdInvalidDocumentException e) {
            String[] args = new String[]{this.m_sFileName, e.getMessage()};
            throw new OipckKnowledgeSourceException((Throwable)e);
        }
        catch (ParserConfigurationException e) {
            Object[] args = new String[]{this.m_sFileName, e.getMessage()};
            throw new OipckKnowledgeSourceException("OUI-11003", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipch.resources.OipchRuntimeRes", (String)"OUI-11003", (Object[])args), (Throwable)e);
        }
    }

    private OipchGenericRefHost build(Document oDoc, String sFileName) throws OixdInvalidDocumentException {
        OipchGenericRefHost oGenRefHost = null;
        if (oDoc != null) {
            Element root = oDoc.getDocumentElement();
            if (!root.getTagName().equalsIgnoreCase("HOST")) {
                Object[] args = new String[]{sFileName};
                throw new OixdInvalidDocumentException("OUI-11021", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipch.resources.OipchRuntimeRes", (String)"OUI-11021", (Object[])args));
            }
            oGenRefHost = new OipchGenericRefHost();
            oGenRefHost.setDocument(oDoc);
        }
        return oGenRefHost;
    }
}

