/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oip.oipc.oipch;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringBufferInputStream;
import java.util.EmptyStackException;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;

public class OipchHPKernelReader {
    private final int debugLevel = 0;
    private final int PARSE_ERROR_CODE = -2;
    private final String PARSE_ERROR_CODE_STR = "-2";
    private final String LOGICAL_TRUE_CODE_STR = ".T.";
    private final String LOGICAL_FALSE_CODE_STR = ".F.";
    private Vector vList;

    private OipchHPKernelReader() {
    }

    public OipchHPKernelReader(Vector valueList) {
        this.vList = valueList;
    }

    public OipchHPKernelReader(String[] valueList) {
        this.vList = new Vector();
        for (int i = 0; i < valueList.length; ++i) {
            StringTokenizer tokens = new StringTokenizer(valueList[i]);
            if (tokens.countTokens() < 2) continue;
            this.vList.addElement(tokens.nextToken().trim());
            this.vList.addElement(tokens.nextToken().trim());
        }
    }

    public String[] getValues() {
        String[] allValues = new String[this.vList.size() / 2];
        int i = 0;
        int k = 0;
        while (i < this.vList.size()) {
            String param = (String)this.vList.elementAt(i++);
            String value = (String)this.vList.elementAt(i);
            allValues[k] = param + " " + this.getValue(param);
            ++i;
            ++k;
        }
        return allValues;
    }

    public void storeValue(String param, String value) {
        for (int i = 0; i < this.vList.size(); ++i) {
            String p = ((String)this.vList.elementAt(i)).toLowerCase();
            if (!p.equals(param.toLowerCase())) continue;
            this.vList.remove(i + 1);
            this.vList.insertElementAt(value, i + 1);
            break;
        }
    }

    public String getValue(String param) {
        String rc = null;
        String value = null;
        for (int i = 0; i < this.vList.size(); ++i) {
            String p = ((String)this.vList.elementAt(i)).toLowerCase();
            if (!p.equals(param.toLowerCase())) continue;
            value = (String)this.vList.elementAt(i + 1);
            break;
        }
        if (value == null) {
            throw new RuntimeException("value for param " + param + " is null");
        }
        rc = value;
        if (!this.isInteger(value)) {
            if (!this.isHex(value)) {
                rc = this.parseValue(value);
                this.storeValue(param, rc);
            } else {
                try {
                    long temp = Long.parseLong(value.substring(2), 16);
                    rc = Long.toString(temp);
                }
                catch (NumberFormatException e) {
                    rc = "-2";
                }
            }
        } else {
            rc = value;
        }
        return rc;
    }

    private String parseValue(String expr) {
        try {
            String postFixString = this.convertToPostFix(expr);
            String result = this.calculatePostfix(postFixString);
            return result;
        }
        catch (EmptyStackException e) {
            return "-2";
        }
    }

    private String convertToPostFix(String expr) {
        Stack<String> stack = new Stack<String>();
        StringBuffer postFixString = new StringBuffer();
        boolean endRight = false;
        char[] opArray = new char[1];
        try {
            StreamTokenizer tokens = new StreamTokenizer(new StringBufferInputStream(expr));
            tokens.wordChars(95, 95);
            tokens.ordinaryChar(45);
            tokens.ordinaryChar(43);
            tokens.ordinaryChar(42);
            tokens.ordinaryChar(47);
            tokens.ordinaryChar(40);
            tokens.ordinaryChar(41);
            tokens.ordinaryChar(63);
            tokens.ordinaryChar(58);
            tokens.ordinaryChar(61);
            block9: while (true) {
                int next = tokens.nextToken();
                if (next != -1) {
                    switch (next) {
                        case -2: {
                            postFixString.append(" " + String.valueOf((long)tokens.nval));
                            continue block9;
                        }
                        case -3: {
                            String value = this.getValue(tokens.sval);
                            postFixString.append(" " + value);
                            continue block9;
                        }
                        case 41: {
                            String value = (String)stack.pop();
                            while (true) {
                                if ("(".equals(value)) continue block9;
                                postFixString.append(" " + value);
                                value = (String)stack.pop();
                            }
                        }
                        case 40: {
                            stack.push("(");
                            continue block9;
                        }
                        case 42: 
                        case 43: 
                        case 45: 
                        case 47: 
                        case 58: 
                        case 60: 
                        case 61: 
                        case 62: 
                        case 63: {
                            String value;
                            endRight = false;
                            while (!endRight) {
                                if (stack.empty()) {
                                    endRight = true;
                                    continue;
                                }
                                if ("(".equals((String)stack.peek())) {
                                    endRight = true;
                                    continue;
                                }
                                if (this.getPriority(stack.peek()) < this.getPriority(next)) {
                                    endRight = true;
                                    continue;
                                }
                                value = (String)stack.pop();
                                postFixString.append(" " + value);
                            }
                            opArray[0] = (char)next;
                            int tempNext = tokens.nextToken();
                            if ((char)tempNext == '=' || (char)tempNext == '>' || (char)tempNext == '<') {
                                stack.push("" + (char)next + (char)tempNext);
                                continue block9;
                            }
                            tokens.pushBack();
                            stack.push("" + (char)next);
                            continue block9;
                        }
                    }
                    continue;
                }
                break;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return postFixString.toString();
    }

    private String calculatePostfix(String postFixString) {
        StringTokenizer tokens = new StringTokenizer(postFixString);
        Stack<String> stack = new Stack<String>();
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken();
            if ("+".equals(token) || "-".equals(token) || "*".equals(token) || "/".equals(token)) {
                stack.push(this.doBinaryCalculation(stack, token));
                continue;
            }
            if (">=".equals(token) || "<=".equals(token) || "==".equals(token) || "=>".equals(token) || "=<".equals(token) || ">".equals(token) || "<".equals(token)) {
                stack.push(this.doLogicalComparison(stack, token));
                continue;
            }
            if (":".equals(token)) {
                token = tokens.nextToken();
                stack.push(this.doLogicalCalculation(stack));
                continue;
            }
            stack.push(token);
        }
        String result = (String)stack.pop();
        if (!stack.empty()) {
            return "-2";
        }
        return result;
    }

    private String doBinaryCalculation(Stack stack, String operator) {
        String op1Str = null;
        String op2Str = null;
        long op1 = 0L;
        long op2 = 0L;
        long result = 0L;
        try {
            op2Str = (String)stack.pop();
            op1Str = (String)stack.pop();
            op2 = Long.parseLong(op2Str);
            op1 = Long.parseLong(op1Str);
            result = "+".equals(operator) ? op1 + op2 : ("-".equals(operator) ? op1 - op2 : ("*".equals(operator) ? op1 * op2 : ("/".equals(operator) ? op1 / op2 : -2L)));
            return Long.toString(result);
        }
        catch (NumberFormatException e) {
            System.err.println("doBinaryCalculation : number format error : op1=" + op1 + " op2=" + op2 + " operator=" + operator);
            return "-2";
        }
    }

    private String doLogicalComparison(Stack stack, String operator) {
        String op1Str = null;
        String op2Str = null;
        long op1 = 0L;
        long op2 = 0L;
        try {
            boolean result;
            op2Str = (String)stack.pop();
            op1Str = (String)stack.pop();
            op2 = Long.parseLong(op2Str);
            op1 = Long.parseLong(op1Str);
            if (">".equals(operator)) {
                result = op1 > op2;
            } else if (">=".equals(operator) || "=>".equals(operator)) {
                result = op1 >= op2;
            } else if ("<".equals(operator)) {
                result = op1 < op2;
            } else if ("<=".equals(operator) || "=<".equals(operator)) {
                result = op1 <= op2;
            } else if ("==".equals(operator)) {
                result = op1 == op2;
            } else {
                return "-2";
            }
            if (result) {
                return ".T.";
            }
            return ".F.";
        }
        catch (NumberFormatException e) {
            System.err.println("doLogicalComparison : number format error : op1=" + op1 + " op2=" + op2 + " operator=" + operator);
            return "-2";
        }
    }

    private String doLogicalCalculation(Stack stack) {
        String op1Str = null;
        String op2Str = null;
        String op3Str = null;
        op3Str = (String)stack.pop();
        op2Str = (String)stack.pop();
        op1Str = (String)stack.pop();
        if ("-2".equals(op2Str) || "-2".equals(op3Str)) {
            return "-2";
        }
        if (".T.".equals(op1Str)) {
            return op2Str;
        }
        if (".F.".equals(op1Str)) {
            return op3Str;
        }
        return "-2";
    }

    private boolean isInteger(String value) {
        try {
            Integer.parseInt(value);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private boolean isHex(String value) {
        return value.startsWith("0x") || value.startsWith("0X");
    }

    private int getPriority(Object opString) {
        return this.getPriority(opString.toString().charAt(0));
    }

    private int getPriority(int opInt) {
        char op = (char)opInt;
        if (op == '*' || op == '/') {
            return 5;
        }
        if (op == '+' || op == '-') {
            return 4;
        }
        if (op == '>' || op == '<' || op == '=') {
            return 3;
        }
        if (op == ':') {
            return 2;
        }
        if (op == '?') {
            return 1;
        }
        return 0;
    }

    public static void main(String[] args) {
        Vector<String> vList = new Vector<String>();
        if (args.length != 1) {
            System.out.println("Usage : OipchHPKernelReader <text file containing kmtune output>");
            System.exit(1);
        }
        try {
            String line;
            BufferedReader infile = new BufferedReader(new FileReader(args[0]));
            while ((line = infile.readLine()) != null) {
                StringTokenizer tokens = new StringTokenizer(line);
                if (tokens.countTokens() < 2) continue;
                vList.addElement(tokens.nextToken().trim());
                vList.addElement(tokens.nextToken().trim());
            }
        }
        catch (IOException line) {
            // empty catch block
        }
        OipchHPKernelReader formula = new OipchHPKernelReader(vList);
        String[] finalValues = formula.getValues();
        for (int i = 0; i < finalValues.length; ++i) {
            System.out.println(finalValues[i]);
        }
    }
}

