/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oip.oipc.oipch;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.StringTokenizer;
import oracle.sysman.oii.oiil.OiilNativeException;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiip.osd.unix.OiipuUnixOps;
import oracle.sysman.oii.oiix.OiixFileOps;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oip.oipc.oipch.OipchCPU;
import oracle.sysman.oip.oipc.oipch.OipchDescriptor;
import oracle.sysman.oip.oipc.oipch.OipchMaxproc;
import oracle.sysman.oip.oipc.oipch.OipchShell;
import oracle.sysman.oip.oipc.oipch.OipchStack;
import oracle.sysman.oip.oipc.oipch.OipchSystem;
import oracle.sysman.oip.oipc.oipch.OipchUnixSystemCreator;

public class OipchLinuxSystemCreator
extends OipchUnixSystemCreator {
    public static final String CPUINFO_SCRIPT = "/bin/cat /proc/cpuinfo";
    public static final String FILENAME = "Filename";
    private static final String S_PROCESSOR = "processor";
    private static final String S_VENDOR_ID = "vendor_id";
    private static final String S_CPU_MHZ = "cpu MHz";
    private static final String S_CPUFILE_SEPERATOR = ":";
    public String SWAP_SCRIPT = "/bin/cat /proc/swaps";
    private static final String SHELL_LOCATION_KSH = "/bin/ksh";
    private static final String HARDLIMIT_STACK_KSH = "/bin/ksh -c \"ulimit -Hs\" ";
    private static final String SOFTLIMIT_STACK_KSH = "/bin/ksh -c \"ulimit -Ss\" ";
    private static final String HARDLIMIT_MAXPROC_KSH = "/bin/ksh -c \"ulimit -Hp\" ";
    private static final String SOFTLIMIT_MAXPROC_KSH = "/bin/ksh -c \"ulimit -Sp\" ";
    private static final String HARDLIMIT_DESCRIPTOR_KSH = "/bin/ksh -c \"ulimit -Hn\" ";
    private static final String SOFTLIMIT_DESCRIPTOR_KSH = "/bin/ksh -c \"ulimit -Sn\" ";
    private static final String SHELL_LOCATION_ASH = "/bin/ash";
    private static final String HARDLIMIT_STACK_ASH = "/bin/ash -c \"ulimit -Hs\" ";
    private static final String SOFTLIMIT_STACK_ASH = "/bin/ash -c \"ulimit -Ss\" ";
    private static final String HARDLIMIT_MAXPROC_ASH = "/bin/ash -c \"ulimit -Hp\" ";
    private static final String SOFTLIMIT_MAXPROC_ASH = "/bin/ash -c \"ulimit -Sp\" ";
    private static final String HARDLIMIT_DESCRIPTOR_ASH = "/bin/ash -c \"ulimit -Hn\" ";
    private static final String SOFTLIMIT_DESCRIPTOR_ASH = "/bin/ash -c \"ulimit -Sn\" ";
    private static final String SHELL_LOCATION_BASH = "/bin/bash";
    private static final String HARDLIMIT_STACK_BASH = "/bin/bash -c \"ulimit -Hs\" ";
    private static final String SOFTLIMIT_STACK_BASH = "/bin/ksh -c \"ulimit -Ss\" ";
    private static final String HARDLIMIT_MAXPROC_BASH = "/bin/bash -c \"ulimit -Hu\" ";
    private static final String SOFTLIMIT_MAXPROC_BASH = "/bin/bash -c \"ulimit -Su\" ";
    private static final String HARDLIMIT_DESCRIPTOR_BASH = "/bin/bash -c \"ulimit -Hn\" ";
    private static final String SOFTLIMIT_DESCRIPTOR_BASH = "/bin/bash -c \"ulimit -Sn\" ";
    private static final String SHELL_LOCATION_BSH = "/bin/bsh";
    private static final String HARDLIMIT_STACK_BSH = "/bin/bsh -c \"ulimit -Hs\" ";
    private static final String SOFTLIMIT_STACK_BSH = "/bin/ksh -c \"ulimit -Ss\" ";
    private static final String HARDLIMIT_MAXPROC_BSH = "/bin/bsh -c \"ulimit -Hp\" ";
    private static final String SOFTLIMIT_MAXPROC_BSH = "/bin/bsh -c \"ulimit -Sp\" ";
    private static final String HARDLIMIT_DESCRIPTOR_BSH = "/bin/bsh -c \"ulimit -Hn\" ";
    private static final String SOFTLIMIT_DESCRIPTOR_BSH = "/bin/bsh -c \"ulimit -Sn\" ";
    private static final String SHELL_LOCATION_CSH = "/bin/csh";
    private static final String HARDLIMIT_STACK_CSH = "/bin/csh -f -c \"limit -h stacksize\" ";
    private static final String SOFTLIMIT_STACK_CSH = "/bin/csh -f -c \"limit stacksize\" ";
    private static final String HARDLIMIT_MAXPROC_CSH = "/bin/csh -f -c \"limit -h maxproc\" ";
    private static final String SOFTLIMIT_MAXPROC_CSH = "/bin/csh -f -c \"limit maxproc\" ";
    private static final String HARDLIMIT_DESCRIPTOR_CSH = "/bin/csh -f -c \"limit -h descriptor\" ";
    private static final String SOFTLIMIT_DESCRIPTOR_CSH = "/bin/csh -f -c \"limit descriptor\" ";
    private static final String SHELL_LOCATION_SH = "/bin/sh";
    private static final String HARDLIMIT_STACK_SH = "/bin/sh -c \"ulimit -Hs\" ";
    private static final String SOFTLIMIT_STACK_SH = "/bin/ksh -c \"ulimit -Ss\" ";
    private static final String HARDLIMIT_MAXPROC_SH = "/bin/sh -c \"ulimit -Hu\" ";
    private static final String SOFTLIMIT_MAXPROC_SH = "/bin/sh -c \"ulimit -Su\" ";
    private static final String HARDLIMIT_DESCRIPTOR_SH = "/bin/sh -c \"ulimit -Hn\" ";
    private static final String SOFTLIMIT_DESCRIPTOR_SH = "/bin/sh -c \"ulimit -Sn\" ";
    private static final String SHELL_LOCATION_TCSH = "/bin/tcsh";
    private static final String HARDLIMIT_STACK_TCSH = "/bin/tcsh -f -c \"limit -h stacksize\" ";
    private static final String SOFTLIMIT_STACK_TCSH = "/bin/tcsh -f -c \"limit stacksize\" ";
    private static final String HARDLIMIT_MAXPROC_TCSH = "/bin/tcsh -f -c \"limit -h maxproc\" ";
    private static final String SOFTLIMIT_MAXPROC_TCSH = "/bin/tcsh -f -c \"limit maxproc\" ";
    private static final String HARDLIMIT_DESCRIPTOR_TCSH = "/bin/tcsh -f -c \"limit -h descriptor\" ";
    private static final String SOFTLIMIT_DESCRIPTOR_TCSH = "/bin/tcsh -f -c \"limit descriptor\" ";
    private static final String SHELL_LOCATION_ZSH = "/bin/zsh";
    private static final String HARDLIMIT_STACK_ZSH = "/bin/zsh -c \"ulimit -Hs\" ";
    private static final String SOFTLIMIT_STACK_ZSH = "/bin/zsh -c \"ulimit -Ss\" ";
    private static final String HARDLIMIT_MAXPROC_ZSH = "/bin/zsh -c \"ulimit -Hu\" ";
    private static final String SOFTLIMIT_MAXPROC_ZSH = "/bin/zsh -c \"ulimit -Su\" ";
    private static final String HARDLIMIT_DESCRIPTOR_ZSH = "/bin/zsh -c \"ulimit -Hn\" ";
    private static final String SOFTLIMIT_DESCRIPTOR_ZSH = "/bin/zsh -c \"ulimit -Sn\" ";

    @Override
    String getSwapScript() {
        return this.SWAP_SCRIPT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    long getSwapSpaceFromFile(String sFile) throws IOException {
        long lSwapSpace = 0L;
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(sFile));
            long lAvail = 0L;
            long lUsed = 0L;
            String sLine = null;
            while ((sLine = reader.readLine()) != null) {
                if (sLine.startsWith(FILENAME)) continue;
                StringTokenizer st = new StringTokenizer(sLine);
                String token = st.nextToken();
                token = st.nextToken();
                lAvail = Long.parseLong(st.nextToken());
                lUsed = Long.parseLong(st.nextToken());
                lSwapSpace += lAvail - lUsed;
            }
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return lSwapSpace /= 1024L;
    }

    OipchLinuxSystemCreator(int iPlatID) {
        super(iPlatID);
    }

    @Override
    void updateCPUInfo(OipchSystem oSystem) {
        String sFile = OiixPathOps.concatPath((String)this.getScratchPath(), (String)"cpuinfo.txt");
        String sParent = OiixPathOps.getParentDir((String)sFile);
        if (sParent != null) {
            OiixFileOps.mkdirs((File)new File(sParent));
        }
        String sCommand = "/bin/cat /proc/cpuinfo>" + sFile;
        int result = 0;
        try {
            result = OiipuUnixOps.sysFunctionEnglish((String)sCommand);
        }
        catch (OiilNativeException e) {
            e.printStackTrace();
        }
        if (result != 0) {
            return;
        }
        this.addCPUInfoFromFile(sFile, oSystem);
        try {
            File tmpFile = new File(sFile);
            if (tmpFile.exists()) {
                tmpFile.delete();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void addCPUInfoFromFile(String sFile, OipchSystem oSystem) {
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(sFile));
            String sLine = null;
            sLine = reader.readLine();
            block5: while (sLine != null) {
                String[] asLine = sLine.split(S_CPUFILE_SEPERATOR, 2);
                if (asLine[0].trim().equals(S_PROCESSOR)) {
                    OipchCPU oCPU = new OipchCPU();
                    sLine = reader.readLine();
                    while (sLine != null) {
                        asLine = sLine.split(S_CPUFILE_SEPERATOR, 2);
                        if (asLine[0].trim().equals(S_VENDOR_ID)) {
                            oCPU.setVendor(asLine[1]);
                        }
                        if (asLine[0].trim().equals(S_CPU_MHZ) && asLine[1] != null) {
                            try {
                                Double oSpeed = new Double(asLine[1].trim());
                                oCPU.setSpeedInMhz(oSpeed.longValue());
                                oSystem.addCPU(oCPU);
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                        if (asLine[0].trim().equals(S_PROCESSOR)) continue block5;
                        sLine = reader.readLine();
                    }
                    continue;
                }
                sLine = reader.readLine();
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    void updateShellDetails(OipchSystem oSystem) {
        String hardLimitStack = null;
        String softLimitStack = null;
        String hardLimitmaxproc = null;
        String softLimitmaxproc = null;
        String hardLimitdescriptor = null;
        String softLimitdescriptor = null;
        if (new File(SHELL_LOCATION_KSH).exists()) {
            try {
                hardLimitStack = this.invokeCommand(HARDLIMIT_STACK_KSH);
                softLimitStack = this.invokeCommand("/bin/ksh -c \"ulimit -Ss\" ");
                hardLimitmaxproc = this.invokeCommand(HARDLIMIT_MAXPROC_KSH);
                softLimitmaxproc = this.invokeCommand(SOFTLIMIT_MAXPROC_KSH);
                hardLimitdescriptor = this.invokeCommand(HARDLIMIT_DESCRIPTOR_KSH);
                softLimitdescriptor = this.invokeCommand(SOFTLIMIT_DESCRIPTOR_KSH);
                this.updateShellinfo(hardLimitStack, softLimitStack, hardLimitmaxproc, softLimitmaxproc, hardLimitdescriptor, softLimitdescriptor, "ksh", oSystem);
            }
            catch (Exception e) {
                OiiolTextLogger.appendText((String)("Exception occurred while executing script on KSH shell,exception is " + e.getMessage()));
            }
        }
        if (new File(SHELL_LOCATION_ASH).exists()) {
            try {
                hardLimitStack = this.invokeCommand(HARDLIMIT_STACK_ASH);
                softLimitStack = this.invokeCommand(SOFTLIMIT_STACK_ASH);
                hardLimitmaxproc = this.invokeCommand(HARDLIMIT_MAXPROC_ASH);
                softLimitmaxproc = this.invokeCommand(SOFTLIMIT_MAXPROC_ASH);
                hardLimitdescriptor = this.invokeCommand(HARDLIMIT_DESCRIPTOR_ASH);
                softLimitdescriptor = this.invokeCommand(SOFTLIMIT_DESCRIPTOR_ASH);
                this.updateShellinfo(hardLimitStack, softLimitStack, hardLimitmaxproc, softLimitmaxproc, hardLimitdescriptor, softLimitdescriptor, "ash", oSystem);
            }
            catch (Exception e) {
                OiiolTextLogger.appendText((String)("Exception occurred while executing script on ASH shell,exception is " + e.getMessage()));
            }
        }
        if (new File(SHELL_LOCATION_SH).exists()) {
            try {
                hardLimitStack = this.invokeCommand(HARDLIMIT_STACK_SH);
                softLimitStack = this.invokeCommand("/bin/ksh -c \"ulimit -Ss\" ");
                hardLimitmaxproc = this.invokeCommand(HARDLIMIT_MAXPROC_SH);
                softLimitmaxproc = this.invokeCommand(SOFTLIMIT_MAXPROC_SH);
                hardLimitdescriptor = this.invokeCommand(HARDLIMIT_DESCRIPTOR_SH);
                softLimitdescriptor = this.invokeCommand(SOFTLIMIT_DESCRIPTOR_SH);
                this.updateShellinfo(hardLimitStack, softLimitStack, hardLimitmaxproc, softLimitmaxproc, hardLimitdescriptor, softLimitdescriptor, "sh", oSystem);
            }
            catch (Exception e) {
                OiiolTextLogger.appendText((String)("Exception occurred while executing script on SH shell,exception is " + e.getMessage()));
            }
        }
        if (new File(SHELL_LOCATION_BASH).exists()) {
            try {
                hardLimitStack = this.invokeCommand(HARDLIMIT_STACK_BASH);
                softLimitStack = this.invokeCommand("/bin/ksh -c \"ulimit -Ss\" ");
                hardLimitmaxproc = this.invokeCommand(HARDLIMIT_MAXPROC_BASH);
                softLimitmaxproc = this.invokeCommand(SOFTLIMIT_MAXPROC_BASH);
                hardLimitdescriptor = this.invokeCommand(HARDLIMIT_DESCRIPTOR_BASH);
                softLimitdescriptor = this.invokeCommand(SOFTLIMIT_DESCRIPTOR_BASH);
                this.updateShellinfo(hardLimitStack, softLimitStack, hardLimitmaxproc, softLimitmaxproc, hardLimitdescriptor, softLimitdescriptor, "bash", oSystem);
            }
            catch (Exception e) {
                OiiolTextLogger.appendText((String)("Exception occurred while executing script on BASH shell,exception is " + e.getMessage()));
            }
        }
        if (new File(SHELL_LOCATION_BSH).exists()) {
            try {
                hardLimitStack = this.invokeCommand(HARDLIMIT_STACK_BSH);
                softLimitStack = this.invokeCommand("/bin/ksh -c \"ulimit -Ss\" ");
                hardLimitmaxproc = this.invokeCommand(HARDLIMIT_MAXPROC_BSH);
                softLimitmaxproc = this.invokeCommand(SOFTLIMIT_MAXPROC_BSH);
                hardLimitdescriptor = this.invokeCommand(HARDLIMIT_DESCRIPTOR_BSH);
                softLimitdescriptor = this.invokeCommand(SOFTLIMIT_DESCRIPTOR_BSH);
                this.updateShellinfo(hardLimitStack, softLimitStack, hardLimitmaxproc, softLimitmaxproc, hardLimitdescriptor, softLimitdescriptor, "bsh", oSystem);
            }
            catch (Exception e) {
                OiiolTextLogger.appendText((String)("Exception occurred while executing script on BSH shell,exception is " + e.getMessage()));
            }
        }
        if (new File(SHELL_LOCATION_CSH).exists()) {
            try {
                hardLimitStack = this.invokeCommand(HARDLIMIT_STACK_CSH);
                softLimitStack = this.invokeCommand(SOFTLIMIT_STACK_CSH);
                hardLimitmaxproc = this.invokeCommand(HARDLIMIT_MAXPROC_CSH);
                softLimitmaxproc = this.invokeCommand(SOFTLIMIT_MAXPROC_CSH);
                hardLimitdescriptor = this.invokeCommand(HARDLIMIT_DESCRIPTOR_CSH);
                softLimitdescriptor = this.invokeCommand(SOFTLIMIT_DESCRIPTOR_CSH);
                if (hardLimitStack != null && hardLimitStack.length() > 9) {
                    hardLimitStack = hardLimitStack.substring(9, hardLimitStack.length()).trim();
                }
                if (softLimitStack != null && softLimitStack.length() > 9) {
                    softLimitStack = softLimitStack.substring(9, softLimitStack.length()).trim();
                }
                if (hardLimitmaxproc != null && hardLimitmaxproc.length() > 8) {
                    hardLimitmaxproc = hardLimitmaxproc.substring(8, hardLimitmaxproc.length()).trim();
                }
                if (softLimitmaxproc != null && softLimitmaxproc.length() > 8) {
                    softLimitmaxproc = softLimitmaxproc.substring(8, softLimitmaxproc.length()).trim();
                }
                if (hardLimitdescriptor != null && hardLimitdescriptor.length() > 12) {
                    hardLimitdescriptor = hardLimitdescriptor.substring(12, hardLimitdescriptor.length()).trim();
                }
                if (softLimitdescriptor != null && softLimitdescriptor.length() > 12) {
                    softLimitdescriptor = softLimitdescriptor.substring(12, softLimitdescriptor.length()).trim();
                }
                this.updateShellinfo(hardLimitStack, softLimitStack, hardLimitmaxproc, softLimitmaxproc, hardLimitdescriptor, softLimitdescriptor, "csh", oSystem);
            }
            catch (Exception e) {
                OiiolTextLogger.appendText((String)("Exception occurred while executing script on CSH shell,exception is " + e.getMessage()));
            }
        }
        if (new File(SHELL_LOCATION_TCSH).exists()) {
            try {
                hardLimitStack = this.invokeCommand(HARDLIMIT_STACK_TCSH);
                softLimitStack = this.invokeCommand(SOFTLIMIT_STACK_TCSH);
                hardLimitmaxproc = this.invokeCommand(HARDLIMIT_MAXPROC_TCSH);
                softLimitmaxproc = this.invokeCommand(SOFTLIMIT_MAXPROC_TCSH);
                hardLimitdescriptor = this.invokeCommand(HARDLIMIT_DESCRIPTOR_TCSH);
                softLimitdescriptor = this.invokeCommand(SOFTLIMIT_DESCRIPTOR_TCSH);
                if (hardLimitStack != null && hardLimitStack.length() > 9) {
                    hardLimitStack = hardLimitStack.substring(9, hardLimitStack.length()).trim();
                }
                if (softLimitStack != null && softLimitStack.length() > 9) {
                    softLimitStack = softLimitStack.substring(9, softLimitStack.length()).trim();
                }
                if (hardLimitmaxproc != null && hardLimitmaxproc.length() > 8) {
                    hardLimitmaxproc = hardLimitmaxproc.substring(8, hardLimitmaxproc.length()).trim();
                }
                if (softLimitmaxproc != null && softLimitmaxproc.length() > 8) {
                    softLimitmaxproc = softLimitmaxproc.substring(8, softLimitmaxproc.length()).trim();
                }
                if (hardLimitdescriptor != null && hardLimitdescriptor.length() > 12) {
                    hardLimitdescriptor = hardLimitdescriptor.substring(12, hardLimitdescriptor.length()).trim();
                }
                if (softLimitdescriptor != null && softLimitdescriptor.length() > 12) {
                    softLimitdescriptor = softLimitdescriptor.substring(12, softLimitdescriptor.length()).trim();
                }
                this.updateShellinfo(hardLimitStack, softLimitStack, hardLimitmaxproc, softLimitmaxproc, hardLimitdescriptor, softLimitdescriptor, "tcsh", oSystem);
            }
            catch (Exception e) {
                OiiolTextLogger.appendText((String)("Exception occurred while executing script on TCSH shell,exception is " + e.getMessage()));
            }
        }
        if (new File(SHELL_LOCATION_ZSH).exists()) {
            try {
                softLimitStack = this.invokeCommand(SOFTLIMIT_STACK_ZSH);
                hardLimitStack = this.invokeCommand(HARDLIMIT_STACK_ZSH);
                hardLimitmaxproc = this.invokeCommand(HARDLIMIT_MAXPROC_ZSH);
                softLimitmaxproc = this.invokeCommand(SOFTLIMIT_MAXPROC_ZSH);
                hardLimitdescriptor = this.invokeCommand(HARDLIMIT_DESCRIPTOR_ZSH);
                softLimitdescriptor = this.invokeCommand(SOFTLIMIT_DESCRIPTOR_ZSH);
                this.updateShellinfo(hardLimitStack, softLimitStack, hardLimitmaxproc, softLimitmaxproc, hardLimitdescriptor, softLimitdescriptor, "zsh", oSystem);
            }
            catch (Exception e) {
                OiiolTextLogger.appendText((String)("Exception occurred while executing script on ZSH shell,exception is " + e.getMessage()));
            }
        }
    }

    private void updateShellinfo(String hardLimitStack, String softLimitStack, String hardLimitmaxproc, String softLimitmaxproc, String hardLimitdescriptor, String softLimitdescriptor, String shellName, OipchSystem oSystem) {
        OipchShell oShell = new OipchShell(shellName);
        OipchStack oStack = new OipchStack();
        OipchMaxproc oMaxproc = new OipchMaxproc();
        OipchDescriptor oDescriptor = new OipchDescriptor();
        String defaultUnit = "KB";
        String kiloByte = "kbytes";
        String megaByte = "MB";
        String softlimitUnit = defaultUnit;
        String defaultOperator = "ATLEAST";
        if (softLimitStack.endsWith(defaultUnit)) {
            softLimitStack = softLimitStack.replaceAll(defaultUnit, "");
            softlimitUnit = defaultUnit;
        }
        if (softLimitStack.endsWith(megaByte)) {
            softLimitStack = softLimitStack.replaceAll(megaByte, "");
            softlimitUnit = megaByte;
        }
        if (softLimitStack.endsWith(kiloByte)) {
            softLimitStack = softLimitStack.replaceAll(kiloByte, "");
            softlimitUnit = kiloByte;
        }
        if (softLimitdescriptor != null) {
            oDescriptor.setSoftDescriptor(softLimitdescriptor.trim());
        }
        if (hardLimitdescriptor != null) {
            oDescriptor.setHardDescriptor(hardLimitdescriptor.trim());
        }
        if (softLimitmaxproc != null) {
            oMaxproc.setSoftMaxProc(softLimitmaxproc.trim());
        }
        if (hardLimitmaxproc != null) {
            oMaxproc.setHardMaxProc(hardLimitmaxproc.trim());
        }
        if (softLimitStack != null) {
            oStack.setSoftStack(softLimitStack.trim());
        }
        if (hardLimitStack != null) {
            oStack.setHardStack(hardLimitStack.trim());
        }
        oStack.setSoftUnitStack(softlimitUnit);
        oStack.setSoftOperatorStack(defaultOperator);
        oStack.setHardUnitStack(softlimitUnit);
        oStack.setHardOperatorStack(defaultOperator);
        oShell.setStack(oStack);
        oShell.setDescriptor(oDescriptor);
        oShell.setMaxproc(oMaxproc);
        oSystem.addShell(shellName, oShell);
    }
}

