/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oip.oipc.oipch;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;
import oracle.sysman.oii.oiix.OiixPlatform;
import oracle.sysman.oip.oipc.oipch.OipchAIXSystemWriter;
import oracle.sysman.oip.oipc.oipch.OipchCPU;
import oracle.sysman.oip.oipc.oipch.OipchClusterDetails;
import oracle.sysman.oip.oipc.oipch.OipchDECSystemWriter;
import oracle.sysman.oip.oipc.oipch.OipchHPSystemWriter;
import oracle.sysman.oip.oipc.oipch.OipchLinuxSystemWriter;
import oracle.sysman.oip.oipc.oipch.OipchMemory;
import oracle.sysman.oip.oipc.oipch.OipchNIC;
import oracle.sysman.oip.oipc.oipch.OipchNetworkDetails;
import oracle.sysman.oip.oipc.oipch.OipchSolarisSystemWriter;
import oracle.sysman.oip.oipc.oipch.OipchSystem;
import oracle.sysman.oip.oipc.oipch.OipchWindowsSystemWriter;
import oracle.xml.parser.v2.XMLElement;
import org.w3c.dom.Node;

public abstract class OipchSystemWriter {
    static OipchSystemWriter getWriter() {
        OipchSystemWriter oSystemWriter = null;
        switch (OiixPlatform.getCurrentPlatform()) {
            case 453: {
                oSystemWriter = new OipchSolarisSystemWriter();
                break;
            }
            case 46: 
            case 110: 
            case 211: 
            case 525: {
                oSystemWriter = new OipchLinuxSystemWriter();
                break;
            }
            case 208: 
            case 233: 
            case 912: {
                oSystemWriter = new OipchWindowsSystemWriter();
                break;
            }
            case 2: 
            case 197: {
                oSystemWriter = new OipchHPSystemWriter();
                break;
            }
            case 610: {
                oSystemWriter = new OipchAIXSystemWriter();
                break;
            }
            case 87: {
                oSystemWriter = new OipchDECSystemWriter();
            }
        }
        return oSystemWriter;
    }

    int save(OipchSystem oSys, PrintWriter pWriter) throws IOException {
        XMLElement xmlSystem = new XMLElement("SYSTEM");
        xmlSystem.appendChild((Node)this.getMemoryDetails(oSys));
        xmlSystem.appendChild((Node)this.getCPUDetails(oSys));
        xmlSystem.appendChild((Node)this.getUserGrpDetails(oSys));
        xmlSystem.appendChild((Node)this.getNetworkDetails(oSys));
        xmlSystem.appendChild((Node)this.getClusterDetails(oSys));
        xmlSystem.appendChild((Node)this.getPartitionsDetails(oSys));
        xmlSystem.appendChild((Node)this.getDevicesDetails(oSys));
        XMLElement runlevelDetails = this.getRunlevelDetails(oSys);
        if (runlevelDetails != null) {
            xmlSystem.appendChild((Node)this.getRunlevelDetails(oSys));
        }
        xmlSystem.print(pWriter);
        return 0;
    }

    abstract XMLElement getPartitionsDetails(OipchSystem var1);

    abstract XMLElement getDevicesDetails(OipchSystem var1);

    private XMLElement getRunlevelDetails(OipchSystem oSys) {
        boolean bInitialized = oSys.areRunlevelsInitialized();
        if (bInitialized) {
            String currentRunlevel = oSys.getCurrentRunlevel();
            String defaultRunlevel = oSys.getDefaultRunlevel();
            XMLElement xmlRunlevel = new XMLElement("RUNLEVEL");
            xmlRunlevel.setAttribute("DEFAULT", defaultRunlevel);
            xmlRunlevel.setAttribute("CURRENT", currentRunlevel);
            return xmlRunlevel;
        }
        return null;
    }

    private XMLElement getClusterDetails(OipchSystem oSys) {
        XMLElement xmlCluster = new XMLElement("CLUSTER");
        OipchClusterDetails oClusterDetails = oSys.getClusterDetails();
        if (oClusterDetails != null) {
            xmlCluster.setAttribute("CRS", new Boolean(oClusterDetails.hasCRS()).toString());
            xmlCluster.setAttribute("VENDOR", new Boolean(oClusterDetails.hasVendorClusterware()).toString());
            String[] oNodes = oClusterDetails.getNodes();
            if (oNodes != null && oNodes.length > 0) {
                for (int i = 0; i < oNodes.length; ++i) {
                    xmlCluster.appendChild((Node)this.getClusterNode(oNodes[i]));
                }
            }
        }
        return xmlCluster;
    }

    private XMLElement getClusterNode(String sNode) {
        XMLElement xmlNode = new XMLElement("NODE");
        xmlNode.setAttribute("NAME", sNode);
        return xmlNode;
    }

    private XMLElement getNetworkDetails(OipchSystem oSys) {
        XMLElement xmlNet = new XMLElement("NETWORK");
        OipchNetworkDetails oNetDetails = oSys.getNetworkDetails();
        if (oNetDetails != null) {
            xmlNet.setAttribute("HOSTNAME", oNetDetails.getHostName());
            xmlNet.setAttribute("IP", oNetDetails.getHostAddress());
            Iterator oNICs = oNetDetails.getHostNICs().iterator();
            if (oNICs != null) {
                while (oNICs.hasNext()) {
                    xmlNet.appendChild((Node)this.getNIC(oNICs.next()));
                }
            }
        }
        return xmlNet;
    }

    private XMLElement getNIC(Object ob) {
        XMLElement xmlNIC = null;
        if (ob instanceof OipchNIC) {
            OipchNIC oNIC = (OipchNIC)ob;
            xmlNIC = new XMLElement("NIC");
            xmlNIC.setAttribute("NAME", oNIC.getName());
            xmlNIC.setAttribute("SUBNET", oNIC.getSubnet());
            String mask = oNIC.getMask();
            if (mask != null && !mask.equals("")) {
                xmlNIC.setAttribute("SUBNET_MASK", mask);
            }
            xmlNIC.setAttribute("TYPE", oNIC.getType());
        }
        return xmlNIC;
    }

    abstract XMLElement getUserGrpDetails(OipchSystem var1);

    private XMLElement getMemoryDetails(OipchSystem oSys) {
        Long oLong;
        XMLElement xmlMem = new XMLElement("MEMORY");
        OipchMemory oMem = oSys.getAvailableMemory();
        if (oMem != null) {
            XMLElement xmlAvailMem = new XMLElement("AVAILABLE_MEMORY");
            oLong = new Long(oMem.getSize());
            xmlAvailMem.setAttribute("VALUE", oLong.toString());
            xmlAvailMem.setAttribute("UNIT", this.getStrUnit(oMem.getUnit()));
            xmlMem.appendChild((Node)xmlAvailMem);
        }
        if ((oMem = oSys.getPhysicalMemory()) != null) {
            XMLElement xmlPhysMem = new XMLElement("PHYSICAL_MEMORY");
            oLong = new Long(oMem.getSize());
            xmlPhysMem.setAttribute("VALUE", oLong.toString());
            xmlPhysMem.setAttribute("UNIT", this.getStrUnit(oMem.getUnit()));
            xmlMem.appendChild((Node)xmlPhysMem);
        }
        if ((oMem = oSys.getSwapSpace()) != null) {
            XMLElement xmlSwapMem = new XMLElement("SWAP_SIZE");
            oLong = new Long(oMem.getSize());
            xmlSwapMem.setAttribute("VALUE", oLong.toString());
            xmlSwapMem.setAttribute("UNIT", this.getStrUnit(oMem.getUnit()));
            xmlMem.appendChild((Node)xmlSwapMem);
        }
        return xmlMem;
    }

    private XMLElement getCPUDetails(OipchSystem oSys) {
        XMLElement xmlCPUs = new XMLElement("CPU");
        Iterator oCPUs = oSys.getCPUs();
        if (oCPUs != null) {
            while (oCPUs.hasNext()) {
                OipchCPU oCPU;
                Object oCpuOb = oCPUs.next();
                if (!(oCpuOb instanceof OipchCPU) || (oCPU = (OipchCPU)oCpuOb) == null) continue;
                XMLElement xmlCPU = new XMLElement("VENDOR");
                xmlCPU.setAttribute("VALUE", oCPU.getVendor());
                Long oLong = new Long(oCPU.getSpeed());
                xmlCPU.setAttribute("SPEED", oLong.toString());
                xmlCPU.setAttribute("UNIT", oCPU.getSpeedUnit());
                xmlCPUs.appendChild((Node)xmlCPU);
            }
        }
        return xmlCPUs;
    }

    private String getStrUnit(int iUnit) {
        String sUnit = "MB";
        if (iUnit == 1) {
            sUnit = "GB";
        }
        return sUnit;
    }
}

