/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.ivw.client.action;

import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.install.commons.flow.Action;
import oracle.install.commons.flow.ConditionContext;
import oracle.install.commons.flow.ConditionResult;
import oracle.install.commons.flow.ConditionRoutine;
import oracle.install.commons.flow.FlowContext;
import oracle.install.commons.flow.FlowControl;
import oracle.install.commons.flow.Route;
import oracle.install.commons.flow.annotation.UIRef;
import oracle.install.ivw.client.bean.ClientInstallSettings;

@UIRef(value="InstallModeUI")
public class InstallModeAction
implements Action,
ConditionRoutine {
    private Logger logger = Logger.getLogger(InstallModeAction.class.getName());

    public void execute(FlowContext flowContext) {
    }

    public Route transition(FlowContext flowContext) {
        ClientInstallSettings bean = (ClientInstallSettings)((Object)flowContext.getBean(ClientInstallSettings.class));
        this.logger.log(Level.INFO, "In Transition of InstallModeAction:");
        if (bean.isUpgrading()) {
            FlowControl flowControl = flowContext.getFlowControl();
            if (flowControl != null) {
                flowControl.lookAhead(new Route("UPGRADE_YES"));
            }
            return new Route("UPGRADE_YES");
        }
        return new Route("UPGRADE_NO");
    }

    public ConditionResult check(ConditionContext context) {
        ConditionResult result = ConditionResult.MISMATCHED;
        ClientInstallSettings bean = (ClientInstallSettings)((Object)context.getFlowContext().getBean(ClientInstallSettings.class));
        String[] upgradableHomes = bean.getUpgradableHomes();
        if (upgradableHomes != null && upgradableHomes.length > 0) {
            result = ConditionResult.MATCHED;
        }
        return result;
    }
}

