/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.ivw.client.validator;

import java.io.File;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.cluster.winsecurity.Credentials;
import oracle.install.commons.flow.FlowContext;
import oracle.install.commons.flow.validation.ValidationException;
import oracle.install.commons.flow.validation.ValidationStatusMessage;
import oracle.install.commons.util.StatusMessage;
import oracle.install.commons.util.StatusMessages;
import oracle.install.commons.util.exception.ErrorCode;
import oracle.install.ivw.client.bean.ClientInstallSettings;
import oracle.install.ivw.client.resource.ClientErrorCode;
import oracle.install.ivw.common.bean.InstallSettings;
import oracle.install.ivw.common.bean.WindowsSecureOptionSettings;
import oracle.install.ivw.common.resource.CommonErrorCode;
import oracle.install.ivw.common.validator.BaseInstallLocationValidator;
import oracle.install.library.processes.RunningProcessInfoUnix;
import oracle.install.library.util.FileParser;
import oracle.install.library.util.FunctionsUtil;
import oracle.install.library.util.GenericValidation;
import oracle.install.library.util.InstallException;
import oracle.install.library.util.InventoryInfo;
import oracle.install.library.util.NTServiceInfo;
import oracle.install.library.util.PlatformInfo;
import oracle.install.library.util.StageSizeInfo;
import oracle.install.library.util.WinHelper;

public class InstallLocationValidator
extends BaseInstallLocationValidator {
    public static Logger logger = Logger.getLogger(InstallLocationValidator.class.getName());

    public void validate(FlowContext flowContext) throws ValidationException {
        ClientInstallSettings installSettings = (ClientInstallSettings)((Object)flowContext.getBean(ClientInstallSettings.class));
        String iType = installSettings.getInstallType().name();
        boolean validateOracleBase = true;
        if (installSettings.isUpgrading()) {
            iType = ClientInstallSettings.InstallType.Custom.name();
            validateOracleBase = false;
        }
        if (PlatformInfo.getInstance().isWindows()) {
            super.setSkipWhiteSpacesCheck(true);
        }
        super.validate(flowContext, iType, validateOracleBase);
        StatusMessages errorMessages = super.getValidationStatusMessages();
        String oracleHome = installSettings.getOracleHome();
        String oracleBase = installSettings.getOracleBase();
        if (oracleHome == null || oracleHome.length() == 0) {
            return;
        }
        try {
            long spaceRequired = 0L;
            boolean considerOracleHomeOffset = false;
            spaceRequired = installSettings.getInstallType() == ClientInstallSettings.InstallType.Custom ? StageSizeInfo.getSize((String)ClientInstallSettings.InstallType.Administrator.toString(), (boolean)considerOracleHomeOffset) : StageSizeInfo.getSize((String)installSettings.getInstallType().toString(), (boolean)considerOracleHomeOffset);
            if (GenericValidation.validateForFreeSpace((long)spaceRequired, (String)installSettings.getOracleHome()) < 0L) {
                errorMessages.add((StatusMessage)new ValidationStatusMessage((ErrorCode)CommonErrorCode.INSTALL_COMMON_MIN_FREE_DISK_SPACE_ERR, new Object[]{installSettings.getOracleHome(), FunctionsUtil.getReadableSize((long)spaceRequired, (FunctionsUtil.Unit)FunctionsUtil.Unit.MB)}));
            }
            if (PlatformInfo.getInstance().isWindows()) {
                boolean b_clientOnTopOfDB = false;
                WindowsSecureOptionSettings secureBean = (WindowsSecureOptionSettings)flowContext.getBean(WindowsSecureOptionSettings.class);
                String userName = null;
                if (InventoryInfo.getInstance().isHomeWithLocationExist(installSettings.getOracleHome())) {
                    userName = WinHelper.getOracleHomeUser((String)installSettings.getOracleHome());
                    b_clientOnTopOfDB = true;
                }
                if (userName != null && (WinHelper.isExistingHomeUserSecureUser((String)userName) ? !secureBean.isDeclineOption() : !userName.equals(secureBean.getUserName()))) {
                    throw new ValidationException((ErrorCode)CommonErrorCode.INSTALL_COMMON_EXISTING_HOME_USER_NOT_MATCHING, new Object[]{userName});
                }
                userName = !secureBean.isDeclineOption() ? secureBean.getUserName() : Credentials.BuiltinUser.LOCALSERVICE.toString();
                WinHelper WinHelper2 = new WinHelper();
                if (!WinHelper.userOwnsSpecifiedBase((String)userName, (String)installSettings.getOracleBase(), (boolean)b_clientOnTopOfDB)) {
                    throw new ValidationException((ErrorCode)CommonErrorCode.INSTALL_COMMON_HOME_USER_NOT_OWNER_OF_SPECIFIED_OB, new Object[0]);
                }
            }
            if (installSettings.isUpgrading()) {
                String oraHome = installSettings.getOracleHome();
                String[] validHomes = installSettings.getUpgradableHomes();
                boolean validHome = false;
                for (int i = 0; i < validHomes.length; ++i) {
                    if (!validHomes[i].equals(oraHome)) continue;
                    validHome = true;
                    break;
                }
                if (!validHome) {
                    errorMessages.add((StatusMessage)new ValidationStatusMessage((ErrorCode)ClientErrorCode.INVALID_HOME_FOR_UPGRADE, new Object[0]));
                }
                String processesFilename = System.getProperty("oracle.installer.startup_location") + "/../stage/processes.properties";
                File processesFile = new File(processesFilename);
                String[] processesList = null;
                ArrayList<String> existingFileList = new ArrayList<String>();
                if (processesFile.canRead() && processesFile.isFile()) {
                    String processesLine = FileParser.getPropertyFromTextFile((File)processesFile, (String)"FILES_TO_CHECK");
                    String tmpOraHome = oraHome.replaceAll("\\\\", "\\\\\\\\");
                    String instantiatedLine = processesLine.replaceAll("%ORACLE_HOME%", tmpOraHome);
                    processesList = instantiatedLine.split(",");
                }
                if (processesList != null) {
                    for (int i = 0; i < processesList.length; ++i) {
                        File file = new File((String)processesList[i]);
                        if (!file.exists()) continue;
                        logger.log(Level.FINE, "File Name::" + processesList[i]);
                        existingFileList.add(processesList[i]);
                        if (!processesList[i].contains("tnslsnr") || !PlatformInfo.getInstance().isWindows() || processesList[i].indexOf(".exe") <= -1) continue;
                        processesList[i] = processesList[i].substring(0, processesList[i].indexOf(".exe"));
                        existingFileList.add(processesList[i]);
                    }
                }
                if (PlatformInfo.getInstance().isWindows()) {
                    String serviceList = new String();
                    serviceList = NTServiceInfo.getRunningServices((String[])existingFileList.toArray(new String[0]));
                    if (serviceList.length() > 0) {
                        if (serviceList.contains(",")) {
                            serviceList = serviceList.substring(0, serviceList.lastIndexOf(","));
                        }
                        throw new ValidationException((ErrorCode)oracle.install.library.resource.CommonErrorCode.RUNNING_PROCESSES_SERVICES_FOUND, new Object[]{serviceList});
                    }
                } else {
                    RunningProcessInfoUnix.getInstance().getRunningProcesses(processesList);
                }
            }
        }
        catch (InstallException e) {
            throw new ValidationException((Throwable)e, e.getErrorInfo());
        }
    }

    public InstallSettings getInstallSettings(FlowContext flowContext) {
        InstallSettings installSettings = (InstallSettings)flowContext.getBean(ClientInstallSettings.class);
        return installSettings;
    }
}

