/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.ivw.client.view;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import oracle.bali.ewt.validate.ValidationComponent;
import oracle.bali.ewt.validate.Validator;
import oracle.install.commons.activehelp.ActiveHelpManager;
import oracle.install.commons.flow.EventType;
import oracle.install.commons.flow.FlowContext;
import oracle.install.commons.flow.View;
import oracle.install.commons.flow.annotation.ViewDef;
import oracle.install.commons.flow.validation.UncheckedValidationException;
import oracle.install.commons.flow.validation.ValidationException;
import oracle.install.commons.flow.validation.ValidationStatusMessage;
import oracle.install.commons.swing.LayoutUtils;
import oracle.install.commons.swing.MultilineLabel;
import oracle.install.commons.swing.SwingUtils;
import oracle.install.commons.swing.WholeNumberField;
import oracle.install.commons.swing.validate.InlineValidationHelper;
import oracle.install.commons.swing.validate.SimpleInlineValidator;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.Resource;
import oracle.install.commons.util.exception.ErrorCode;
import oracle.install.ivw.client.bean.ClientInstallSettings;
import oracle.install.ivw.client.resource.ClientErrorCode;
import oracle.install.ivw.client.validator.SchedulerAgentValidator;
import oracle.install.library.util.MachineInfo;

@ViewDef(id="SchedulerAgentUI")
public class SchedulerAgentGUI
implements View {
    private static final Logger logger = Logger.getLogger(SchedulerAgentGUI.class.getName());
    private Resource resource = Application.getInstance().getResource("oracle.install.ivw.client.resource.ClientDialogLabelResID");
    private JPanel basePanel;
    private MultilineLabel labelDialogDesc = new MultilineLabel();
    private JLabel labelHostname = new JLabel();
    private JTextField hostname;
    private JLabel labelPortNumber;
    private WholeNumberField portNumber;
    public static final Integer PORT_NUMBER_EMPTY = new Integer(-1);

    public SchedulerAgentGUI() {
        this.labelHostname.setName("SchedulerAgentGUI.labelHostname");
        this.hostname = new JTextField(15);
        this.hostname.setName("SchedulerAgentGUI.hostname");
        this.labelPortNumber = new JLabel();
        this.labelPortNumber.setName("SchedulerAgentGUI.labelPortNumber");
        this.portNumber = new WholeNumberField(1500, 15);
        this.portNumber.setName("SchedulerAgentGUI.portNumber");
        this.buildUI();
    }

    protected void buildUI() {
        this.basePanel = new JPanel();
        this.basePanel.setLayout(new GridBagLayout());
        LayoutUtils.addComponent((Component)this.labelDialogDesc, (Container)this.basePanel, (int)0, (int)0, (int)3, (int)1, (int)2, (int)18, (double)1.0, (double)0.0, (Insets)new Insets(5, 5, 30, 5));
        LayoutUtils.addComponent((Component)this.labelHostname, (Container)this.basePanel, (int)0, (int)1, (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0);
        LayoutUtils.addComponent((Component)this.hostname, (Container)this.basePanel, (int)1, (int)1, (int)1, (int)1, (int)2, (int)18, (double)1.0, (double)0.0);
        LayoutUtils.addComponent((Component)this.labelPortNumber, (Container)this.basePanel, (int)0, (int)2, (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0);
        LayoutUtils.addComponent((Component)this.portNumber, (Container)this.basePanel, (int)1, (int)2, (int)1, (int)1, (int)2, (int)18, (double)1.0, (double)0.0);
        LayoutUtils.addComponent((Component)Box.createGlue(), (Container)this.basePanel, (int)2, (int)1, (int)1, (int)2, (int)1, (int)18, (double)1.0, (double)1.0);
        this.labelHostname.setLabelFor(this.hostname);
        this.labelPortNumber.setLabelFor((Component)this.portNumber);
        ActiveHelpManager.registerComponent((JComponent)this.hostname, (String)"SchedulerAgentGUI.hostname");
        ActiveHelpManager.registerComponent((JComponent)this.portNumber, (String)"SchedulerAgentGUI.portNumber");
        InlineValidationHelper.registerInlineValidator((Component)this.getView(), (Component)this.portNumber, (Validator)new SimpleInlineValidator(){

            public ValidationStatusMessage doValidate(Component component, Object data) throws ValidationException {
                ValidationStatusMessage msg = null;
                if (data.toString().length() <= 0) {
                    msg = new ValidationStatusMessage((ErrorCode)ClientErrorCode.INVALID_SCH_AGT_PORT, new Object[0]);
                } else {
                    SchedulerAgentValidator.validateSchedulerAgentPort(Integer.parseInt(data.toString()));
                }
                return msg;
            }
        }, (Object)ValidationComponent.MODEL_CHANGE_VALIDATOR);
    }

    public void onEvent(FlowContext flowContext, EventType eventType) {
        switch (eventType) {
            case INIT: {
                ClientInstallSettings bean = (ClientInstallSettings)((Object)flowContext.getBean(ClientInstallSettings.class));
                Integer beanPortno = bean.getSchAgtPort();
                String portNumberVal = beanPortno != null ? Integer.toString(beanPortno) : this.getDefaultFreeLocalPortNumber();
                String beanHostname = bean.getSchAgtHost();
                String agentHostNameVal = beanHostname != null ? beanHostname : MachineInfo.getInstance().getFullHostName();
                if (portNumberVal != null) {
                    this.portNumber.setText(portNumberVal);
                }
                if (agentHostNameVal == null) break;
                this.hostname.setText(agentHostNameVal);
            }
        }
    }

    public void processInput(FlowContext flowContext) throws UncheckedValidationException {
        ClientInstallSettings bean = (ClientInstallSettings)((Object)flowContext.getBean(ClientInstallSettings.class));
        logger.log(Level.INFO, "Scheduler Agent UI entering processInput");
        switch (flowContext.getFlowDirection()) {
            case FORWARD: {
                if (this.portNumber.getText() == null) break;
                try {
                    bean.setSchAgtPort(Integer.parseInt(this.portNumber.getText()));
                    bean.setSchAgtHost(this.hostname.getText());
                    break;
                }
                catch (NumberFormatException e) {
                    throw new UncheckedValidationException((ErrorCode)ClientErrorCode.INVALID_SCH_AGT_PORT, new Object[0]);
                }
            }
            case BACKWARD: {
                bean.setSchAgtSelected(false);
            }
        }
    }

    public Component getView() {
        return this.basePanel;
    }

    public void localize(FlowContext flowContext) {
        if (this.basePanel != null) {
            this.labelDialogDesc.setText(this.resource.getString("SCH_AGT_DIALOG_DESC", "Please provide the following installation details for the Oracle Database Scheduler Agent.*", new Object[0]));
            String text = this.resource.getString("SCH_AGT_HOSTNAME_LABEL", "&Scheduler Agent Hostname:*", new Object[0]);
            SwingUtils.setText((JLabel)this.labelHostname, (String)text);
            text = this.resource.getString("SCH_AGT_PORT_NUM_LABEL", "Scheduler &Agent Port Number:*", new Object[0]);
            SwingUtils.setText((JLabel)this.labelPortNumber, (String)text);
        }
    }

    public String getDefaultFreeLocalPortNumber() {
        int portno;
        for (portno = 1025; !MachineInfo.getInstance().isLocalPortAvailable(portno) && portno <= 65535; ++portno) {
        }
        return Integer.toString(portno);
    }
}

