/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.base.launchpad;

import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import javax.swing.Box;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import oracle.install.commons.base.launchpad.SetupApp;
import oracle.install.commons.base.launchpad.SetupAppInfoRenderer;
import oracle.install.commons.swing.BannerFrame;
import oracle.install.commons.swing.LayoutUtils;
import oracle.install.commons.swing.MultilineLabel;
import oracle.install.commons.swing.SwingUtils;
import oracle.install.commons.util.Application;

class LaunchPadFrame
extends BannerFrame {
    public LaunchPadFrame(SetupApp[] setupApps) throws HeadlessException {
        Application application = Application.getInstance();
        JPanel setupAppChooserPane = new JPanel(new GridBagLayout());
        setupAppChooserPane.setBackground(UIManager.getColor("List.background"));
        MultilineLabel lblHeader = new MultilineLabel();
        lblHeader.setFocusable(false);
        SwingUtils.scaleFont(lblHeader, 0.1f);
        String header = application.getString("launchpad.header", "Choose a product to install.", new Object[0]);
        lblHeader.setText(header);
        MultilineLabel lblFooter = new MultilineLabel();
        lblFooter.setFocusable(false);
        String footer = application.getString("launchpad.footer", "", new Object[0]);
        lblFooter.setText(footer);
        JPanel contentPane = new JPanel(new GridBagLayout());
        LayoutUtils.addComponent(lblHeader, contentPane, 0, 0, 1, 1, 2, 11, 1.0, 0.0, new Insets(10, 5, 5, 5));
        LayoutUtils.addComponent(new JScrollPane(setupAppChooserPane), contentPane, 0, 1, 1, 1, 1, 11, 1.0, 1.0);
        LayoutUtils.addComponent(lblFooter, contentPane, 0, 2, 1, 1, 2, 11, 1.0, 0.0);
        super.getContentPane().removeAll();
        super.getContentPane().add(contentPane);
        super.setPreferredSize(new Dimension(640, 480));
        int row = 0;
        Insets insets = new Insets(0, 0, 0, 0);
        for (SetupApp setupApp : setupApps) {
            LayoutUtils.addComponent(new SetupAppInfoRenderer(setupApp), setupAppChooserPane, 0, row++, 1, 1, 2, 11, 1.0, 0.0, insets);
        }
        LayoutUtils.addComponent(Box.createGlue(), setupAppChooserPane, 0, row++, 1, 1, 1, 11, 1.0, 1.0, insets);
        super.pack();
        super.setSize(640, 480);
        super.setLocationRelativeTo(null);
        super.setResizable(false);
    }
}

