/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.base.prereq;

import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.cluster.verification.FixupOverallStatus;
import oracle.cluster.verification.FixupResult;
import oracle.cluster.verification.FixupResultSet;
import oracle.cluster.verification.NodeResultStatus;
import oracle.cluster.verification.OverallStatus;
import oracle.cluster.verification.VerificationError;
import oracle.cluster.verification.VerificationResult;
import oracle.cluster.verification.VerificationResultSet;
import oracle.cluster.verification.VerificationTask;
import oracle.install.commons.base.prereq.CompositePrereqCheckerJob;
import oracle.install.commons.base.prereq.PrereqCheckerJob;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.Resource;
import oracle.install.commons.util.StringUtils;
import oracle.install.commons.util.progress.Job;

public class PrereqResultMessageBuilder {
    private static final Logger logger = Logger.getLogger(PrereqResultMessageBuilder.class.getName());
    private Resource resource;
    public static final Object NOTHING = new Object();
    private StringBuffer messageBuffer = new StringBuffer();

    public PrereqResultMessageBuilder() {
        Application application = Application.getInstance();
        this.resource = application.getResource("oracle.install.commons.base.prereq.resource.StringResourceBundle");
    }

    public String getShortMessage(Job job, boolean multiNode, Object node) {
        return this.getMessage(job, true, multiNode, node);
    }

    public String getDetailedMessage(Job job, boolean multiNode, Object node) {
        return this.getMessage(job, false, multiNode, node);
    }

    public String getShortFixupResultMessage(VerificationTask task, boolean multiNode) {
        return this.getMessage(task, true, multiNode);
    }

    public String getDetailedFixupResultMessage(VerificationTask task, boolean multiNode) {
        return this.getMessage(task, false, multiNode);
    }

    private String getMessage(VerificationTask task, boolean shortMessage, boolean multiNode) {
        this.messageBuffer.setLength(0);
        FixupResultSet fixupResSet = task.getFixupResultSet();
        this.updateMessageBuffer(this.messageBuffer, task, shortMessage);
        try {
            this.updateMessageBuffer(this.messageBuffer, fixupResSet, shortMessage, multiNode);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Error occured while building fixup result summary", e);
        }
        return this.messageBuffer.toString();
    }

    private String getMessage(Job job, boolean shortMessage, boolean multiNode, Object nodeObj) {
        Job j;
        this.messageBuffer.setLength(0);
        VerificationTask task = null;
        VerificationResultSet resultSet = null;
        if (job instanceof CompositePrereqCheckerJob) {
            j = (CompositePrereqCheckerJob)job;
            task = ((CompositePrereqCheckerJob)j).getVerificationTask();
            resultSet = ((CompositePrereqCheckerJob)j).getVerificationResultSet();
        } else if (job instanceof PrereqCheckerJob) {
            j = (PrereqCheckerJob)job;
            task = ((PrereqCheckerJob)j).getVerificationTask();
            resultSet = ((PrereqCheckerJob)j).getVerificationResultSet();
        }
        this.updateMessageBuffer(this.messageBuffer, task, shortMessage);
        String node = null;
        boolean multiNodeSummary = false;
        if (multiNode) {
            node = nodeObj == NOTHING ? null : nodeObj.toString().toLowerCase();
            multiNodeSummary = node == null;
        }
        try {
            this.updateMessageBuffer(this.messageBuffer, resultSet, node, shortMessage, multiNodeSummary);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Error occured while building verification result summary", e);
        }
        return this.messageBuffer.toString();
    }

    private void updateMessageBuffer(StringBuffer messageBuffer, VerificationTask task, boolean shortMessage) {
        if (task != null) {
            String desc;
            if (!shortMessage) {
                messageBuffer.append(task.getElementName()).append(" - ");
            }
            messageBuffer.append((desc = task.getDescription()) != null ? desc : (!shortMessage ? this.resource.getString("prereqCheckerPane.details.emptyValue", "n/a", new Object[0]) : ""));
            if (shortMessage) {
                messageBuffer.append("&nbsp;<a href=\"#\">").append(this.resource.getString("prereqCheckerPane.lnkMoreDetails.text", "details", new Object[0])).append("</a>");
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void updateMessageBuffer(StringBuffer messageBuffer, FixupResultSet resultSet, boolean shortMessage, boolean multiNodeSummary) throws Exception {
        List nodeResults;
        if (resultSet == null) {
            return;
        }
        if (multiNodeSummary) {
            this.updateMessageBuffer(messageBuffer, resultSet, shortMessage);
            if (shortMessage) return;
            FixupOverallStatus overallStatus = resultSet.getFixupOverallStatus();
            switch (overallStatus) {
                case FAILED: 
                case UNKNOWN: {
                    List failedNodeList = resultSet.getFailedNodes();
                    if (failedNodeList == null || failedNodeList.isEmpty()) return;
                    messageBuffer.append("<br></br>");
                    for (String failedNode : failedNodeList) {
                        FixupResult result = resultSet.getResult(failedNode);
                        if (result == null) continue;
                        messageBuffer.append("<a name=\"" + failedNode + "\"></a>");
                        messageBuffer.append(this.resource.getString("PrereqResultCard.details.fixupFailedNodeResult", "Fixup result of failed node: {0}", failedNode));
                        messageBuffer.append("<br></br>");
                        this.updateMessageBuffer(messageBuffer, result, shortMessage);
                        messageBuffer.append("<a href=\"#top\">" + this.resource.getString("prereqCheckerPane.details.backToTop.text", "Back to Top", new Object[0]) + "</a>");
                        messageBuffer.append("<br></br>");
                        messageBuffer.append("<br></br>");
                    }
                    return;
                }
                case SUCCESSFUL: {
                    List succeededNodeList = resultSet.getSuccessfulNodes();
                    if (succeededNodeList == null || succeededNodeList.isEmpty()) return;
                    messageBuffer.append("<br></br><br></br>");
                    for (String succeededNode : succeededNodeList) {
                        FixupResult result = resultSet.getResult(succeededNode);
                        if (result == null) continue;
                        messageBuffer.append("<a name=\"" + succeededNode + "\"></a>");
                        messageBuffer.append(this.resource.getString("PrereqResultCard.details.FixupSucceededNodeResult", "Fixup result of succeeded node: {0}", succeededNode));
                        messageBuffer.append("<br></br>");
                        this.updateMessageBuffer(messageBuffer, result, shortMessage);
                        messageBuffer.append("<br></br>");
                    }
                    return;
                }
            }
            return;
        }
        FixupResult result = null;
        if (!shortMessage) {
            this.updateGlobalErrorMessage(messageBuffer, resultSet);
        }
        if (resultSet.hasNodeResults() && (nodeResults = resultSet.getNodeResults()) != null && !nodeResults.isEmpty()) {
            result = (FixupResult)nodeResults.get(0);
        }
        this.updateMessageBuffer(messageBuffer, result, shortMessage);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void updateMessageBuffer(StringBuffer messageBuffer, VerificationResultSet resultSet, String node, boolean shortMessage, boolean multiNodeSummary) throws Exception {
        if (resultSet == null) {
            return;
        }
        if (multiNodeSummary) {
            this.updateMessageBuffer(messageBuffer, resultSet, shortMessage);
            if (shortMessage) return;
            OverallStatus overallStatus = resultSet.getOverallStatus();
            switch (overallStatus) {
                case OPERATION_FAILED: 
                case VERIFICATION_FAILED: {
                    List failedNodeList = resultSet.getFailedNodes();
                    if (failedNodeList == null || failedNodeList.isEmpty()) return;
                    messageBuffer.append("<br></br>");
                    for (String failedNode : failedNodeList) {
                        VerificationResult result = resultSet.getNodeResult(failedNode);
                        if (result == null) continue;
                        messageBuffer.append("<a name=\"" + failedNode + "\"></a>");
                        messageBuffer.append(this.resource.getString("prereqCheckerPane.details.failedNodeResult", "Verification result of failed node: {0}", failedNode));
                        messageBuffer.append("<br></br>");
                        this.updateMessageBuffer(messageBuffer, result, shortMessage);
                        messageBuffer.append("<a href=\"#top\">" + this.resource.getString("prereqCheckerPane.details.backToTop.text", "Back to Top", new Object[0]) + "</a>");
                        messageBuffer.append("<br></br>");
                        messageBuffer.append("<br></br>");
                    }
                    return;
                }
                case SUCCESSFUL: 
                case WARNING: {
                    List succeededNodeList = resultSet.getSuccessfulNodes();
                    if (succeededNodeList == null || succeededNodeList.isEmpty()) return;
                    messageBuffer.append("<br></br><br></br>");
                    for (String succeededNode : succeededNodeList) {
                        VerificationResult result = resultSet.getNodeResult(succeededNode);
                        if (result == null) continue;
                        messageBuffer.append("<a name=\"" + succeededNode + "\"></a>");
                        if (result.getNodeResultStatus() == NodeResultStatus.VERIFICATION_WARNING) {
                            messageBuffer.append(this.resource.getString("prereqCheckerPane.details.warningNodeResult", "Verification WARNING result on node: {0}", succeededNode));
                        } else {
                            messageBuffer.append(this.resource.getString("prereqCheckerPane.details.succeededNodeResult", "Verification result of succeeded node: {0}", succeededNode));
                        }
                        messageBuffer.append("<br></br>");
                        this.updateMessageBuffer(messageBuffer, result, shortMessage);
                        messageBuffer.append("<br></br>");
                    }
                    return;
                }
            }
            return;
        }
        VerificationResult result = null;
        if (!shortMessage) {
            this.updateGlobalErrorMessage(messageBuffer, resultSet);
        }
        if (node == null) {
            List nodeResults;
            if (resultSet.hasNodeResults() && (nodeResults = resultSet.getNodeResults()) != null && !nodeResults.isEmpty()) {
                result = (VerificationResult)nodeResults.get(0);
            }
        } else {
            result = resultSet.getNodeResult(node);
        }
        this.updateMessageBuffer(messageBuffer, result, shortMessage);
    }

    private void updateMessageBuffer(StringBuffer messageBuffer, FixupResult result, boolean shortMessage) throws Exception {
        if (result != null && !shortMessage) {
            messageBuffer.append("<br></br>");
            this.updateResultSetErrorMessage(messageBuffer, result.getErrors());
        }
    }

    private void updateMessageBuffer(StringBuffer messageBuffer, VerificationResult result, boolean shortMessage) throws Exception {
        if (result != null) {
            String emptyValue;
            String expectedValue = emptyValue = this.resource.getString("prereqCheckerPane.details.emptyValue", "n/a", new Object[0]);
            if (result.hasResultValues()) {
                messageBuffer.append("<table cellspacing=\"1\" cellpadding=\"1\">");
                try {
                    expectedValue = result.getExpectedValue();
                    expectedValue = expectedValue != null ? expectedValue : emptyValue;
                    messageBuffer.append("<tr><td align=\"left\" nowrap>").append(this.resource.getString("prereqCheckerPane.details.expectedValue", "Expected Value", new Object[0])).append("</td><td>&nbsp;:&nbsp;").append(expectedValue).append("</td></tr>");
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "Expected value not found. Exception: ", e);
                }
                String actualValue = emptyValue;
                try {
                    actualValue = result.getActualValue();
                    actualValue = actualValue != null ? actualValue : emptyValue;
                    messageBuffer.append("<tr><td align=\"left\" nowrap>").append(this.resource.getString("prereqCheckerPane.details.actualValue", "Actual Value", new Object[0])).append("</td><td>&nbsp;:&nbsp;").append(actualValue).append("</td></tr>");
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "Actual value not found. Exception: ", e);
                }
                messageBuffer.append("</table>");
            } else {
                logger.log(Level.INFO, " Expected and Actual value not found");
            }
            if (!shortMessage) {
                this.updateResultSetErrorMessage(messageBuffer, result.getErrors());
            }
        }
    }

    private String getNodeList(List<String> nodeList) {
        int n = nodeList.size();
        StringBuffer buffer = new StringBuffer();
        buffer.append("[");
        for (int i = 0; i < n; ++i) {
            String node = nodeList.get(i);
            buffer.append("<a href=\"#").append(node).append("\">").append(node).append("</a>");
            if (i + 1 == n) continue;
            buffer.append(", &nbsp;");
        }
        buffer.append("]");
        return buffer.toString();
    }

    private void updateMessageBuffer(StringBuffer messageBuffer, VerificationResultSet resultSet, boolean shortMessage) {
        if (resultSet != null) {
            if (!shortMessage) {
                this.updateGlobalErrorMessage(messageBuffer, resultSet);
            }
            List nodeList = null;
            messageBuffer.append("<a name=\"top\"></a>");
            switch (resultSet.getOverallStatus()) {
                case OPERATION_FAILED: {
                    nodeList = resultSet.getFailedNodes();
                    if (nodeList == null || nodeList.size() <= 0) break;
                    messageBuffer.append("<br></br><br></br>");
                    messageBuffer.append(this.resource.getString("prereqCheckerPane.details.operationFailedOnNodes", "Operation Failed On Nodes: {0}", shortMessage ? nodeList.toString() : this.getNodeList(nodeList)));
                    messageBuffer.append("<br></br>");
                    break;
                }
                case VERIFICATION_FAILED: {
                    nodeList = resultSet.getFailedNodes();
                    if (nodeList != null && nodeList.size() > 0) {
                        messageBuffer.append("<br></br><br></br>");
                        messageBuffer.append(this.resource.getString("prereqCheckerPane.details.failedNodes", "Check Failed On Nodes: {0}", shortMessage ? nodeList.toString() : this.getNodeList(nodeList)));
                        messageBuffer.append("<br></br>");
                    }
                    if ((nodeList = resultSet.getSuccessfulNodes()) == null || nodeList.size() <= 0) break;
                    messageBuffer.append(this.resource.getString("prereqCheckerPane.details.successfulNodes", "Check Succeeded On Nodes: {0}", nodeList.toString()));
                    messageBuffer.append("<br></br>");
                }
            }
        }
    }

    private void updateMessageBuffer(StringBuffer messageBuffer, FixupResultSet resultSet, boolean shortMessage) {
        if (resultSet != null) {
            if (!shortMessage) {
                this.updateGlobalErrorMessage(messageBuffer, resultSet);
            }
            List nodeList = null;
            messageBuffer.append("<a name=\"top\"></a>");
            FixupOverallStatus status = resultSet.getFixupOverallStatus();
            switch (status) {
                case UNKNOWN: {
                    nodeList = resultSet.getFailedNodes();
                    if (nodeList == null || nodeList.size() <= 0) break;
                    messageBuffer.append("<br></br><br></br>");
                    messageBuffer.append(this.resource.getString("PrereqResultCard.details.fixupNotRunOnNodes", "Fixup is not run on Nodes: {0}", shortMessage ? nodeList.toString() : this.getNodeList(nodeList)));
                    messageBuffer.append("<br></br>");
                    break;
                }
                case FAILED: {
                    nodeList = resultSet.getFailedNodes();
                    if (nodeList == null || nodeList.size() <= 0) break;
                    messageBuffer.append("<br></br><br></br>");
                    messageBuffer.append(this.resource.getString("PrereqResultCard.details.fixupFailedOnNodes", "Fixup execution failed on Nodes: {0}", shortMessage ? nodeList.toString() : this.getNodeList(nodeList)));
                    messageBuffer.append("<br></br>");
                }
            }
            if ((status == FixupOverallStatus.UNKNOWN || status == FixupOverallStatus.FAILED) && (nodeList = resultSet.getSuccessfulNodes()) != null && nodeList.size() > 0) {
                messageBuffer.append("<br></br>");
                messageBuffer.append(this.resource.getString("PrereqResultCard.details.fixupSuccessfulNodes", "Fixup Succeeded On Nodes: {0}", nodeList.toString()));
                messageBuffer.append("<br></br>");
            }
        }
    }

    private void updateResultSetErrorMessage(StringBuffer messageBuffer, List<VerificationError> errors) {
        if (errors != null && !errors.isEmpty()) {
            messageBuffer.append("&nbsp;").append(this.resource.getString("prereqCheckerPane.details.errorList", "Details:", new Object[0])).append("<br></br>").append("<table border=\"0\">");
            this.updateErrorListMessage(messageBuffer, errors);
            messageBuffer.append("</table>");
        }
    }

    private void updateGlobalErrorMessage(StringBuffer messageBuffer, VerificationResultSet resultSet) {
        List errors;
        if (resultSet.getOverallStatus() != OverallStatus.SUCCESSFUL && (errors = resultSet.getErrors()) != null && !errors.isEmpty()) {
            messageBuffer.append("&nbsp;").append("<br></br>").append(this.resource.getString("prereqCheckerPane.details.globalError", "Error:", new Object[0])).append("<br></br>").append("<table border=\"0\">");
            this.updateErrorListMessage(messageBuffer, errors);
            messageBuffer.append("</table>");
        }
    }

    private void updateGlobalErrorMessage(StringBuffer messageBuffer, FixupResultSet resultSet) {
        List errors;
        if (resultSet.getFixupOverallStatus() != FixupOverallStatus.SUCCESSFUL && (errors = resultSet.getErrors()) != null && !errors.isEmpty()) {
            messageBuffer.append("&nbsp;").append("<br></br>").append(this.resource.getString("prereqCheckerPane.details.globalError", "Error:", new Object[0])).append("<br></br>").append("<table border=\"0\">");
            this.updateErrorListMessage(messageBuffer, errors);
            messageBuffer.append("</table>");
        }
    }

    private void updateErrorListMessage(StringBuffer messageBuffer, List<VerificationError> errors) {
        if (errors != null && !errors.isEmpty()) {
            for (VerificationError error : errors) {
                String message = error.getErrorMessage();
                String cause = error.getCause();
                String action = error.getAction();
                if (message == null) continue;
                messageBuffer.append("<tr>");
                messageBuffer.append("<td valign=\"top\" align=\"left\" nowrap>").append("&nbsp;-&nbsp;").append("</td>");
                messageBuffer.append("<td>").append(StringUtils.textToHtml(message)).append("<br></br>");
                Resource stringResBundle = Application.getInstance().getResource("oracle.install.commons.util.resource.StringResourceBundle");
                if (cause != null) {
                    messageBuffer.append("&nbsp;- ").append(stringResBundle.getString("ErrorMessage.details.titles.cause", "Cause *", new Object[0])).append(":&nbsp;").append(StringUtils.textToHtml(cause)).append("<br></br>");
                }
                if (action != null) {
                    messageBuffer.append("&nbsp;- ").append(stringResBundle.getString("ErrorMessage.details.titles.action", "Action *", new Object[0])).append(":&nbsp;").append(StringUtils.textToHtml(action)).append("<br></br>");
                }
                messageBuffer.append("</td>");
                messageBuffer.append("</tr>");
            }
        }
    }
}

