/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.base.util;

import java.io.File;
import java.net.InetAddress;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import oracle.install.commons.util.ProxyFactory;
import oracle.sysman.oii.oiix.OiixGeneralQueries;
import oracle.sysman.oii.oiix.OiixNetOps;
import oracle.sysman.oii.oiix.OiixPlatform;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PlatformInfo {
    private static PlatformInfo instance;
    private static final Logger logger;

    public static PlatformInfo getInstance() {
        ProxyFactory proxyFactory;
        if (instance == null && (instance = (proxyFactory = ProxyFactory.getInstance()).createProxy(PlatformInfo.class)) == null) {
            instance = new PlatformInfo();
        }
        return instance;
    }

    public int getCurrentPlatform() {
        return OiixPlatform.getCurrentPlatform();
    }

    public int getPlatGroup(int platId) {
        return OiixPlatform.getPlatGroup((int)platId);
    }

    public String getEnv(String varName) {
        return OiixGeneralQueries.getEnv((String)varName);
    }

    public void setEnv(String varName, String value) {
        OiixGeneralQueries.setEnv((String)varName, (String)value);
    }

    public String getDomainName(String hostName) {
        return OiixNetOps.getDomainName((String)hostName);
    }

    public String getFullHostName() {
        try {
            InetAddress local = InetAddress.getLocalHost();
            if (local != null) {
                local = InetAddress.getByName(local.getHostAddress());
                return local.getHostName();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    public String getDefaultCharset() {
        return "WE8MSWIN1252";
    }

    public boolean isWindows() {
        boolean windows = false;
        int platform = OiixPlatform.getCurrentPlatform();
        if (OiixPlatform.isPlatInGroup((int)-3, (int)platform)) {
            windows = true;
        }
        return windows;
    }

    public boolean isSolaris() {
        return OiixPlatform.getCurrentPlatform() == 453;
    }

    public boolean isAIX() {
        return OiixPlatform.getCurrentPlatform() == 610 || OiixPlatform.getCurrentPlatform() == 212;
    }

    public int getARUId() {
        int platform = this.getCurrentPlatform();
        try {
            String startupLoc = System.getProperty("oracle.installer.startup_location");
            File locOfShiphomeProperties = new File(new File(startupLoc).getParent(), "stage");
            File file = new File(locOfShiphomeProperties, "shiphomeproperties.xml");
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(file);
            doc.getDocumentElement().normalize();
            NodeList nodeLst = doc.getElementsByTagName("ARU_PLATFORM_INFO");
            for (int s = 0; s < nodeLst.getLength(); ++s) {
                Node fstNode = nodeLst.item(s);
                if (fstNode.getNodeType() != 1) continue;
                Element fstElmnt = (Element)fstNode;
                NodeList fstNmElmntLst = fstElmnt.getElementsByTagName("ARU_ID");
                Element fstNmElmnt = (Element)fstNmElmntLst.item(0);
                NodeList fstNm = fstNmElmnt.getChildNodes();
                String aruId = fstNm.item(0).getNodeValue();
                platform = Integer.parseInt(aruId);
            }
        }
        catch (Exception e) {
            logger.log(Level.FINEST, "Error occurred while retrieving the ARU id, proceeding with platform id" + e.getMessage());
        }
        return platform;
    }

    public String getWinArchitecture() {
        String arch = "";
        arch = System.getenv("PROCESSOR_ARCHITEW6432");
        if (arch != null && arch.length() != 0) {
            return arch;
        }
        arch = System.getenv("PROCESSOR_ARCHITECTURE");
        if (arch != null && arch.length() != 0) {
            return arch;
        }
        logger.log(Level.WARNING, "Can't determine the windows hosts's bit architecture.");
        arch = "x86";
        return arch;
    }

    static {
        logger = Logger.getLogger(PlatformInfo.class.getName());
    }
}

