/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.base.util;

import java.io.File;
import java.util.List;
import oracle.install.commons.base.util.ScriptExecutorEvent;
import oracle.install.commons.base.util.ScriptExecutorListener;
import oracle.install.commons.util.EventSupport;
import oracle.install.commons.util.exception.CheckedException;
import oracle.install.commons.util.message.Content;

public abstract class ScriptExecutor<T> {
    private EventSupport<ScriptExecutorEvent> eventSupport = new EventSupport();
    private String statusMessage;
    private float currentProgress;

    protected ScriptExecutor() {
    }

    public abstract boolean execute(File var1, List<String> var2, String ... var3) throws CheckedException;

    public abstract T getResultSet();

    public abstract Content getResultAsContent(String var1);

    public void addScriptExecutorListener(ScriptExecutorListener listener) {
        this.eventSupport.addEventListener(listener);
    }

    public void removeScriptExecutorListener(ScriptExecutorListener listener) {
        this.eventSupport.removeEventListener(listener);
    }

    protected void fireScriptExecutorEvent(ScriptExecutorEvent scriptExecutionEvent) {
        this.eventSupport.fireEvent(scriptExecutionEvent);
    }

    public void setStatusMessage(String message) {
        this.statusMessage = message;
        this.fireScriptExecutorEvent(new ScriptExecutorEvent(this, ScriptExecutorEvent.Type.STATUS_MESSAGE_UPDATED));
    }

    public void updateProgress(float progress) {
        this.currentProgress = progress;
        this.fireScriptExecutorEvent(new ScriptExecutorEvent(this, ScriptExecutorEvent.Type.PROGRESS_UPDATED));
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }

    public float getCurrentProgress() {
        return this.currentProgress;
    }
}

