/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.bean;

import oracle.install.commons.bean.BeanDefinition;
import oracle.install.commons.bean.BeanStore;
import oracle.install.commons.bean.BeanStoreEvent;
import oracle.install.commons.bean.BeanStoreException;
import oracle.install.commons.bean.PropertyDefinition;
import oracle.install.commons.bean.annotation.PropertyDef;

public abstract class BeanStoreWriter<T extends BeanStore> {
    protected BeanStoreWriter() {
    }

    public abstract T getBeanStore();

    public abstract void open(T var1) throws BeanStoreException;

    public void close() throws BeanStoreException {
    }

    protected String mask(String secureContent) {
        return secureContent.replaceAll(".", "*");
    }

    protected boolean isSecurityRequired(PropertyDefinition propertyDefinition) {
        PropertyDef propertyDef = propertyDefinition.getPropertyDef();
        return ((BeanStore)this.getBeanStore()).isSecure() ? (propertyDef != null ? propertyDef.secure() : false) : false;
    }

    protected boolean isPersistable(PropertyDefinition propertyDefinition) {
        PropertyDef propertyDef = propertyDefinition.getPropertyDef();
        return ((BeanStore)this.getBeanStore()).isSecure() ? (propertyDef != null ? propertyDef.persist() : true) : true;
    }

    public void writeAll(Object[] beans) throws BeanStoreException {
        for (Object bean : beans) {
            this.write(bean, null);
        }
    }

    public void write(Object bean) throws BeanStoreException {
        this.write(bean, null);
    }

    public void write(Object bean, String alias) throws BeanStoreException {
        if (bean != null) {
            try {
                BeanDefinition beanDefinition = BeanDefinition.getBeanDefinition(bean.getClass(), alias);
                T beanStore = this.getBeanStore();
                ((BeanStore)beanStore).fireApplicationEvent(new BeanStoreEvent((BeanStore)beanStore, BeanStoreEvent.Type.BEAN_STORE_WRITE_STARTED, new Object[0]));
                this.writeBean(bean, beanDefinition);
                ((BeanStore)beanStore).fireApplicationEvent(new BeanStoreEvent((BeanStore)beanStore, BeanStoreEvent.Type.BEAN_STORE_WRITE_ENDED, new Object[0]));
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new BeanStoreException(e);
            }
        }
    }

    protected abstract void writeBean(Object var1, BeanDefinition var2) throws BeanStoreException;
}

