/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.flow;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.install.commons.flow.Action;
import oracle.install.commons.flow.DynamicDefaultRoutine;
import oracle.install.commons.flow.FlowContext;
import oracle.install.commons.flow.FlowDirection;
import oracle.install.commons.flow.FlowHelper;
import oracle.install.commons.flow.Route;
import oracle.install.commons.flow.RoutePlanChangeEvent;
import oracle.install.commons.flow.RoutePlanChangeListener;
import oracle.install.commons.flow.State;
import oracle.install.commons.flow.TraceRoutePolicy;
import oracle.install.commons.flow.Transition;
import oracle.install.commons.util.Graph;

public class RoutePlan {
    private static final Logger logger = Logger.getLogger(RoutePlan.class.getName());
    public static final short SOURCE_FOLLOWED_PATH = 1;
    public static final short SOURCE_TENTATIVE_TRACED_PATH = 2;
    public static final short SOURCE_TRACED_PATH = 3;
    public static final short SOURCE_TENTATIVE_PATH = 4;
    private Set<RoutePlanChangeListener> changeListeners = new HashSet<RoutePlanChangeListener>();
    private Graph<Route, State> currentVertex;
    private List<Graph<Route, State>> followedPath = new ArrayList<Graph<Route, State>>();
    private List<Graph<Route, State>> tentativePath = new ArrayList<Graph<Route, State>>();
    private List<Graph<Route, State>> tentativeTracedPath = new ArrayList<Graph<Route, State>>();
    private List<Graph<Route, State>> rolledBackPath = new ArrayList<Graph<Route, State>>();
    private List<Graph<Route, State>> tracedPath = new ArrayList<Graph<Route, State>>();
    private TraceRoutePolicy traceRoutePolicy = TraceRoutePolicy.NONE;
    private FlowContext flowContext;

    public FlowContext getFlowContext() {
        return this.flowContext;
    }

    public void setFlowContext(FlowContext flowContext) {
        this.flowContext = flowContext;
    }

    public Graph<Route, State> getLastTracedVertex(Graph<Route, State> referenceVertex) {
        Graph<Route, State> lastTracedVertex = null;
        if (!this.tracedPath.isEmpty()) {
            if (referenceVertex != null && this.tracedPath.contains(referenceVertex)) {
                lastTracedVertex = referenceVertex;
            } else {
                for (Graph<Route, State> vertex : this.followedPath) {
                    if (this.isTraceable(vertex)) {
                        lastTracedVertex = vertex;
                    }
                    if (vertex != referenceVertex) continue;
                    break;
                }
            }
        }
        return lastTracedVertex;
    }

    public int getTentativeCurrentIndex() {
        return this.tentativeTracedPath.indexOf(this.currentVertex);
    }

    public int getTentativeTracedPathLength() {
        return this.tentativeTracedPath.size();
    }

    private List<Graph<Route, State>> getSourceList(short sourceId) {
        List<Graph<Route, State>> sourceList = null;
        switch (sourceId) {
            case 1: {
                sourceList = this.followedPath;
                break;
            }
            case 2: {
                sourceList = this.tentativeTracedPath;
                break;
            }
            case 3: {
                sourceList = this.tracedPath;
                break;
            }
            case 4: {
                sourceList = this.tentativePath;
            }
        }
        return sourceList;
    }

    public Graph<Route, State> getPreviousVertex(short sourceId) {
        int index;
        Graph<Route, State> previousVertex = null;
        List<Graph<Route, State>> sourceList = this.getSourceList(sourceId);
        if (sourceList != null && (index = sourceList.indexOf(this.currentVertex)) > 0) {
            previousVertex = sourceList.get(index - 1);
        }
        return previousVertex;
    }

    public FlowDirection getDirection(Graph<Route, State> from, Graph<Route, State> to) {
        FlowDirection direction = FlowDirection.NONE;
        int fromIndex = this.followedPath.indexOf(from);
        int toIndex = this.followedPath.indexOf(to);
        if (fromIndex != -1 && toIndex != -1) {
            int diff = fromIndex - toIndex;
            if (diff < 0) {
                direction = FlowDirection.FORWARD;
            } else if (diff > 0) {
                direction = FlowDirection.BACKWARD;
            }
        }
        return direction;
    }

    public boolean isVisitedVertex(Graph<Route, State> vertex) {
        return this.followedPath.contains(vertex);
    }

    public TraceRoutePolicy getTraceRoutePolicy() {
        return this.traceRoutePolicy;
    }

    public void setTraceRoutePolicy(TraceRoutePolicy traceRoutePolicy) {
        this.traceRoutePolicy = traceRoutePolicy;
    }

    public Graph<Route, State> getCurrentVertex() {
        return this.currentVertex;
    }

    public List<Graph<Route, State>> getTracedPath() {
        return Collections.unmodifiableList(this.tracedPath);
    }

    public List<Graph<Route, State>> getFollowedPath() {
        return Collections.unmodifiableList(this.followedPath);
    }

    public List<Graph<Route, State>> getTentativeTracedPath() {
        return Collections.unmodifiableList(this.tentativeTracedPath);
    }

    public List<Graph<Route, State>> getTentativePath() {
        return Collections.unmodifiableList(this.tentativePath);
    }

    public List<Graph<Route, State>> getRolledBackPath() {
        return Collections.unmodifiableList(this.rolledBackPath);
    }

    public void lookAhead(Route route) {
        Route _route = route;
        int eventId = 0;
        if (this.flowContext != null && this.flowContext.getTransition() != null && this.flowContext.getTransition().getType() == Transition.Type.SEQUENTIAL) {
            Graph<Route, State> vertex;
            int index = this.tentativePath.indexOf(this.currentVertex);
            if (index != -1) {
                int n = this.tentativePath.size();
                for (int i = index; i < n; ++i) {
                    Graph<Route, State> nextVertex;
                    vertex = this.tentativePath.get(i);
                    if (!vertex.isAmbiguous() || i + 1 >= n || !(nextVertex = this.tentativePath.get(i + 1)).isAmbiguous() || !vertex.isLinkedTo(nextVertex, route)) continue;
                    return;
                }
            }
            vertex = this.currentVertex;
            this.rollbackTentativePathTo(vertex, true);
            Graph<Route, State> flow = vertex;
            boolean ambiguous = false;
            while (!ambiguous & flow != null) {
                if (this.isTraceable(flow) && !this.tentativeTracedPath.contains(flow)) {
                    eventId |= 4;
                    this.tentativeTracedPath.add(flow);
                }
                if (!this.tentativePath.contains(flow)) {
                    this.tentativePath.add(flow);
                }
                if (ambiguous = flow.isAmbiguous()) {
                    State state = flow.getValue();
                    if (_route == null) {
                        Graph<Route, State> nextVertex;
                        int i = this.tentativePath.indexOf(flow);
                        if (i + 1 < this.tentativePath.size() && FlowHelper.isLinkedToEx(this.flowContext, flow, nextVertex = this.tentativePath.get(i + 1))) {
                            flow = nextVertex;
                            continue;
                        }
                        _route = this.getDynamicDefaultRoute(this.flowContext, state);
                        if (_route == null) {
                            _route = state.getDefaultRoute();
                        }
                    }
                    if (_route == null) continue;
                    flow = FlowHelper.findNextVertex(this.flowContext, flow, _route);
                    ambiguous = false;
                    _route = null;
                    continue;
                }
                flow = FlowHelper.findNextVertex(this.flowContext, flow);
            }
            if (eventId != 0) {
                this.fireChangeEvent(eventId);
            }
        }
        logger.log(Level.FINEST, "-----RoutePlan-----\n{0}----------------\n", this);
    }

    public void addRoutePlanChangeListener(RoutePlanChangeListener changeListener) {
        this.changeListeners.add(changeListener);
    }

    public void removeRoutePlanChangeListener(RoutePlanChangeListener changeListener) {
        this.changeListeners.remove(changeListener);
    }

    protected void fireChangeEvent(int id) {
        RoutePlanChangeEvent e = new RoutePlanChangeEvent(this, id);
        for (RoutePlanChangeListener l : this.changeListeners) {
            l.stateChanged(e);
        }
        e.setSource(null);
    }

    public boolean isTraceable(Graph<Route, State> vertex) {
        boolean traceable = false;
        if (this.traceRoutePolicy == TraceRoutePolicy.ONLY_VIEW_STATES) {
            State state = vertex.getValue();
            traceable = state.isViewState();
        }
        return traceable;
    }

    public void layoutAt(Graph<Route, State> vertex, Transition.Type transitionType) {
        if (vertex != null && this.currentVertex != vertex) {
            int vertexPosInTentativePath;
            this.rolledBackPath.clear();
            int eventId = 1;
            if (transitionType == Transition.Type.SEQUENTIAL && (vertexPosInTentativePath = this.tentativePath.indexOf(vertex)) != -1 && vertexPosInTentativePath > this.followedPath.size()) {
                for (int i = this.followedPath.size(); i < vertexPosInTentativePath; ++i) {
                    this.rolledBackPath.add(this.tentativePath.get(i));
                }
                this.tentativePath.removeAll(this.rolledBackPath);
                eventId |= 0x10;
                this.tentativeTracedPath.removeAll(this.rolledBackPath);
                eventId |= 4;
            }
            if (transitionType == null || transitionType != Transition.Type.RANDOM || !this.followedPath.contains(vertex)) {
                FlowDirection direction = FlowDirection.NONE;
                int index = -1;
                Graph<Route, State> expectedVertex = vertex;
                Graph<Route, State> expectedTraceableVertex = vertex;
                if (this.currentVertex != null) {
                    direction = this.getDirection(this.currentVertex, vertex);
                    index = this.followedPath.indexOf(this.currentVertex);
                    for (int i = index + 1; i < this.followedPath.size(); ++i) {
                        Graph<Route, State> v = this.followedPath.get(i);
                        if (!this.isTraceable(v)) continue;
                        expectedTraceableVertex = v;
                        break;
                    }
                    if (index + 1 < this.followedPath.size()) {
                        expectedVertex = this.followedPath.get(index + 1);
                    }
                }
                if (direction != FlowDirection.BACKWARD && vertex != expectedTraceableVertex && vertex != expectedVertex) {
                    index = this.followedPath.indexOf(expectedVertex);
                    if (index != -1) {
                        while (this.followedPath.size() != index) {
                            eventId |= 2;
                            Graph<Route, State> discardedVertex = this.followedPath.remove(index);
                            if (!this.isTraceable(discardedVertex) || this.rolledBackPath.contains(discardedVertex)) continue;
                            this.rolledBackPath.add(discardedVertex);
                        }
                    }
                    eventId |= this.rollbackTentativePathTo(this.currentVertex, true);
                    this.tracedPath.removeAll(this.rolledBackPath);
                } else if (this.currentVertex != null && !this.tentativePath.contains(vertex)) {
                    eventId |= this.rollbackTentativePathTo(this.currentVertex, true);
                }
                if (!this.followedPath.contains(vertex)) {
                    eventId |= 2;
                    this.followedPath.add(vertex);
                }
                if (this.isTraceable(vertex) && !this.tracedPath.contains(vertex)) {
                    eventId |= 8;
                    this.tracedPath.add(vertex);
                }
                Graph<Route, State> lastVertex = null;
                Graph<Route, State> flow = vertex;
                boolean ambiguous = false;
                while (!ambiguous & flow != null) {
                    if ((lastVertex != null && !lastVertex.isLinkedTo(flow) || flow.getValue().isConditional()) && !this.tentativePath.contains(flow)) {
                        eventId |= this.rollbackTentativePathTo(lastVertex, true);
                    }
                    if (this.isTraceable(flow) && !this.tentativeTracedPath.contains(flow)) {
                        eventId |= 4;
                        this.tentativeTracedPath.add(flow);
                    }
                    if (!this.tentativePath.contains(flow)) {
                        this.tentativePath.add(flow);
                    }
                    lastVertex = flow;
                    ambiguous = flow.isAmbiguous();
                    if (ambiguous) {
                        Graph<Route, State> nextVertex;
                        Route route = null;
                        State state = flow.getValue();
                        int i = this.tentativePath.indexOf(flow);
                        if (i + 1 < this.tentativePath.size() && FlowHelper.isLinkedToEx(this.flowContext, flow, nextVertex = this.tentativePath.get(i + 1))) {
                            flow = nextVertex;
                            continue;
                        }
                        route = this.getDynamicDefaultRoute(this.flowContext, state);
                        if (route == null) {
                            route = state.getDefaultRoute();
                        }
                        if (route == null) continue;
                        flow = FlowHelper.findNextVertex(this.flowContext, flow, route);
                        ambiguous = false;
                        continue;
                    }
                    flow = FlowHelper.findNextVertex(this.flowContext, flow);
                }
            }
            this.currentVertex = vertex;
            if (eventId != 0) {
                this.fireChangeEvent(eventId);
            }
            logger.log(Level.FINEST, "-----RoutePlan-----\n{0}----------------\n", this);
        }
    }

    private Route getDynamicDefaultRoute(FlowContext flowContext, State state) {
        if (state != null) {
            Action action = state.getAction();
            if (action != null) {
                if (action instanceof DynamicDefaultRoutine) {
                    logger.log(Level.FINEST, "Computing dynamic default route for state: " + state.getId());
                    Route route = ((DynamicDefaultRoutine)((Object)action)).getDynamicDefaultRoute(flowContext);
                    if (route != null) {
                        logger.log(Level.FINEST, "Dynamic default route for state " + state.getId() + ": " + route.getId());
                    } else {
                        logger.log(Level.FINEST, "No dynamic default route for state: " + state.getId());
                    }
                    return route;
                }
            } else {
                logger.log(Level.FINEST, "Action to get its dynamic default route is null.");
            }
        } else {
            logger.log(Level.FINEST, "State to get its dynamic default route is null.");
        }
        return null;
    }

    private int rollbackTentativePathTo(Graph<Route, State> vertex, boolean nextTo) {
        int eventId = 0;
        int index = this.tentativePath.indexOf(vertex);
        if (index != -1) {
            if (nextTo) {
                ++index;
            }
            while (this.tentativePath.size() != index) {
                Graph<Route, State> discardedVertex = this.tentativePath.remove(index);
                eventId |= 0x10;
                if (!this.isTraceable(discardedVertex) || !this.tentativeTracedPath.remove(discardedVertex)) continue;
                eventId |= 4;
                if (this.rolledBackPath.contains(discardedVertex)) continue;
                this.rolledBackPath.add(discardedVertex);
            }
        }
        return eventId;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Current Vertex   :");
        buffer.append(this.currentVertex.getValue().getId());
        buffer.append('\n');
        buffer.append("Followed Path    :");
        buffer.append(this.followedPath);
        buffer.append('\n');
        buffer.append("Tentative Traced Path   :");
        buffer.append(this.tentativeTracedPath);
        buffer.append('\n');
        buffer.append("Tentative Path   :");
        buffer.append(this.tentativePath);
        buffer.append('\n');
        buffer.append("Rolled Back Path :");
        buffer.append(this.rolledBackPath);
        buffer.append('\n');
        buffer.append("Traced Path      :");
        buffer.append(this.tracedPath);
        buffer.append('\n');
        buffer.append("Selectable Nodes  :");
        buffer.append("-todo-");
        buffer.append('\n');
        return buffer.toString();
    }
}

