/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.flow;

import oracle.install.commons.flow.AbstractFlowExecutor;
import oracle.install.commons.flow.FlowDisplay;
import oracle.install.commons.flow.FlowException;
import oracle.install.commons.flow.FlowExecutorType;
import oracle.install.commons.flow.State;
import oracle.install.commons.flow.TransitionAbortedException;
import oracle.install.commons.flow.validation.ValidationException;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.exception.ExceptionManager;

public class SilentFlowExecutor
extends AbstractFlowExecutor {
    @Override
    public FlowExecutorType getFlowExecutorType() {
        return FlowExecutorType.SILENT;
    }

    @Override
    public void execute() {
        ExceptionManager em = ExceptionManager.getInstance();
        State state = null;
        do {
            try {
                state = super.nextState();
            }
            catch (FlowException e) {
                em.handleException(e);
                Application.addExitStatus(Application.CommonExitStatus.FAILURE);
                break;
            }
            catch (ValidationException e) {
                em.handleException(e);
            }
            catch (TransitionAbortedException e) {
                break;
            }
        } while (state != null);
        Application application = Application.getInstance();
        application.shutdown();
    }

    @Override
    public FlowDisplay getFlowDisplay() {
        return null;
    }
}

