/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.flow;

import java.util.HashMap;
import java.util.Map;
import oracle.install.commons.flow.Action;
import oracle.install.commons.flow.Condition;
import oracle.install.commons.flow.Route;
import oracle.install.commons.flow.StateType;
import oracle.install.commons.flow.View;
import oracle.install.commons.flow.ViewManager;
import oracle.install.commons.flow.ViewManagerException;
import oracle.install.commons.flow.validation.Validator;

public class State {
    private String id;
    private Action action;
    private View view;
    private String viewId;
    private boolean checkpointEnabled;
    private boolean startState;
    private boolean finishState;
    private String validatorId;
    private Validator validator;
    private boolean validationRequired = true;
    private boolean viewInitialized;
    private boolean dirty;
    private Map<Object, Object> attributes;
    private StateType stateType = StateType.process;
    private Route defaultRoute;
    private boolean conditional;
    private Condition condition;
    private boolean actionInitialized;

    public String getViewId() {
        return this.viewId;
    }

    public void setViewId(String viewId) {
        this.viewId = viewId;
        this.view = null;
    }

    public Action getAction() {
        return this.action;
    }

    public void setAction(Action action) {
        this.action = action;
        this.view = null;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public View getView() throws ViewManagerException {
        if (this.view == null) {
            if (this.viewId != null) {
                this.view = ViewManager.getView(this.viewId);
            } else if (this.action != null) {
                this.view = ViewManager.getView(this.action);
                this.viewId = ViewManager.getViewId(this.action);
            }
        }
        return this.view;
    }

    public void setView(View view) {
        this.view = view;
    }

    public boolean isCheckpointEnabled() {
        return this.checkpointEnabled;
    }

    public void setCheckpointEnabled(boolean checkpointEnabled) {
        this.checkpointEnabled = checkpointEnabled;
    }

    public Validator getValidator() {
        return this.validator;
    }

    public void setValidator(Validator validator) {
        this.validator = validator;
    }

    public String getValidatorId() {
        return this.validatorId;
    }

    public void setValidatorId(String validatorId) {
        this.validatorId = validatorId;
    }

    public boolean isViewState() {
        return this.view != null || this.viewId != null || (this.viewId = ViewManager.getViewId(this.action)) != null;
    }

    public boolean isStartState() {
        return this.startState;
    }

    public void setStartState(boolean start) {
        this.startState = start;
    }

    public boolean isFinishState() {
        return this.finishState;
    }

    public void setFinishState(boolean finishState) {
        this.finishState = finishState;
    }

    public boolean isValidationRequired() {
        return this.validationRequired;
    }

    public void setValidationRequired(boolean validationRequired) {
        this.validationRequired = validationRequired;
    }

    public boolean isViewInitialized() {
        return this.viewInitialized;
    }

    public void setViewInitialized(boolean viewInitialized) {
        this.viewInitialized = viewInitialized;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public void setAttribute(Object key, Object value) {
        this.attributes = this.attributes == null ? new HashMap() : this.attributes;
        this.attributes.put(key, value);
    }

    public Object getAttribute(Object key) {
        return this.attributes != null ? this.attributes.get(key) : null;
    }

    public void removeAttribute(Object key) {
        this.attributes.remove(key);
    }

    public StateType getStateType() {
        return this.stateType;
    }

    public void setStateType(StateType stateType) {
        this.stateType = stateType == null ? StateType.process : stateType;
    }

    public String toString() {
        return this.id;
    }

    public Route getDefaultRoute() {
        return this.defaultRoute;
    }

    public void setDefaultRoute(Route defaultRoute) {
        this.defaultRoute = defaultRoute;
    }

    public boolean isConditional() {
        return this.conditional;
    }

    public void setConditional(boolean conditional) {
        this.conditional = conditional;
    }

    public Condition getCondition() {
        return this.condition;
    }

    public void setCondition(Condition condition) {
        this.condition = condition;
    }

    public boolean isActionInitialized() {
        return this.actionInitialized;
    }

    public void setActionInitialized(boolean actionInitialized) {
        this.actionInitialized = actionInitialized;
    }
}

