/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.flow;

import oracle.install.commons.flow.FlowDirection;
import oracle.install.commons.flow.Route;
import oracle.install.commons.flow.State;
import oracle.install.commons.flow.TransitionAbortedException;
import oracle.install.commons.flow.TransitionEvent;
import oracle.install.commons.flow.TransitionListener;
import oracle.install.commons.util.EventSupport;
import oracle.install.commons.util.Graph;
import oracle.install.commons.util.progress.Status;

public class Transition {
    private Route route;
    private Graph<Route, State> sourceVertex;
    private Graph<Route, State> destinationVertex;
    private Step step;
    private Status status;
    private EventSupport<TransitionEvent> eventSupport = new EventSupport();
    private FlowDirection direction;
    private Type type;
    private State currentState;

    public boolean isInProgress() {
        return this.status == Status.INPROGRESS;
    }

    public Type getType() {
        return this.type;
    }

    public FlowDirection getDirection() {
        return this.direction;
    }

    public Route getRoute() {
        return this.route;
    }

    public Graph<Route, State> getSourceVertex() {
        return this.sourceVertex;
    }

    public Graph<Route, State> getDestinationVertex() {
        return this.destinationVertex;
    }

    public Step getStep() {
        return this.step;
    }

    public Status getStatus() {
        return this.status;
    }

    public boolean isAborted() {
        return this.status == Status.ABORTED;
    }

    public State getCurrentState() {
        return this.currentState;
    }

    public void abort() throws IllegalStateException {
        if (this.step != null) {
            switch (this.step) {
                case PROCESS_INPUT_FROM_VIEW: 
                case VALIDATE_VIEW: 
                case VALIDATE: 
                case TRANSITION: {
                    this.setStatus(Status.ABORTED);
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
    }

    public void addTransitionListener(TransitionListener listener) {
        this.eventSupport.addEventListener(listener);
    }

    public void removeTransitionListener(TransitionListener listener) {
        this.eventSupport.removeEventListener(listener);
    }

    public boolean isStarted() {
        return this.status == Status.INPROGRESS;
    }

    public boolean isEnded() {
        boolean flag = false;
        switch (this.status) {
            case ABORTED: 
            case CANCELLED: 
            case FAILED: 
            case SUCCEEDED: {
                flag = true;
            }
        }
        return flag;
    }

    protected void setType(Type type) {
        this.type = type;
    }

    protected void setDirection(FlowDirection direction) {
        this.direction = direction;
    }

    protected void setRoute(Route route) {
        this.route = route;
    }

    protected void setSourceVertex(Graph<Route, State> source) {
        this.sourceVertex = source;
    }

    protected void setDestinationVertex(Graph<Route, State> destination) {
        if (this.isAborted()) {
            throw new TransitionAbortedException();
        }
        this.destinationVertex = destination;
    }

    protected void setStatus(Status status) {
        if (this.status != status) {
            this.status = status;
            this.fireTransitionEvent(new TransitionEvent(this, TransitionEvent.Type.STATUS_CHANGED));
        }
    }

    protected void begin(Type type, FlowDirection direction, Graph<Route, State> sourceVertex) {
        this.type = type;
        this.direction = direction;
        this.sourceVertex = sourceVertex;
        this.setStatus(Status.INPROGRESS);
        if (sourceVertex != null) {
            this.currentState = sourceVertex.getValue();
        }
    }

    protected void moveTo(Graph<Route, State> destinationVertex, Route route) {
        this.setDestinationVertex(destinationVertex);
        this.setRoute(route);
        if (destinationVertex != null) {
            this.currentState = destinationVertex.getValue();
        }
    }

    protected void end() {
        if (this.status != null) {
            if (this.step == Step.EXECUTE) {
                this.setStatus(Status.SUCCEEDED);
            } else if (this.status != Status.ABORTED) {
                this.setStatus(Status.FAILED);
            }
            this.reset();
        }
    }

    protected void beginStep(Step step) throws TransitionAbortedException {
        if (this.isAborted()) {
            throw new TransitionAbortedException();
        }
        this.step = step;
        this.fireTransitionEvent(new TransitionEvent(this, TransitionEvent.Type.STEP_BEGUN));
    }

    protected void endStep() {
        this.fireTransitionEvent(new TransitionEvent(this, TransitionEvent.Type.STEP_ENDED));
    }

    protected void fireTransitionEvent(TransitionEvent e) {
        this.eventSupport.fireEvent(e);
    }

    private void reset() {
        this.step = null;
        this.route = null;
        this.sourceVertex = null;
        this.destinationVertex = null;
        this.direction = null;
    }

    public static enum Step {
        INITIALIZE_ACTION,
        INITIALIZE_VIEW,
        DISPLAY_VIEW,
        LOAD_VIEW,
        LOCALIZE_VIEW,
        EXECUTE,
        PROCESS_INPUT_FROM_VIEW,
        VALIDATE_VIEW,
        VALIDATE,
        TRANSITION,
        UNLOAD_VIEW;


        public static boolean isViewOriented(Step step) {
            boolean flag = false;
            switch (step) {
                case INITIALIZE_VIEW: 
                case DISPLAY_VIEW: 
                case LOAD_VIEW: 
                case LOCALIZE_VIEW: 
                case PROCESS_INPUT_FROM_VIEW: 
                case VALIDATE_VIEW: 
                case UNLOAD_VIEW: {
                    flag = true;
                }
            }
            return flag;
        }
    }

    public static enum Type {
        RANDOM,
        SEQUENTIAL;

    }
}

