/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.swing;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;

public class CollapseButton
extends JButton {
    private Icon collapseIcon;
    private Icon expandIcon;
    private boolean collapsed;
    private Dimension preferredSize;

    public CollapseButton() {
        this("");
    }

    public CollapseButton(String caption) {
        super(caption);
        this.setOpaque(false);
        this.setBorderPainted(false);
        this.collapsed = true;
        this.collapseIcon = this.loadIcon("collapse.jpg");
        this.expandIcon = this.loadIcon("expand.jpg");
        if (this.expandIcon != null && caption == null) {
            this.preferredSize = new Dimension(this.expandIcon.getIconHeight() + 1, this.expandIcon.getIconWidth() + 1);
        }
        this.setIcon(this.expandIcon);
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                CollapseButton.this.collapsed = !CollapseButton.this.collapsed;
                CollapseButton.this.setIcon(CollapseButton.this.collapsed ? CollapseButton.this.expandIcon : CollapseButton.this.collapseIcon);
            }
        });
        this.setHorizontalTextPosition(2);
    }

    @Override
    public Dimension getPreferredSize() {
        return this.preferredSize != null ? this.preferredSize : super.getPreferredSize();
    }

    @Override
    public Dimension getSize(Dimension arg0) {
        return super.getPreferredSize();
    }

    @Override
    public Dimension getMaximumSize() {
        return super.getPreferredSize();
    }

    @Override
    public Dimension getMinimumSize() {
        return super.getPreferredSize();
    }

    public boolean isCollapsed() {
        return this.collapsed;
    }

    public void setCollapsed(boolean collapsed) {
        this.collapsed = collapsed;
    }

    public Icon getCollapseIcon() {
        return this.collapseIcon;
    }

    public void setCollapseIcon(Icon collapseIcon) {
        this.collapseIcon = collapseIcon;
    }

    public Icon getExpandIcon() {
        return this.expandIcon;
    }

    public void setExpandIcon(Icon expandIcon) {
        this.expandIcon = expandIcon;
    }

    protected ImageIcon loadIcon(String icon) {
        ImageIcon imageIcon = null;
        try {
            URL iconURL = this.getClass().getResource("images/" + icon);
            imageIcon = new ImageIcon(iconURL);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return imageIcon;
    }
}

