/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Rectangle;
import java.beans.PropertyChangeSupport;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellRenderer;
import oracle.install.commons.swing.RadioTableCellRenderer;

public class ToggleButtonTableCellRenderer
implements TableCellRenderer {
    protected static Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);
    private static final Border SAFE_NO_FOCUS_BORDER = new EmptyBorder(1, 1, 1, 1);
    private JToggleButton rendererComponent;
    private PropertyChangeSupport propertyChangeSupport;
    private Color unselectedForeground;
    private Color unselectedBackground;

    public ToggleButtonTableCellRenderer(JToggleButton renderer) {
        this.rendererComponent = renderer;
        renderer.setText("");
        renderer.setOpaque(true);
        renderer.setBorder(ToggleButtonTableCellRenderer.getNoFocusBorder());
        this.propertyChangeSupport = new PropertyChangeSupport(renderer);
    }

    public JToggleButton getRendererComponent() {
        return this.rendererComponent;
    }

    private static Border getNoFocusBorder() {
        if (System.getSecurityManager() != null) {
            return SAFE_NO_FOCUS_BORDER;
        }
        return noFocusBorder;
    }

    public void setForeground(Color c) {
        this.rendererComponent.setForeground(c);
        this.unselectedForeground = c;
    }

    public void setBackground(Color c) {
        this.rendererComponent.setBackground(c);
        this.unselectedBackground = c;
    }

    public void updateUI() {
        this.rendererComponent.updateUI();
        this.setForeground(null);
        this.setBackground(null);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (isSelected) {
            this.rendererComponent.setForeground(table.getSelectionForeground());
            this.rendererComponent.setBackground(table.getSelectionBackground());
        } else {
            this.rendererComponent.setForeground(this.unselectedForeground != null ? this.unselectedForeground : table.getForeground());
            this.rendererComponent.setBackground(this.unselectedBackground != null ? this.unselectedBackground : table.getBackground());
        }
        this.rendererComponent.setFont(table.getFont());
        if (hasFocus) {
            Border border = null;
            if (isSelected) {
                border = UIManager.getBorder("Table.focusSelectedCellHighlightBorder");
            }
            if (border == null) {
                border = UIManager.getBorder("Table.focusCellHighlightBorder");
            }
            this.rendererComponent.setBorder(border);
            if (!isSelected && table.isCellEditable(row, column)) {
                Color col = UIManager.getColor("Table.focusCellForeground");
                if (col != null) {
                    this.rendererComponent.setForeground(col);
                }
                if ((col = UIManager.getColor("Table.focusCellBackground")) != null) {
                    this.rendererComponent.setBackground(col);
                }
            }
        } else {
            this.rendererComponent.setBorder(ToggleButtonTableCellRenderer.getNoFocusBorder());
        }
        if (value instanceof Boolean) {
            this.rendererComponent.setSelected((Boolean)value);
        }
        this.rendererComponent.setEnabled(value != null && table.isCellEditable(row, column));
        return this.rendererComponent;
    }

    public boolean isOpaque() {
        Color back = this.rendererComponent.getBackground();
        Container p = this.rendererComponent.getParent();
        if (p != null) {
            p = p.getParent();
        }
        boolean colorMatch = back != null && p != null && back.equals(p.getBackground()) && p.isOpaque();
        return !colorMatch && this.rendererComponent.isOpaque();
    }

    public void invalidate() {
    }

    public void validate() {
    }

    public void revalidate() {
    }

    public void repaint(long tm, int x, int y, int width, int height) {
    }

    public void repaint(Rectangle r) {
    }

    public void repaint() {
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (propertyName == "text") {
            this.propertyChangeSupport.firePropertyChange(propertyName, oldValue, newValue);
        }
    }

    public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
    }

    public static class UIResource
    extends RadioTableCellRenderer
    implements javax.swing.plaf.UIResource {
    }
}

