/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.util;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.StatusControl;
import oracle.install.commons.util.UIType;

public class Splash
extends StatusControl {
    private static Splash splash = null;

    public static Splash getInstance() {
        if (splash == null) {
            Application application = Application.getInstance();
            splash = application.getUIType() == UIType.GRAPHICAL ? new GraphicalSplash() : new Splash();
            splash.open();
        }
        return splash;
    }

    private static class GraphicalSplash
    extends Splash {
        private JDialog window;
        private JLabel lblMessage;

        public GraphicalSplash() {
            Application application = Application.getInstance();
            ImageIcon splashIcon = application.getIcon("application.splash", new Object[0]);
            if (splashIcon != null) {
                this.lblMessage = new JLabel();
                JPanel pnl = new JPanel(new BorderLayout());
                pnl.setBorder(BorderFactory.createRaisedBevelBorder());
                pnl.add(new JLabel(splashIcon));
                pnl.add((Component)this.lblMessage, "South");
                this.window = new JDialog((Frame)null);
                this.window.setUndecorated(true);
                this.window.getContentPane().add(pnl);
                this.window.pack();
                this.window.setSize(splashIcon.getIconWidth(), splashIcon.getIconHeight());
                this.window.setLocationRelativeTo(null);
            }
        }

        @Override
        public void close() {
            if (this.window != null) {
                this.window.dispose();
            }
            super.close();
        }

        @Override
        public void open() {
            if (this.window != null) {
                this.window.setVisible(true);
            }
            super.open();
        }

        @Override
        public void showMessage(String message) {
            super.showMessage(message);
            if (this.window != null) {
                this.lblMessage.setText(message);
            }
        }
    }
}

