/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.util;

import java.io.Serializable;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Version
implements Serializable,
Comparable<Version> {
    static final long serialVersionUID = 65536L;
    public static final MessageFormat DEFAULT_PATTERN = new MessageFormat("{0}.{1}.{2}.{3}.{4}");
    public static final String VERSION_PATTERN = "[0-9]+\\.[0-9]+\\.[0-9]+\\.[0-9]+\\.[0-9]+[a-zA-Z]?";
    public static final Version UNKNOWN = new Version(0, 0, 0, 0, 0);
    private String major;
    private String minor;
    private String release;
    private String patch;
    private String operatingSystem;
    private String[] version;
    private String formattedString;
    private Pattern pattern = Pattern.compile("[0-9]+\\.[0-9]+\\.[0-9]+\\.[0-9]+\\.[0-9]+[a-zA-Z]?", 2);

    public Version() {
        this(1, 0, 0, 0, 0);
    }

    public Version(int major, int minor, int release, int patch, int operatingSystem) {
        this(Integer.toString(major), Integer.toString(minor), Integer.toString(release), Integer.toString(patch), Integer.toString(operatingSystem));
    }

    public Version(String major, String minor, String release, String patch, String operatingSystem) {
        this.version = new String[]{major, minor, release, patch, operatingSystem};
        this.formattedString = DEFAULT_PATTERN.format(this.version);
        Matcher matcher = this.pattern.matcher(this.formattedString);
        if (!matcher.matches()) {
            throw new IllegalArgumentException(this.formattedString);
        }
        this.major = major;
        this.minor = minor;
        this.release = release;
        this.patch = patch;
        this.operatingSystem = operatingSystem;
    }

    public String getMajor() {
        return this.major;
    }

    public String getMinor() {
        return this.minor;
    }

    public String getOperatingSystem() {
        return this.operatingSystem;
    }

    public String getPatch() {
        return this.patch;
    }

    public String getRelease() {
        return this.release;
    }

    @Override
    public int compareTo(Version v) {
        return this.compareTo(v, this.version.length);
    }

    public int compareTo(Version v, int depth) {
        int result = 1;
        if (this.version != null) {
            result = this.compare(v, 0, depth);
        }
        return result;
    }

    public String toString() {
        return this.formattedString;
    }

    public boolean equals(Object v) {
        boolean flag = false;
        if (v instanceof Version) {
            Version version = (Version)v;
            flag = this.compareTo(version) == 0;
        }
        return flag;
    }

    private int compare(Version v, int digit, int depth) {
        if (this.comparePart(this.version[digit], v.version[digit]) > 0) {
            return 1;
        }
        if (this.comparePart(this.version[digit], v.version[digit]) == 0) {
            if (++digit == depth) {
                return 0;
            }
            return this.compare(v, digit, depth);
        }
        return -1;
    }

    public int comparePart(String versionOnePart, String versionTwoPart) {
        if (versionOnePart != null && versionOnePart.length() > 0 && versionTwoPart != null && versionTwoPart.length() > 0) {
            int verTwoIntValue;
            char verOneChar = versionOnePart.charAt(versionOnePart.length() - 1);
            boolean isVerOneLetter = Character.isLetter(verOneChar);
            char verTwoChar = versionTwoPart.charAt(versionTwoPart.length() - 1);
            boolean isVerTwoLetter = Character.isLetter(verTwoChar);
            String verOneDigits = isVerOneLetter ? versionOnePart.substring(0, versionOnePart.length() - 1) : versionOnePart;
            String verTwoDigits = isVerTwoLetter ? versionTwoPart.substring(0, versionTwoPart.length() - 1) : versionTwoPart;
            int verOneIntValue = Integer.parseInt(verOneDigits);
            if (verOneIntValue == (verTwoIntValue = Integer.parseInt(verTwoDigits))) {
                if (isVerOneLetter || isVerTwoLetter) {
                    if (isVerOneLetter && isVerTwoLetter) {
                        int diff = ("" + verOneChar).compareToIgnoreCase("" + verTwoChar);
                        return diff > 0 ? 1 : (diff == 0 ? 0 : -1);
                    }
                    if (isVerOneLetter) {
                        return 1;
                    }
                    return -1;
                }
                return 0;
            }
            if (verOneIntValue > verTwoIntValue) {
                return 1;
            }
        }
        return -1;
    }

    public static String format(Version version, String pattern) {
        return MessageFormat.format(pattern, version.version);
    }

    public static Version parseVersion(String text) throws IllegalArgumentException {
        Version version = null;
        try {
            Object[] tokens = DEFAULT_PATTERN.parse(text);
            if (tokens == null || tokens.length != 5) {
                throw new IllegalArgumentException(text);
            }
            String[] v = new String[5];
            for (int i = 0; i < 5; ++i) {
                try {
                    v[i] = tokens[i].toString();
                    continue;
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException(text);
                }
            }
            version = new Version(v[0], v[1], v[2], v[3], v[4]);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(text);
        }
        return version;
    }

    public static Version parseVersion(String text, boolean padTokens) throws IllegalArgumentException {
        int i;
        Version version = null;
        String[] tokens = text.split("\\.");
        if (tokens == null || tokens.length == 0 || tokens.length > 5) {
            throw new IllegalArgumentException(text);
        }
        String[] v = new String[5];
        for (i = 0; i < tokens.length; ++i) {
            try {
                v[i] = tokens[i].toString();
                continue;
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(text);
            }
        }
        if (tokens.length < 5) {
            for (i = tokens.length; i < 5; ++i) {
                v[i] = "0";
            }
        }
        version = new Version(v[0], v[1], v[2], v[3], v[4]);
        return version;
    }
}

