/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.util.exception;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.install.commons.util.MessageOption;
import oracle.install.commons.util.Option;
import oracle.install.commons.util.exception.Advice;
import oracle.install.commons.util.exception.ErrorMessage;
import oracle.install.commons.util.exception.Severity;

public class ErrMsgAnalyzer {
    private List<ErrorIdType> ignorableErrors;
    private List<ErrorIdType> fatalErrors;
    private Pattern errCodeMatchPattern = Pattern.compile("^[a-zA-Z]{3,5}-[0-9]{3,5}(?=:)");
    private static final Logger logger = Logger.getLogger(ErrMsgAnalyzer.class.getName());
    public static final String ERROR_CODE_REGEX = "^[a-zA-Z]{3,5}-[0-9]{3,5}";
    public static final String ERROR_CODE_MATCH_REGEX = "^[a-zA-Z]{3,5}-[0-9]{3,5}(?=:)";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIgnorableErrors(List<ErrorIdType> ignorableErrors) {
        if (ignorableErrors != null && !ignorableErrors.isEmpty()) {
            ErrMsgAnalyzer errMsgAnalyzer = this;
            synchronized (errMsgAnalyzer) {
                this.ignorableErrors = ignorableErrors;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addIgnorableError(ErrorIdType error) {
        if (error != null) {
            ErrMsgAnalyzer errMsgAnalyzer = this;
            synchronized (errMsgAnalyzer) {
                if (this.ignorableErrors == null) {
                    this.ignorableErrors = new ArrayList<ErrorIdType>();
                }
                this.ignorableErrors.add(error);
            }
        } else {
            logger.log(Level.WARNING, "Error code is null or not mathcing error code pattern:" + error);
        }
    }

    public void addIgnorableErrors(List<ErrorIdType> errors) {
        if (errors != null && !errors.isEmpty()) {
            for (ErrorIdType error : errors) {
                this.addIgnorableError(error);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeIgnorableError(ErrorIdType error) {
        if (error != null) {
            ErrMsgAnalyzer errMsgAnalyzer = this;
            synchronized (errMsgAnalyzer) {
                if (this.ignorableErrors != null) {
                    this.ignorableErrors.remove(error);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearIgnorableErrors() {
        ErrMsgAnalyzer errMsgAnalyzer = this;
        synchronized (errMsgAnalyzer) {
            if (this.ignorableErrors != null) {
                this.ignorableErrors.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFatalErrors(List<ErrorIdType> fatalErrors) {
        if (fatalErrors != null && !fatalErrors.isEmpty()) {
            ErrMsgAnalyzer errMsgAnalyzer = this;
            synchronized (errMsgAnalyzer) {
                this.fatalErrors = fatalErrors;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFatalError(ErrorIdType error) {
        if (error != null) {
            ErrMsgAnalyzer errMsgAnalyzer = this;
            synchronized (errMsgAnalyzer) {
                if (this.fatalErrors == null) {
                    this.fatalErrors = new ArrayList<ErrorIdType>();
                }
                this.fatalErrors.add(error);
            }
        } else {
            logger.log(Level.WARNING, "Error code is null or not mathcing error code pattern:" + error);
        }
    }

    public void addFatalErrors(List<ErrorIdType> errors) {
        if (errors != null && !errors.isEmpty()) {
            for (ErrorIdType error : errors) {
                this.addFatalError(error);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFatalError(ErrorIdType error) {
        if (error != null) {
            ErrMsgAnalyzer errMsgAnalyzer = this;
            synchronized (errMsgAnalyzer) {
                if (this.fatalErrors != null) {
                    this.fatalErrors.remove(error);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearFatalErrors() {
        ErrMsgAnalyzer errMsgAnalyzer = this;
        synchronized (errMsgAnalyzer) {
            if (this.fatalErrors != null) {
                this.fatalErrors.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean needReporting(ErrorIdType errorCode) {
        if (errorCode != null) {
            ErrMsgAnalyzer errMsgAnalyzer = this;
            synchronized (errMsgAnalyzer) {
                if (this.isFatalError(errorCode)) {
                    return true;
                }
                if (this.isIgnorableError(errorCode)) {
                    return false;
                }
            }
        }
        return true;
    }

    public ErrorIdType getErrorId(String errorMessage) {
        Matcher m;
        if (errorMessage != null && !errorMessage.isEmpty() && (m = this.errCodeMatchPattern.matcher(errorMessage)).find()) {
            return this.constructErrorIdObj(m.group());
        }
        return null;
    }

    public ErrorIdType getErrorId(ErrorMessage errorMessage) {
        if (errorMessage != null && errorMessage.getErrorInfo() != null) {
            return this.constructErrorIdObj(errorMessage.getErrorInfo().getErrorFQN());
        }
        return this.getErrorId(errorMessage.getMessage());
    }

    private ErrorIdType constructErrorIdObj(String errorCode) {
        String[] errCodeParts;
        if (errorCode != null && errorCode.contains("-") && (errCodeParts = errorCode.split("-")) != null && errCodeParts.length == 2) {
            return new ErrorIdType(errCodeParts[0], Integer.parseInt(errCodeParts[1]));
        }
        return null;
    }

    private boolean isFatalError(ErrorIdType errorCode) {
        if (errorCode != null) {
            if (this.fatalErrors != null && !this.fatalErrors.isEmpty()) {
                return this.fatalErrors.contains(errorCode);
            }
            return !this.isIgnorableError(errorCode);
        }
        return true;
    }

    private boolean isIgnorableError(ErrorIdType errorCode) {
        if (errorCode != null && this.ignorableErrors != null) {
            return this.ignorableErrors.contains(errorCode);
        }
        return false;
    }

    public Severity getErrMessageSeverity(ErrorIdType errorCode) {
        if (errorCode != null && this.needReporting(errorCode)) {
            if (this.isFatalError(errorCode)) {
                return Severity.FATAL;
            }
            if (!this.isIgnorableError(errorCode)) {
                return Severity.WARNING;
            }
            return Severity.INFO;
        }
        return Severity.INFO;
    }

    public Option[] getMessageOptions(Level level) {
        if (level != null) {
            if (Level.SEVERE == level) {
                return MessageOption.OPTIONS_OK;
            }
            if (Level.WARNING == level) {
                return MessageOption.OPTIONS_CONTINUE_ABORT;
            }
        }
        return MessageOption.OPTIONS_OK;
    }

    protected Option getDefaultOption(Level level) {
        if (level != null) {
            if (Level.SEVERE == level) {
                return MessageOption.OK;
            }
            if (Level.WARNING == level) {
                return MessageOption.CONTINUE;
            }
        }
        return MessageOption.OK;
    }

    public Advice getAdvice(Level level, Option option) {
        if (option != null && option instanceof MessageOption) {
            MessageOption messageOption = (MessageOption)option;
            switch (messageOption) {
                case ABORT: {
                    return Advice.ABORT;
                }
                case CANCEL: {
                    return Advice.WITHDRAW;
                }
                case CONTINUE: {
                    return Advice.CONTINUE;
                }
                case NO: {
                    return Advice.WITHDRAW;
                }
                case OK: {
                    return level == Level.SEVERE ? Advice.ABORT : Advice.NONE;
                }
                case RETRY: {
                    return Advice.RETRY;
                }
                case YES: {
                    return Advice.CONTINUE;
                }
            }
            return Advice.NONE;
        }
        return Advice.NONE;
    }

    public static class ErrorIdType {
        private String type;
        private int errorId;

        public ErrorIdType(String type, int errorId) {
            this.type = type;
            this.errorId = errorId;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public int getErrorId() {
            return this.errorId;
        }

        public void setErrorId(int errorId) {
            this.errorId = errorId;
        }

        public int hashCode() {
            if (this.type != null) {
                return this.type.hashCode();
            }
            return this.errorId;
        }

        public boolean equals(Object obj) {
            if (obj != null && obj instanceof ErrorIdType) {
                ErrorIdType errObj = (ErrorIdType)obj;
                if (this.type != null && this.type.equalsIgnoreCase(errObj.getType())) {
                    return this.errorId == errObj.getErrorId();
                }
            }
            return false;
        }
    }
}

