/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.util.html;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Stack;
import java.util.logging.Logger;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.parser.ParserDelegator;

public class HTMLToPlainTextConverter
extends HTMLEditorKit.ParserCallback {
    private static final Logger logger = Logger.getLogger(HTMLToPlainTextConverter.class.getName());
    protected StringBuffer stringBuffer = new StringBuffer();
    protected Stack<IndexType> indentStack = new Stack();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String convert(String html) {
        StringReader in = new StringReader(html);
        try {
            this.parse(in);
        }
        catch (Exception e) {
            logger.severe(e.getMessage());
        }
        finally {
            try {
                ((Reader)in).close();
            }
            catch (IOException e) {}
        }
        String text = this.getText();
        if (null != text && text.length() > 0) {
            text = text.replace('\u00a0', ' ');
        }
        return text;
    }

    public void parse(Reader in) throws IOException {
        ParserDelegator delegator = new ParserDelegator();
        delegator.parse(in, this, Boolean.TRUE);
    }

    @Override
    public void handleStartTag(HTML.Tag t, MutableAttributeSet a, int pos) {
        if (this.indentStack.size() > 0 && this.indentStack.peek().type.equals("pre")) {
            this.stringBuffer.append("<" + t.toString() + ">");
        } else if (t.toString().equals("pre")) {
            this.indentStack.push(new IndexType("pre"));
            this.newLine();
        } else {
            this.handleNonPreStartTag(t, a, pos);
        }
    }

    private void newLine() {
        this.stringBuffer.append("\n");
        for (int i = 0; i < this.indentStack.size(); ++i) {
            this.stringBuffer.append("    ");
        }
    }

    @Override
    public void handleEndTag(HTML.Tag t, int pos) {
        if (this.indentStack.size() > 0 && this.indentStack.peek().type.equals("pre") && !t.toString().equals("pre")) {
            this.stringBuffer.append("</" + t.toString() + ">");
        } else {
            this.handleNonPreEndTag(t, pos);
        }
    }

    @Override
    public void handleSimpleTag(HTML.Tag t, MutableAttributeSet a, int pos) {
        if (this.indentStack.size() > 0 && this.indentStack.peek().type.equals("pre")) {
            this.stringBuffer.append("<" + t.toString() + ">");
        } else {
            this.handleNonPreSimpleTag(t, a, pos);
        }
    }

    protected void handleNonPreStartTag(HTML.Tag t, MutableAttributeSet a, int pos) {
        if (t.toString().equals("p")) {
            if (this.stringBuffer.length() > 0 && !this.stringBuffer.substring(this.stringBuffer.length() - 1).equals("\n")) {
                this.newLine();
            }
            this.newLine();
        } else if (t.toString().equals("ol")) {
            this.indentStack.push(new IndexType("ol"));
            this.newLine();
        } else if (t.toString().equals("ul")) {
            this.indentStack.push(new IndexType("ul"));
            this.newLine();
        } else if (t.toString().equals("li")) {
            IndexType parent = this.indentStack.peek();
            if (parent.type.equals("ol")) {
                String numberString = "" + ++parent.counter + ".";
                this.stringBuffer.append(numberString);
                for (int i = 0; i < 4 - numberString.length(); ++i) {
                    this.stringBuffer.append(" ");
                }
            } else {
                this.stringBuffer.append("*   ");
            }
            this.indentStack.push(new IndexType("li"));
        } else if (t.toString().equals("dl")) {
            this.newLine();
        } else if (t.toString().equals("dt")) {
            this.newLine();
        } else if (t.toString().equals("dd")) {
            this.indentStack.push(new IndexType("dd"));
            this.newLine();
        } else if (t.toString().equals("table")) {
            this.indentStack.push(new IndexType("table"));
            this.newLine();
        }
    }

    protected void handleNonPreSimpleTag(HTML.Tag t, MutableAttributeSet a, int pos) {
        if (t.toString().equals("br")) {
            this.newLine();
        }
    }

    protected void handleNonPreEndTag(HTML.Tag t, int pos) {
        if (t.toString().equals("p")) {
            this.newLine();
        } else if (t.toString().equals("ol")) {
            this.indentStack.pop();
            this.newLine();
        } else if (t.toString().equals("ul")) {
            this.indentStack.pop();
            this.newLine();
        } else if (t.toString().equals("li")) {
            this.indentStack.pop();
            this.newLine();
        } else if (t.toString().equals("dd")) {
            this.indentStack.pop();
        } else if (t.toString().equals("tr")) {
            this.newLine();
        } else if (t.toString().equals("table")) {
            this.indentStack.pop();
        } else if (t.toString().equals("td")) {
            this.stringBuffer.append("    ");
        } else if (t.toString().equals("pre")) {
            this.indentStack.pop();
            this.newLine();
        }
    }

    @Override
    public void handleText(char[] text, int pos) {
        this.stringBuffer.append(text);
    }

    public String getText() {
        return this.stringBuffer.toString();
    }

    public static class IndexType {
        public String type;
        public int counter;

        public IndexType(String type) {
            this.type = type;
            this.counter = 0;
        }
    }
}

