/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.util.progress;

import java.awt.Dimension;
import javax.accessibility.AccessibleContext;
import javax.swing.JTable;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.Resource;
import oracle.install.commons.util.progress.Job;
import oracle.install.commons.util.progress.JobCellRenderer;
import oracle.install.commons.util.progress.ProgressModel;
import oracle.install.commons.util.progress.ProgressModelEvent;
import oracle.install.commons.util.progress.ProgressModelListener;
import oracle.install.commons.util.progress.Status;
import oracle.install.commons.util.progress.StatusCellRenderer;
import oracle.install.commons.util.progress.resource.StringResourceBundle;

public class JobTable
extends JTable {
    private static final long serialVersionUID = 1L;
    private AccessibleJobTable accessibleContext;
    private ProgressModel progressModel;

    public JobTable() {
        this.setFocusable(false);
        this.setAutoscrolls(true);
        this.setSelectionBackground(super.getBackground());
        this.setSelectionForeground(super.getForeground());
        this.getTableHeader().setPreferredSize(new Dimension(1, 2));
        this.setDefaultRenderer(Status.class, new StatusCellRenderer());
        this.setDefaultRenderer(Job.class, new JobCellRenderer());
    }

    public void setProgressModel(ProgressModel progressModel) {
        if (progressModel == null) {
            return;
        }
        ProgressModel oldValue = this.progressModel;
        if (oldValue != progressModel) {
            this.progressModel = progressModel;
            super.setModel(progressModel);
            this.getColumnModel().getColumn(0).setMaxWidth(18);
            this.getColumnModel().getColumn(2).setMaxWidth(150);
            if (oldValue != null) {
                oldValue.removeProgressModelListener(this.accessibleContext);
            }
            this.progressModel.addProgressModelListener(this.accessibleContext);
        }
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJobTable();
            if (this.progressModel != null) {
                this.progressModel.addProgressModelListener(this.accessibleContext);
            }
        }
        return this.accessibleContext;
    }

    class AccessibleJobTable
    extends JTable.AccessibleJTable
    implements ProgressModelListener {
        private static final long serialVersionUID = 1L;
        private Resource stringTable;

        public AccessibleJobTable() {
            super(JobTable.this);
            Application application = Application.getInstance();
            this.stringTable = application.getResource(StringResourceBundle.class.getName());
        }

        @Override
        public void update(ProgressModelEvent e) {
            switch ((ProgressModelEvent.Type)e.getType()) {
                case JOB_STATUS_CHANGED: {
                    Job job = e.getJob();
                    String description = job.getDescription();
                    Status status = job.getStatus();
                    if (status == null || description == null) break;
                    String statusText = this.stringTable.getString(status.name(), status.name(), new Object[0]);
                    String accessibleDescription = String.format("%s. %s.", description, statusText);
                    this.setAccessibleDescription(accessibleDescription);
                }
            }
        }
    }
}

