/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.driver.oui;

import java.io.IOException;
import java.util.logging.Level;
import oracle.install.commons.base.driver.common.SetupDriver;
import oracle.install.commons.base.driver.common.SetupDriverException;
import oracle.install.commons.base.summary.Summary;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.Resource;
import oracle.install.commons.util.progress.ProgressUI;
import oracle.install.commons.util.progress.Status;
import oracle.install.driver.oui.ConfigJob;
import oracle.install.driver.oui.DriverConstants;
import oracle.install.driver.oui.OUISetupDriver;

public class PrepareConfigJobEx
extends ConfigJob {
    public PrepareConfigJobEx(Object id, float weightage, String oracleHome, String aggCfgID) {
        super(id, weightage, oracleHome, aggCfgID);
        Application application = Application.getInstance();
        Resource resource = application.getResource(DriverConstants.STRING_RESOURCE_BUNDLE_NAME);
        String description = resource.getString("prepareConfigJob.description", "Prepare Configuration", new Object[0]);
        this.setDescription(description);
        this.setHidden(true);
        Summary.getInstance().setSuccessfulConfig(true);
    }

    @Override
    public Void call() throws Exception {
        this.setStatus(Status.INPROGRESS);
        Object driver = SetupDriver.getInstance();
        try {
            if (driver instanceof OUISetupDriver) {
                OUISetupDriver ouiSetupDriver = (OUISetupDriver)driver;
                ouiSetupDriver.prepareConfig(this, this.getOracleHome(), this.getAggCfgID());
            }
            this.setStatus(Status.SUCCEEDED);
        }
        catch (SetupDriverException e) {
            this.setStatus(Status.FAILED);
            throw e;
        }
        catch (IOException e) {
            this.setStatus(Status.FAILED);
            throw e;
        }
        return null;
    }

    @Override
    public void retry() throws Exception {
        this.call();
    }

    @Override
    public void setStatus(Status status) {
        super.setStatus(status);
        Resource resource = Application.getInstance().getResource(DriverConstants.STRING_RESOURCE_BUNDLE_NAME);
        String message = null;
        switch (status) {
            case INPROGRESS: {
                message = resource.getString("ConfigProgressMonitor.plugin.execution.inprogress", "Starting ''{0}''", this.getDescription());
                break;
            }
            case SUCCEEDED: 
            case SUCCEEDED_PARTIALLY: 
            case FAILED: {
                message = resource.getString("ConfigProgressMonitor.plugin.execution.completed", "Completed ''{0}''", this.getDescription());
            }
        }
        ProgressUI progressUI = ((SetupDriver)SetupDriver.getInstance()).getProgressUI();
        if (progressUI != null && message != null) {
            progressUI.log(Level.INFO, message, new Object[0]);
        }
    }
}

