/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.driver.oui;

import java.awt.Component;
import java.awt.Frame;
import java.awt.Window;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import oracle.install.commons.base.driver.common.SetupDriver;
import oracle.install.commons.base.driver.common.SetupMode;
import oracle.install.commons.base.interview.common.view.ConfigurationScriptDialog;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.Console;
import oracle.install.commons.util.Resource;
import oracle.install.commons.util.ResourceURL;
import oracle.install.commons.util.StatusMessages;
import oracle.install.commons.util.exception.Advice;
import oracle.install.commons.util.exception.ErrorMessage;
import oracle.install.commons.util.exception.ExceptionManager;
import oracle.install.commons.util.progress.CompositeJob;
import oracle.install.commons.util.progress.Job;
import oracle.install.commons.util.progress.ProgressUI;
import oracle.install.commons.util.progress.Retriable;
import oracle.install.commons.util.progress.Status;
import oracle.install.driver.oui.DriverConstants;
import oracle.install.driver.oui.OUISetupDriver;
import oracle.install.driver.oui.SetupJob;
import oracle.install.driver.oui.resource.StringResourceBundle;
import oracle.sysman.oii.oiif.oiifm.OiifmIRootShInfo;

public class RootScriptJob
extends CompositeJob
implements Callable<Void>,
Retriable<Job> {
    private static final Logger logger = Logger.getLogger(RootScriptJob.class.getName());
    private SetupJob setupJob;
    private Filter filter;
    Advice retryRootScript;
    private boolean executeRootScripts;
    private String promptForRootScript;
    private String executionStepsPromptForRootScript;
    private String orderOfExectionPromptForRootScript;
    private String customRootScriptMessage;

    public RootScriptJob(SetupJob setupJob) {
        this(setupJob, null);
    }

    public RootScriptJob(SetupJob setupJob, boolean executeScripts) {
        this(setupJob, null, executeScripts);
    }

    public RootScriptJob(SetupJob setupJob, Filter filter) {
        this(setupJob, filter, false);
    }

    public RootScriptJob(SetupJob setupJob, Filter filter, boolean executeScripts) {
        this(setupJob, null, filter, executeScripts);
        this.setRetryEnabled(true);
        this.setRetriable(this);
        Application application = Application.getInstance();
        this.setDescription(application.getString(ResourceURL.resURL(DriverConstants.STRING_RESOURCE_BUNDLE_NAME, "rootScriptJob.text"), "Execute Root Scripts", setupJob.getDescription()));
    }

    public RootScriptJob(SetupJob setupJob, String description, Filter filter, boolean executeScripts) {
        super("rootscript", null, 0.05f);
        this.setDescription(description);
        this.setupJob = setupJob;
        this.filter = filter;
        this.executeRootScripts = executeScripts;
        this.setRetryEnabled(true);
        this.setRetriable(this);
        if (((SetupDriver)SetupDriver.getInstance()).getSetupMode() == SetupMode.SILENT) {
            this.putClientProperty("oracle.install.job.printProgresStatus", Boolean.FALSE);
        }
    }

    public RootScriptJob(SetupJob setupJob, String description, Filter filter, boolean executeScripts, String customRootScriptMessage) {
        super("rootscript", null, 0.05f);
        this.setDescription(description);
        this.setupJob = setupJob;
        this.filter = filter;
        this.executeRootScripts = executeScripts;
        this.setRetryEnabled(true);
        this.setRetriable(this);
        this.customRootScriptMessage = customRootScriptMessage;
        if (((SetupDriver)SetupDriver.getInstance()).getSetupMode() == SetupMode.SILENT) {
            this.putClientProperty("oracle.install.job.printProgresStatus", Boolean.FALSE);
        }
    }

    public void setSetupJob(SetupJob sJob) {
        this.setupJob = sJob;
    }

    public SetupJob getSetupJob() {
        return this.setupJob;
    }

    public boolean isExecuteRootScripts() {
        return this.executeRootScripts;
    }

    public String getCustomRootScriptMessage() {
        return this.customRootScriptMessage;
    }

    @Override
    public Callable<?> getWork() {
        return this;
    }

    @Override
    public Void call() throws Exception {
        this.call(false);
        return null;
    }

    private void call(boolean retry) throws Exception {
        this.setStatus(Status.INPROGRESS);
        OiifmIRootShInfo[] rootScripts = this.getRootScripts();
        logger.log(Level.INFO, "Number of scripts to be executed as root user = " + (rootScripts != null ? rootScripts.length : 0));
        boolean succeeded = true;
        if (rootScripts != null) {
            ArrayList<OiifmIRootShInfo> filteredRootScripts = new ArrayList<OiifmIRootShInfo>();
            ArrayList<OiifmIRootShInfo> choosenRootScripts = new ArrayList<OiifmIRootShInfo>();
            for (OiifmIRootShInfo rootScriptInfo : rootScripts) {
                if (this.filter == null || this.filter.accept(rootScriptInfo.getRootShLocation())) {
                    choosenRootScripts.add(rootScriptInfo);
                    continue;
                }
                filteredRootScripts.add(rootScriptInfo);
            }
            if (!choosenRootScripts.isEmpty() && !filteredRootScripts.isEmpty()) {
                this.setupJob.setRootScripts(filteredRootScripts.toArray(new OiifmIRootShInfo[0]));
            }
            if (this.executeRootScripts) {
                this.executeScripts(choosenRootScripts, retry);
                logger.log(Level.INFO, "Overall status of execution of root/configuration scripts : " + (this.getStatus() == Status.FAILED ? "failed" : "succeeded"));
            } else {
                Object driver = SetupDriver.getInstance();
                switch (((SetupDriver)driver).getSetupMode()) {
                    case SILENT: {
                        this.showTextually(choosenRootScripts);
                        break;
                    }
                    case INTERACTIVE: {
                        succeeded = this.showGraphically(choosenRootScripts);
                    }
                }
                if (succeeded) {
                    this.setStatus(Status.SUCCEEDED);
                } else {
                    this.setStatus(Status.FAILED);
                }
            }
            if (this.getStatus() != Status.SUCCEEDED) {
                Application.addExitStatus(Application.CommonExitStatus.FAILURE);
            } else {
                Application.removeExitStatus(Application.CommonExitStatus.FAILURE);
            }
        }
    }

    public OiifmIRootShInfo[] getRootScripts() {
        OiifmIRootShInfo[] rootScripts = this.setupJob.getRootScripts();
        return rootScripts;
    }

    public void setRootScripts(OiifmIRootShInfo[] rootScripts) {
        this.setupJob.setRootScripts(rootScripts);
    }

    public void setPromptForRootScript(String promptText) {
        this.promptForRootScript = promptText;
    }

    public void setExecutionStepsPromptForRootScript(String executionStepsText) {
        this.executionStepsPromptForRootScript = executionStepsText;
    }

    public void setOrderOfExectionPromptForRootScript(String orderOfExecutionText) {
        this.orderOfExectionPromptForRootScript = orderOfExecutionText;
    }

    protected boolean showGraphically(List<OiifmIRootShInfo> rootScripts) {
        Object setupDriver = SetupDriver.getInstance();
        ProgressUI progressUI = ((SetupDriver)setupDriver).getProgressUI();
        if (progressUI != null) {
            Object owner = progressUI.getOwner();
            if (owner instanceof Component) {
                Window window = SwingUtilities.windowForComponent((Component)owner);
                if (window instanceof Frame) {
                    boolean bool;
                    String orderOfExecutionMessage = null;
                    orderOfExecutionMessage = this.orderOfExectionPromptForRootScript != null ? this.orderOfExectionPromptForRootScript : this.customRootScriptMessage;
                    LinkedHashMap<String, List<String>> map = new LinkedHashMap<String, List<String>>();
                    for (OiifmIRootShInfo rootScript : rootScripts) {
                        String[] nodes = rootScript.getNodeList();
                        if (nodes != null && nodes.length > 0) {
                            List<String> currentNodeList = ((SetupDriver)setupDriver).getNodeList();
                            ArrayList<String> ouiNodeList = new ArrayList<String>();
                            ouiNodeList.addAll(Arrays.asList(nodes));
                            if (currentNodeList != null && !currentNodeList.isEmpty() && ouiNodeList != null && !ouiNodeList.isEmpty()) {
                                ouiNodeList.retainAll(currentNodeList);
                            }
                            if (ouiNodeList != null && !ouiNodeList.isEmpty()) {
                                map.put(rootScript.getRootShLocation(), ouiNodeList);
                                continue;
                            }
                            map.put(rootScript.getRootShLocation(), null);
                            continue;
                        }
                        map.put(rootScript.getRootShLocation(), null);
                    }
                    new ConfigurationScriptDialog((Frame)window, map, this.setupJob.isMultinodeSetup(), this.promptForRootScript, this.executionStepsPromptForRootScript, orderOfExecutionMessage).setVisible(true);
                    StatusMessages<ErrorMessage> messages = new StatusMessages<ErrorMessage>();
                    messages.addAll((Collection<ErrorMessage>)this.verify());
                    if (messages != null & messages.size() > 0 && (bool = this.showRootScriptWarning((Component)owner, messages))) {
                        return false;
                    }
                    logger.log(Level.INFO, "User accepted to run root scripts");
                }
            } else {
                this.showTextually(rootScripts);
            }
        }
        return true;
    }

    protected void showTextually(List<OiifmIRootShInfo> rootScripts) {
        Application application = Application.getInstance();
        String message = this.promptForRootScript;
        if (message == null) {
            message = application.getString(ResourceURL.resURL(DriverConstants.STRING_RESOURCE_BUNDLE_NAME, "rootScriptJob.message.header"), "", new Object[0]);
        }
        Console.println(message);
        Resource resource = application.getResource(StringResourceBundle.class.getName());
        int i = 0;
        for (OiifmIRootShInfo rootScript : rootScripts) {
            Console.println("\t" + ++i + ". " + rootScript.getRootShLocation());
        }
        Console.println("");
        for (OiifmIRootShInfo rootScript : rootScripts) {
            if (rootScript.getNodeList() == null || rootScript.getNodeList().length <= 0) continue;
            ArrayList<String> ouiNodeList = new ArrayList<String>();
            ouiNodeList.addAll(Arrays.asList(rootScript.getNodeList()));
            Object setupDriver = SetupDriver.getInstance();
            List<String> currentNodeList = ((SetupDriver)setupDriver).getNodeList();
            if (currentNodeList != null && !currentNodeList.isEmpty() && ouiNodeList != null && !ouiNodeList.isEmpty()) {
                ouiNodeList.retainAll(currentNodeList);
            }
            if (ouiNodeList == null || ouiNodeList.isEmpty()) continue;
            message = resource.getString("rootScriptJob.executeTxt", "Execute {0} on the following nodes: ", rootScript.getRootShLocation());
            System.out.println(message);
            System.out.println(ouiNodeList);
        }
        System.out.println("");
        if (this.orderOfExectionPromptForRootScript != null) {
            System.out.println(this.orderOfExectionPromptForRootScript);
        }
        if (this.customRootScriptMessage != null) {
            System.out.println(this.customRootScriptMessage);
        }
        System.out.println("");
    }

    public StatusMessages<ErrorMessage> verify() {
        Object driver = SetupDriver.getInstance();
        if (driver instanceof OUISetupDriver) {
            OUISetupDriver ouiSetupDriver = (OUISetupDriver)driver;
            return ouiSetupDriver.verifyInventoryUpdation(this.setupJob);
        }
        return null;
    }

    public boolean showRootScriptWarning(final Component owner, final StatusMessages<ErrorMessage> errorMessages) {
        this.retryRootScript = Advice.WITHDRAW;
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    RootScriptJob.this.retryRootScript = ExceptionManager.advise((Object)owner, errorMessages);
                }
            });
        }
        catch (InterruptedException e) {
            logger.log(Level.WARNING, "Exception occured while showing rootscript failure message");
            logger.log(Level.WARNING, e.getMessage());
        }
        catch (InvocationTargetException e) {
            logger.log(Level.WARNING, "Exception occured while showing rootscript failure message");
            logger.log(Level.WARNING, e.getMessage());
        }
        return this.retryRootScript == Advice.WITHDRAW || this.retryRootScript == Advice.ABORT;
    }

    @Override
    public List<Job> getRetriableJobs() {
        ArrayList<Job> retriableJobs = new ArrayList<Job>();
        List<Job> jobList = this.getJobs();
        if (jobList.size() > 0) {
            for (Job job : jobList) {
                Status status = job.getStatus();
                if (!job.isRetryEnabled() || status != Status.PENDING && status != Status.FAILED) continue;
                logger.log(Level.INFO, "Selecting job named ''{0}'' for retry", job.getDescription());
                retriableJobs.add(job);
            }
        } else {
            Status status = this.getStatus();
            if (this.isRetryEnabled() && (status == Status.PENDING || status == Status.FAILED)) {
                retriableJobs.add(this);
            }
        }
        return retriableJobs;
    }

    @Override
    public void retry() throws Exception {
        this.call(true);
    }

    public void executeScripts(List<OiifmIRootShInfo> rootScripts, boolean retry) throws Exception {
        Object driver = SetupDriver.getInstance();
        if (driver instanceof OUISetupDriver) {
            OUISetupDriver ouiSetupDriver = (OUISetupDriver)driver;
            ouiSetupDriver.executeRootScripts(rootScripts, this, retry);
        }
    }

    protected void doPostRootScriptAction() {
    }

    public static interface Filter {
        public boolean accept(String var1);
    }

    public static class InventoryFilter
    implements Filter {
        private String path;

        public InventoryFilter(String path) {
            this.path = path;
        }

        @Override
        public boolean accept(String script) {
            return script != null && this.path != null && script.trim().startsWith(this.path.trim());
        }
    }
}

