/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.asm.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import oracle.install.asm.bean.ASMInputValidationErrorCode;
import oracle.install.asm.bean.DiskGroupSettings;
import oracle.install.asm.util.FailureGroup;
import oracle.install.commons.swing.ComboBoxTableCellEditor;
import oracle.install.commons.swing.HidableTableColumnModel;
import oracle.install.commons.swing.LayoutUtils;
import oracle.install.commons.swing.MultilineLabel;
import oracle.install.commons.swing.StandardDialog;
import oracle.install.commons.swing.SwingUtils;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.Resource;
import oracle.install.commons.util.exception.ErrorCode;

public class FailureGroupsDialog
extends JDialog {
    private Logger logger = Logger.getLogger(FailureGroupsDialog.class.getName());
    private static final long serialVersionUID = 1L;
    private MultilineLabel lblDescription;
    private JButton btnOk;
    private JButton btnCancel;
    private JTable tblFailureGroups;
    private Frame owner;
    private String[] strColHeader = new String[3];
    private List<FailureGroup> specifiedFailureGroups = new ArrayList<FailureGroup>();
    private JComboBox cbxSites;
    private ComboBoxModel sitesComboBoxModel;
    private HidableTableColumnModel hideableColumnModel;
    private FGTableModel failureGroupsTableModel;
    private DiskGroupSettings diskGroupSettings;
    Resource resource;
    private SitesRendererModel sitesCbxRenderer;

    public FailureGroupsDialog(Frame owner, DiskGroupSettings DGSettings) {
        this.logger.log(Level.INFO, "SpecifyFailureGroupsDialog Entering Constructor");
        Application application = Application.getInstance();
        this.resource = application.getResource("oracle.install.asm.resource.StringResourceBundle");
        this.owner = owner;
        this.diskGroupSettings = DGSettings;
        this.buildFGTableUI();
    }

    private void buildFGTableUI() {
        this.lblDescription = new MultilineLabel();
        this.btnOk = new JButton();
        this.btnOk.setName("SpecifyFailureGroupsDialog.btnOk");
        this.btnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FailureGroupsDialog.this.acceptInput();
            }
        });
        this.btnCancel = new JButton();
        this.btnCancel.setName("SpecifyFailureGroupsDialog.btnCancel");
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FailureGroupsDialog.this.discardInput();
            }
        });
        this.failureGroupsTableModel = new FGTableModel(this.strColHeader);
        this.hideableColumnModel = new HidableTableColumnModel();
        this.specifiedFailureGroups = this.diskGroupSettings.getFailureGroupsList();
        this.failureGroupsTableModel.setFailureGroups(this.specifiedFailureGroups);
        this.tblFailureGroups = new JTable();
        this.tblFailureGroups.setName("SpecifyFailureGroupsDialog.tblFailureDisks");
        this.tblFailureGroups.setSelectionMode(0);
        this.tblFailureGroups.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        JScrollPane scrollPane = new JScrollPane(this.tblFailureGroups);
        scrollPane.getViewport().setBackground(this.tblFailureGroups.getBackground());
        this.tblFailureGroups.setModel(this.failureGroupsTableModel);
        this.tblFailureGroups.setColumnModel((TableColumnModel)this.hideableColumnModel);
        this.tblFailureGroups.createDefaultColumnsFromModel();
        this.tblFailureGroups.getTableHeader().setReorderingAllowed(false);
        this.tblFailureGroups.getTableHeader().setBorder(BorderFactory.createRaisedBevelBorder());
        TableColumnModel tColumnModel = this.tblFailureGroups.getColumnModel();
        TableColumn column = tColumnModel.getColumn(0);
        column.setPreferredWidth(120);
        column = tColumnModel.getColumn(1);
        column.setMaxWidth(60);
        column.setCellRenderer(new QuorumFGSelectionRendererModel());
        column = tColumnModel.getColumn(2);
        this.sitesCbxRenderer = new SitesRendererModel(new String[0]);
        column.setCellRenderer(this.sitesCbxRenderer);
        this.cbxSites = new JComboBox();
        column.setCellEditor((TableCellEditor)new ComboBoxTableCellEditor(this.cbxSites));
        this.sitesComboBoxModel = new DefaultComboBoxModel();
        this.cbxSites.setModel(this.sitesComboBoxModel);
        SwingUtils.setRowWiseFocusTraveralEnabled((JTable)this.tblFailureGroups, (boolean)true);
        JPanel pnlFailureGroupsAndSites = new JPanel(new GridBagLayout());
        LayoutUtils.addComponent((Component)this.lblDescription, (Container)pnlFailureGroupsAndSites, (int)0, (int)0, (int)4, (int)1, (int)1, (int)21, (double)0.0, (double)0.0, (Insets)LayoutUtils.STANDARD_INSETS);
        LayoutUtils.addComponent((Component)scrollPane, (Container)pnlFailureGroupsAndSites, (int)0, (int)1, (int)4, (int)1, (int)1, (int)21, (double)1.0, (double)1.0, (Insets)LayoutUtils.STANDARD_INSETS);
        LayoutUtils.addComponent((Component)this.btnOk, (Container)pnlFailureGroupsAndSites, (int)1, (int)2, (int)1, (int)1, (int)0, (int)13, (double)0.5, (double)0.0, (Insets)LayoutUtils.STANDARD_INSETS);
        LayoutUtils.addComponent((Component)this.btnCancel, (Container)pnlFailureGroupsAndSites, (int)2, (int)2, (int)1, (int)1, (int)0, (int)17, (double)0.5, (double)0.0, (Insets)LayoutUtils.STANDARD_INSETS);
        this.getContentPane().add(pnlFailureGroupsAndSites);
        this.setLocalizedTexts();
        this.pack();
        this.setSize(300, 300);
        this.setResizable(false);
        this.setLocationRelativeTo(this.owner);
        this.setDefaultCloseOperation(1);
        this.setModal(true);
    }

    private void setLocalizedTexts() {
        this.setTitle(this.resource.getString("SpecifyFailureGroupsDialog.title", "Failure Groups", new Object[0]));
        this.lblDescription.setText(this.resource.getString("SpecifyFailureGroupsDialog.lblDescription.text", "Specify the unique Failure Groups to be used for ASM Disks. Select Failure Groups that you want to mark as Quorum.", new Object[0]));
        String text = this.resource.getString("SpecifyFailureGroupsDialog.ok", "&OK*", new Object[0]);
        SwingUtils.setText((AbstractButton)this.btnOk, (String)text);
        text = this.resource.getString("SpecifyFailureGroupsDialog.cancel", "Cancel*", new Object[0]);
        SwingUtils.setText((AbstractButton)this.btnCancel, (String)text);
        this.strColHeader[0] = text = this.resource.getString("SpecifyFailureGroupsDialog.tblFailureGroups.column.failureGroups", "Failure Groups", new Object[0]);
        this.strColHeader[1] = text = this.resource.getString("SpecifyFailureGroupsDialog.tblFailureGroups.column.quorum", "Quorum", new Object[0]);
        this.strColHeader[2] = text = this.resource.getString("SpecifyFailureGroupsDialog.tblFailureGroups.column.sites", "Site", new Object[0]);
        this.setTableColumnNames();
    }

    private void setTableColumnNames() {
        TableColumnModel tcm = this.tblFailureGroups.getColumnModel();
        for (int iLoop = 0; iLoop < tcm.getColumnCount(); ++iLoop) {
            tcm.getColumn(iLoop).setHeaderValue(this.strColHeader[iLoop]);
        }
    }

    protected void discardInput() {
        int row = this.tblFailureGroups.getEditingRow();
        int column = this.tblFailureGroups.getEditingColumn();
        if (row != -1 && column != -1) {
            this.tblFailureGroups.getCellEditor(row, column).cancelCellEditing();
        }
        if (this.failureGroupsTableModel.failureGroups == null) {
            this.failureGroupsTableModel.failureGroups = new ArrayList();
        } else {
            this.failureGroupsTableModel.failureGroups.clear();
        }
        if (this.failureGroupsTableModel.prevFailureGroups != null && this.failureGroupsTableModel.prevFailureGroups.size() > 0) {
            for (FailureGroup fg : this.failureGroupsTableModel.prevFailureGroups) {
                this.failureGroupsTableModel.failureGroups.add((FailureGroup)fg.clone());
            }
        } else {
            this.failureGroupsTableModel.failureGroups.add(new FailureGroup("", false));
        }
        this.failureGroupsTableModel.fireTableDataChanged();
        this.setVisible(false);
    }

    protected void acceptInput() {
        int row = this.tblFailureGroups.getEditingRow();
        int column = this.tblFailureGroups.getEditingColumn();
        if (row != -1 && column != -1) {
            this.tblFailureGroups.getCellEditor(row, column).stopCellEditing();
        }
        this.processInput();
        if (this.failureGroupsTableModel.prevFailureGroups == null) {
            this.failureGroupsTableModel.prevFailureGroups = new ArrayList();
        } else {
            this.failureGroupsTableModel.prevFailureGroups.clear();
        }
        if (this.failureGroupsTableModel.failureGroups != null && this.failureGroupsTableModel.failureGroups.size() > 0) {
            for (FailureGroup fg : this.failureGroupsTableModel.failureGroups) {
                this.failureGroupsTableModel.prevFailureGroups.add((FailureGroup)fg.clone());
            }
        } else {
            this.failureGroupsTableModel.prevFailureGroups.clear();
        }
        if (!this.validateForDuplicates()) {
            this.setVisible(false);
        }
    }

    protected void processInput() {
        this.specifiedFailureGroups = this.failureGroupsTableModel.getFailureGroups();
        for (FailureGroup fg : this.specifiedFailureGroups) {
            this.logger.log(Level.INFO, "Failure Group Name: " + fg.getFailureGroupName() + " isQuorum : " + fg.isQuorum());
        }
    }

    private boolean validateForDuplicates() {
        String failureGroupName = null;
        int iSize = 0;
        if (this.specifiedFailureGroups != null && !this.specifiedFailureGroups.isEmpty()) {
            iSize = this.specifiedFailureGroups.size();
        }
        for (int iLoop = 0; iLoop < iSize; ++iLoop) {
            failureGroupName = this.specifiedFailureGroups.get(iLoop).getFailureGroupName();
            for (int i = 0; i < iSize; ++i) {
                if (i == iLoop || failureGroupName == null || failureGroupName.trim().length() <= 0 || !failureGroupName.equalsIgnoreCase(this.specifiedFailureGroups.get(i).getFailureGroupName())) continue;
                StandardDialog.showError((Component)this, (ErrorCode)ASMInputValidationErrorCode.ASM_DUPLICATE_FAILURE_GROUP_NAME_FOUND, (Object[])new Object[]{failureGroupName});
                return true;
            }
        }
        return false;
    }

    public DiskGroupSettings getDiskGroupSettings() {
        return this.diskGroupSettings;
    }

    public void setDiskGroupSettings(DiskGroupSettings diskGroupSettings) {
        this.diskGroupSettings = diskGroupSettings;
    }

    public List<FailureGroup> getSpecifiedFailureGroups() {
        return this.specifiedFailureGroups;
    }

    public void setExtendedCluster(boolean extendedCluster) {
        this.hideableColumnModel.setColumnVisible(this.hideableColumnModel.getColumnByModelIndex(2), extendedCluster);
    }

    public void setSites(List<String> sites) {
        this.cbxSites.removeAllItems();
        if (sites != null && sites.size() > 0) {
            for (String s : sites) {
                this.cbxSites.addItem(s);
            }
        }
        this.cbxSites.insertItemAt("", 0);
        this.sitesCbxRenderer.updateValuesForCbx(sites);
    }

    private class QuorumFGSelectionRendererModel
    implements TableCellRenderer {
        private static final long serialVersionUID = 1L;
        JCheckBox chkBxQuorumFGSelection = new JCheckBox();

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int iRow, int iCol) {
            if (table == null || value == null) {
                return null;
            }
            this.chkBxQuorumFGSelection.setHorizontalAlignment(0);
            this.chkBxQuorumFGSelection.setSelected((Boolean)value);
            this.chkBxQuorumFGSelection.setEnabled(table.getModel().isCellEditable(iRow, iCol));
            if (isSelected) {
                this.chkBxQuorumFGSelection.setForeground(table.getSelectionForeground());
                this.chkBxQuorumFGSelection.setBackground(table.getSelectionBackground());
            } else {
                this.chkBxQuorumFGSelection.setForeground(table.getForeground());
                this.chkBxQuorumFGSelection.setBackground(table.getBackground());
            }
            return this.chkBxQuorumFGSelection;
        }
    }

    private class SitesRendererModel
    implements TableCellRenderer {
        private JComboBox cbxSites;

        public SitesRendererModel(String[] values) {
            this.cbxSites = new JComboBox<String>(values);
            this.cbxSites.setEditable(false);
            if (values.length > 0) {
                this.cbxSites.setSelectedIndex(0);
            }
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int rowIndex, int vColIndex) {
            if (isSelected) {
                this.cbxSites.setForeground(table.getSelectionForeground());
                this.cbxSites.setBackground(table.getSelectionBackground());
            } else {
                this.cbxSites.setForeground(table.getForeground());
                this.cbxSites.setBackground(table.getBackground());
            }
            this.cbxSites.setSelectedItem((String)value);
            return this.cbxSites;
        }

        public void updateValuesForCbx(List<String> sites) {
            this.cbxSites.removeAllItems();
            this.cbxSites.insertItemAt("", 0);
            if (sites != null && sites.size() > 0) {
                for (String s : sites) {
                    this.cbxSites.addItem(s);
                }
            }
        }
    }

    private class FGTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        private List<FailureGroup> failureGroups;
        private List<FailureGroup> prevFailureGroups;
        private String[] columnNames;
        private final Class[] columnClass = new Class[]{String.class, Boolean.class, String.class};

        public FGTableModel(String[] columnHeaders) {
            this.columnNames = columnHeaders;
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public int getRowCount() {
            if (this.failureGroups != null) {
                return this.failureGroups.size();
            }
            return 0;
        }

        @Override
        public Class<?> getColumnClass(int iCol) {
            return this.columnClass[iCol];
        }

        @Override
        public boolean isCellEditable(int iRow, int iCol) {
            FailureGroup failureGroup = this.failureGroups.get(iRow);
            boolean editable = false;
            switch (iCol) {
                case 0: {
                    editable = true;
                    break;
                }
                case 1: 
                case 2: {
                    if (failureGroup.getFailureGroupName() == null || failureGroup.getFailureGroupName().length() <= 0) break;
                    editable = true;
                }
            }
            return editable;
        }

        @Override
        public Object getValueAt(int iRow, int iCol) {
            Object value = null;
            if (this.failureGroups.size() > iRow) {
                switch (iCol) {
                    case 0: {
                        value = this.failureGroups.get(iRow).getFailureGroupName().trim();
                        break;
                    }
                    case 1: {
                        value = this.failureGroups.get(iRow).isQuorum();
                        break;
                    }
                    case 2: {
                        value = this.failureGroups.get(iRow).getSite();
                    }
                }
            }
            return value;
        }

        @Override
        public void setValueAt(Object aValue, int iRow, int iCol) {
            FailureGroup failureGroup = this.failureGroups.get(iRow);
            switch (iCol) {
                case 0: {
                    if (aValue == null) break;
                    failureGroup.setFailureGroupName(((String)aValue).trim());
                    this.cellEditing(iRow, iCol);
                    break;
                }
                case 1: {
                    if (aValue == Boolean.TRUE) {
                        failureGroup.setQuorum(true);
                        break;
                    }
                    failureGroup.setQuorum(false);
                    break;
                }
                case 2: {
                    failureGroup.setSite((String)aValue);
                }
            }
            this.fireTableDataChanged();
        }

        public List<FailureGroup> getFailureGroups() {
            return this.failureGroups;
        }

        public void setFailureGroups(List<FailureGroup> failureGroupsList) {
            if (failureGroupsList != null && failureGroupsList.size() > 0) {
                this.failureGroups = failureGroupsList;
                FailureGroup failureGroup = new FailureGroup("", false, "");
                this.failureGroups.add(failureGroup);
            } else {
                this.failureGroups = new ArrayList<FailureGroup>();
                FailureGroup failureGroup = new FailureGroup("", false, "");
                this.failureGroups.add(failureGroup);
            }
            this.updatePrevFailureGroups();
            this.fireTableDataChanged();
        }

        private void updatePrevFailureGroups() {
            if (this.failureGroups != null && this.failureGroups.size() > 0) {
                if (this.prevFailureGroups == null) {
                    this.prevFailureGroups = new ArrayList<FailureGroup>();
                }
                for (FailureGroup fg : this.failureGroups) {
                    this.prevFailureGroups.add((FailureGroup)fg.clone());
                }
            }
        }

        public void cellEditing(int row, int col) {
            if (row > this.failureGroups.size() - 1) {
                return;
            }
            if (row == this.failureGroups.size() - 1) {
                if (col == 0) {
                    FailureGroup failureGroup = new FailureGroup();
                    failureGroup.setFailureGroupName("");
                    failureGroup.setQuorum(false);
                    this.failureGroups.add(failureGroup);
                }
            } else {
                for (int i = 0; i < this.failureGroups.size() - 1; ++i) {
                    FailureGroup failureGroup = this.failureGroups.get(i);
                    if (!failureGroup.getFailureGroupName().equals("")) continue;
                    this.failureGroups.remove(i);
                }
            }
            this.fireTableDataChanged();
        }
    }
}

